/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ProgressGlassPane
extends JComponent {
    private static final int DEF_BAR_WIDTH = 400;
    private static final int DEF_BAR_HEIGHT = 20;
    private static final Color GRADIENT_COLOR1 = Color.DARK_GRAY;
    private static final Color GRADIENT_COLOR2 = Color.WHITE;
    private int progress = -1;
    private int textOffset = 50;
    private Color color = new Color(30, 144, 255);
    private int barWidth = 400;
    private int barHeight = 20;

    public ProgressGlassPane() {
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Default", 1, 16));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
    }

    public void setProgress(int progress) {
        int oldProgress = this.progress;
        this.progress = progress;
        if (progress > -1 && progress < 101) {
            Graphics g;
            this.progress = Math.min(100, this.progress);
            Dimension size = this.getSize();
            if (size.width < this.barWidth) {
                this.barWidth = size.width - 20;
            }
            if ((g = this.getGraphics()) != null) {
                FontMetrics metrics = g.getFontMetrics(this.getFont());
                int w = (int)((float)this.barWidth * ((float)oldProgress / 100.0f));
                int x = w + (this.getWidth() - this.barWidth) / 2;
                int y = (this.getHeight() - this.barHeight) / 2;
                y += metrics.getDescent() / 2;
                w = (int)((float)this.barWidth * ((float)this.progress / 100.0f)) - w;
                int h = this.barHeight;
                this.repaint(x, y += this.textOffset, x + this.barWidth, h + 1);
            }
        }
    }

    protected Rectangle getProgressBarRect() {
        int x = (this.getWidth() - this.barWidth) / 2;
        int y = (this.getHeight() - this.barHeight) / 2;
        FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
        y += metrics.getDescent() / 2;
        return new Rectangle(x, y += this.textOffset, this.barWidth, this.barHeight + 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.progress > -1) {
            Dimension size = this.getSize();
            if (size.width < this.barWidth || this.barWidth < 10) {
                this.barWidth = size.width - size.width / 2;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite composite = g2.getComposite();
            AlphaComposite alpha = AlphaComposite.SrcOver.derive(1.0f);
            g2.setComposite(alpha);
            FontMetrics metrics = g.getFontMetrics();
            int x = (this.getWidth() - this.barWidth) / 2;
            int y = (this.getHeight() - this.barHeight - metrics.getDescent()) / 2;
            y += this.textOffset;
            int w = (int)((float)this.barWidth * ((float)this.progress / 100.0f));
            int h = this.barHeight;
            Paint paint = g2.getPaint();
            GradientPaint gradient = new GradientPaint(x, y += metrics.getDescent(), GRADIENT_COLOR1, x, y + h, GRADIENT_COLOR2);
            g2.setPaint(gradient);
            g2.fillRect(x, y, this.barWidth, this.barHeight);
            g2.setComposite(AlphaComposite.SrcOver.derive(1.0f));
            Color grad_top = this.color.brighter();
            Color grad_bot = this.color.darker();
            GradientPaint bg = new GradientPaint(new Point(x, y), grad_top, new Point(x, y + h), grad_bot);
            g2.setPaint(bg);
            g2.fillRect(x, y, w, h);
            g2.setPaint(paint);
            g2.drawRect(x, y, this.barWidth, this.barHeight);
            g2.setComposite(composite);
        }
    }
}

