/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.commons.lang.StringUtils;

public class ProgressFrame
extends JFrame {
    protected JProgressBar overallProgress;
    protected JProgressBar processProgress;
    protected JLabel desc;
    protected JLabel overallLbl;
    protected JButton closeBtn;
    protected JFrame instance;
    protected boolean isProcessPercent = false;
    protected int origMax = 0;

    public ProgressFrame(String title) {
        this.createUI(title, null);
    }

    public ProgressFrame(String title, String iconName) {
        this.createUI(title, iconName);
    }

    protected void createUI(String title, String iconName) {
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,5px,p,5px,p,10px,p"));
        CellConstraints cc = new CellConstraints();
        this.overallProgress = new JProgressBar();
        this.processProgress = new JProgressBar();
        this.desc = UIHelper.createLabel("");
        this.closeBtn = UIHelper.createButton("Cancel");
        this.processProgress.setStringPainted(true);
        this.overallProgress.setStringPainted(true);
        this.desc.setHorizontalAlignment(0);
        builder.add((Component)this.desc, cc.xywh(1, 1, 3, 1));
        builder.add((Component)UIHelper.createLabel("Process:"), cc.xy(1, 3));
        builder.add((Component)this.processProgress, cc.xy(3, 3));
        this.overallLbl = UIHelper.createLabel("Overall:");
        builder.add((Component)this.overallLbl, cc.xy(1, 5));
        builder.add((Component)this.overallProgress, cc.xy(3, 5));
        builder.add((Component)this.closeBtn, cc.xy(1, 7));
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel mainPanel = new JPanel(new BorderLayout());
        if (StringUtils.isNotEmpty((String)iconName)) {
            PanelBuilder iconBldr = new PanelBuilder(new FormLayout("8px, f:p:g,130px,f:p:g", "8px,f:p:g,130px,f:p:g, 8px"));
            iconBldr.add((Component)new JLabel(IconManager.getIcon(iconName)), cc.xy(3, 3));
            mainPanel.add((Component)iconBldr.getPanel(), "West");
            mainPanel.add((Component)builder.getPanel(), "Center");
        } else {
            mainPanel = builder.getPanel();
        }
        this.setContentPane(mainPanel);
        this.setSize(new Dimension(500, 125));
        this.setTitle(title);
        this.overallProgress.setIndeterminate(true);
        this.instance = this;
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressFrame.this.instance.setVisible(false);
                System.exit(0);
            }
        });
        this.setDefaultCloseOperation(2);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
        this.pack();
    }

    public void adjustProgressFrame() {
        this.setDefaultCloseOperation(0);
        this.pack();
        Dimension size = this.getSize();
        size.width = Math.max(size.width + 100, 600);
        size.height += 20;
        this.setSize(size);
    }

    public void turnOffOverAll() {
        this.overallProgress.setVisible(false);
        this.overallLbl.setVisible(false);
    }

    public void turnOnOverAll() {
        this.overallProgress.setVisible(true);
        this.overallLbl.setVisible(true);
    }

    public synchronized void incOverall() {
        this.overallProgress.setValue(this.overallProgress.getValue() + 1);
    }

    public synchronized void setOverall(int min, int max) {
        this.overallProgress.setIndeterminate(min == 0 && max == 0);
        this.overallProgress.setMinimum(min);
        this.overallProgress.setMaximum(max);
        this.overallProgress.setValue(min);
    }

    public synchronized void setOverall(int value) {
        this.overallProgress.setValue(value);
    }

    public synchronized int getOrigMax() {
        return this.origMax;
    }

    public synchronized void setOrigMax(int origMax) {
        this.origMax = origMax;
    }

    public synchronized void setProcess(int min, int max) {
        this.processProgress.setMinimum(this.isProcessPercent ? 0 : min);
        this.processProgress.setMaximum(this.isProcessPercent ? 100 : max);
        this.processProgress.setValue(min);
        this.processProgress.setString("");
        this.origMax = max;
    }

    public synchronized void setProcess(int value) {
        if (this.processProgress.isIndeterminate()) {
            this.processProgress.setIndeterminate(false);
        }
        if (this.isProcessPercent) {
            if (value > this.origMax || value < 0) {
                this.processProgress.setString("100%");
            } else {
                int percent = (int)((double)value / (double)this.origMax * 100.0);
                this.processProgress.setValue(percent);
                this.processProgress.setString(value > 0 ? String.valueOf(Integer.toString(percent)) + "%" : "");
            }
        } else {
            int maxVal = this.processProgress.getMaximum();
            if (value >= maxVal) {
                this.processProgress.setString(String.valueOf(maxVal) + " / " + maxVal);
            } else {
                this.processProgress.setValue(value);
                this.processProgress.setString(value > 0 ? String.valueOf(this.processProgress.getValue()) + " / " + this.processProgress.getMaximum() : "");
            }
        }
    }

    public synchronized void setDesc(String text) {
        this.desc.setText(text);
    }

    public synchronized void processDone() {
        this.desc.setText(" ");
        this.processProgress.setMinimum(0);
        this.processProgress.setMaximum(0);
        this.processProgress.setValue(0);
        this.processProgress.setString(" ");
        this.closeBtn.setText("Done");
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public boolean isProcessPercent() {
        return this.isProcessPercent;
    }

    public void setProcessPercent(boolean isProcessPercent) {
        this.isProcessPercent = isProcessPercent;
    }

    public JProgressBar getProcessProgress() {
        return this.processProgress;
    }
}

