/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    protected JProgressBar overallProgress;
    protected JProgressBar processProgress;
    protected JLabel desc;
    protected JButton closeBtn;
    protected boolean isProcessPercent = false;
    protected int origMax = 0;

    public ProgressDialog(String title, boolean includeBothBars, boolean includeClose) {
        String rowDef = "p,5px" + (includeBothBars ? ",p,5px" : "") + (includeClose ? ",p,10px" : "") + ",p";
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,f:p:g", rowDef));
        CellConstraints cc = new CellConstraints();
        int y = 1;
        this.overallProgress = UIHelper.createProgressBar();
        this.desc = UIHelper.createLabel("");
        this.desc.setHorizontalAlignment(0);
        builder.add((Component)this.desc, cc.xywh(1, y, 3, 1));
        this.processProgress = UIHelper.createProgressBar();
        this.processProgress.setStringPainted(true);
        builder.add((Component)UIHelper.createLabel("Process:"), cc.xy(1, y += 2));
        builder.add((Component)this.processProgress, cc.xy(3, y));
        y += 2;
        if (includeBothBars) {
            builder.add((Component)UIHelper.createLabel("Overall:"), cc.xy(1, y));
            builder.add((Component)this.overallProgress, cc.xy(3, y));
            y += 2;
            this.overallProgress.setIndeterminate(true);
        }
        UIHelper.createLabel("");
        if (includeClose) {
            this.closeBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
            builder.add((Component)this.closeBtn, cc.xy(1, y));
            y += 2;
        }
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(builder.getPanel());
        this.pack();
        Dimension size = this.getPreferredSize();
        this.setSize(new Dimension(500, size.height + 20));
        this.setTitle(title);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
        if (this.closeBtn != null) {
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.setVisible(false);
                }
            });
        }
    }

    public synchronized void incOverall() {
        if (this.overallProgress != null) {
            this.overallProgress.setValue(this.overallProgress.getValue() + 1);
        }
    }

    public synchronized void setOverall(int min, int max) {
        if (this.overallProgress != null) {
            this.overallProgress.setIndeterminate(min == 0 && max == 0);
            this.overallProgress.setMinimum(min);
            this.overallProgress.setMaximum(max);
            this.overallProgress.setValue(min);
        }
    }

    public synchronized void setOverall(int value) {
        if (this.overallProgress != null) {
            this.overallProgress.setValue(value);
        }
    }

    public synchronized int getOverall() {
        return this.overallProgress.getValue();
    }

    public synchronized void setProcess(int min, int max) {
        this.processProgress.setMinimum(this.isProcessPercent ? 0 : min);
        this.processProgress.setMaximum(this.isProcessPercent ? 100 : max);
        this.processProgress.setValue(min);
        this.processProgress.setString("");
        this.origMax = max;
    }

    public synchronized void setProcess(int value) {
        if (this.processProgress.isIndeterminate()) {
            this.processProgress.setIndeterminate(false);
        }
        if (this.isProcessPercent) {
            int percent = (int)((double)value / (double)this.origMax * 100.0);
            this.processProgress.setValue(percent);
            this.processProgress.setString(value > 0 ? String.valueOf(Integer.toString(percent)) + "%" : "");
        } else {
            this.processProgress.setValue(value);
            this.processProgress.setString(value > 0 ? String.valueOf(this.processProgress.getValue()) + " / " + this.processProgress.getMaximum() : "");
        }
    }

    public synchronized int getProcess() {
        return this.processProgress.getValue();
    }

    public synchronized void setDesc(String text) {
        this.desc.setText(text);
    }

    public synchronized void processDone() {
        this.desc.setText(" ");
        this.processProgress.setMinimum(0);
        this.processProgress.setMaximum(0);
        this.processProgress.setValue(0);
        this.processProgress.setString(" ");
        if (this.closeBtn != null) {
            this.closeBtn.setText(UIRegistry.getResourceString("DONE"));
        }
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public boolean isProcessPercent() {
        return this.isProcessPercent;
    }

    public void setProcessPercent(boolean isProcessPercent) {
        this.isProcessPercent = isProcessPercent;
    }

    public JProgressBar getProcessProgress() {
        return this.processProgress;
    }
}

