/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.IconTray;
import edu.ku.brc.ui.ReorderableTrayListModel;
import edu.ku.brc.util.Orderable;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OrderedIconTray
extends IconTray
implements ActionListener,
ListSelectionListener {
    protected JPanel southPanel;
    protected JButton toStartButton;
    protected JButton moveLeftButton;
    protected JButton moveRightButton;
    protected JButton toEndButton;
    protected JButton[] orderButtons;
    protected boolean isOrderable = true;

    public OrderedIconTray(int layoutStyle) {
        super(layoutStyle);
        this.listModel = new ReorderableTrayListModel();
        this.iconListWidget.setModel(this.listModel);
        this.iconListWidget.addListSelectionListener(this);
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new BoxLayout(this.southPanel, 2));
        this.toStartButton = new JButton(IconManager.getIcon("FirstRec", IconManager.IconSize.NonStd));
        this.toStartButton.setSize(20, 20);
        this.toStartButton.setToolTipText("Move selection to first position");
        this.moveLeftButton = new JButton(IconManager.getIcon("PrevRec", IconManager.IconSize.NonStd));
        this.moveLeftButton.setSize(20, 20);
        this.moveLeftButton.setToolTipText("Move selection left one position");
        this.moveRightButton = new JButton(IconManager.getIcon("NextRec", IconManager.IconSize.NonStd));
        this.moveRightButton.setSize(20, 20);
        this.moveRightButton.setToolTipText("Move selection right one position");
        this.toEndButton = new JButton(IconManager.getIcon("LastRec", IconManager.IconSize.NonStd));
        this.toEndButton.setSize(20, 20);
        this.toEndButton.setToolTipText("Move selection to last position");
        this.orderButtons = new JButton[4];
        this.orderButtons[0] = this.toStartButton;
        this.orderButtons[1] = this.moveLeftButton;
        this.orderButtons[2] = this.moveRightButton;
        this.orderButtons[3] = this.toEndButton;
        this.valueChanged(null);
        this.toStartButton.addActionListener(this);
        this.moveLeftButton.addActionListener(this);
        this.moveRightButton.addActionListener(this);
        this.toEndButton.addActionListener(this);
        this.southPanel.add(Box.createHorizontalGlue());
        this.southPanel.add(this.toStartButton);
        this.southPanel.add(this.moveLeftButton);
        this.southPanel.add(this.moveRightButton);
        this.southPanel.add(this.toEndButton);
        this.southPanel.add(Box.createHorizontalGlue());
        this.add((Component)this.southPanel, "South");
    }

    public void enableOrderButtons(boolean enable) {
        this.toStartButton.setEnabled(enable);
        this.moveLeftButton.setEnabled(enable);
        this.moveRightButton.setEnabled(enable);
        this.toEndButton.setEnabled(enable);
    }

    public void setOrderable(boolean isOrderable) {
        this.isOrderable = isOrderable;
        if (!isOrderable) {
            this.southPanel.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReorderableTrayListModel model = (ReorderableTrayListModel)this.listModel;
        if (e.getSource() == this.toStartButton) {
            int selection = this.iconListWidget.getSelectedIndex();
            if (selection == -1) {
                return;
            }
            model.moveToStart(selection);
            this.iconListWidget.setSelectedIndex(0);
            Rectangle selRect = this.iconListWidget.getUI().getCellBounds(this.iconListWidget, selection - 1, selection - 1);
            if (selRect != null) {
                this.listScrollPane.scrollRectToVisible(selRect);
            }
            this.setOrderIndices();
            return;
        }
        if (e.getSource() == this.moveLeftButton) {
            int selection = this.iconListWidget.getSelectedIndex();
            if (selection == -1) {
                return;
            }
            model.shiftLeft(selection);
            if (selection != 0) {
                this.iconListWidget.setSelectedIndex(selection - 1);
                Rectangle selRect = this.iconListWidget.getUI().getCellBounds(this.iconListWidget, 0, 0);
                if (selRect != null) {
                    this.listScrollPane.scrollRectToVisible(selRect);
                }
            }
            this.setOrderIndices();
            return;
        }
        if (e.getSource() == this.moveRightButton) {
            int selection = this.iconListWidget.getSelectedIndex();
            if (selection == -1) {
                return;
            }
            model.shiftRight(selection);
            if (selection != model.getSize() - 1) {
                this.iconListWidget.setSelectedIndex(selection + 1);
                Rectangle selRect = this.iconListWidget.getUI().getCellBounds(this.iconListWidget, selection + 1, selection + 1);
                if (selRect != null) {
                    this.listScrollPane.scrollRectToVisible(selRect);
                }
            }
            this.setOrderIndices();
            return;
        }
        if (e.getSource() == this.toEndButton) {
            int selection = this.iconListWidget.getSelectedIndex();
            if (selection == -1) {
                return;
            }
            model.moveToEnd(selection);
            this.iconListWidget.setSelectedIndex(model.getSize() - 1);
            Rectangle selRect = this.iconListWidget.getUI().getCellBounds(this.iconListWidget, model.getSize() - 1, model.getSize() - 1);
            if (selRect != null) {
                this.listScrollPane.scrollRectToVisible(selRect);
            }
            this.setOrderIndices();
            return;
        }
    }

    protected synchronized void setOrderIndices() {
        int i = 0;
        while (i < this.listModel.getSize()) {
            Object o = this.listModel.getElementAt(i);
            if (o instanceof Orderable) {
                Orderable orderable = (Orderable)o;
                orderable.setOrderIndex(i);
            }
            this.firePropertyChange("item order", true, false);
            ++i;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean enable = true;
        if (this.iconListWidget.getSelectedIndex() == -1) {
            enable = false;
        }
        JButton[] jButtonArray = this.orderButtons;
        int n = this.orderButtons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.setEnabled(enable);
            ++n2;
        }
    }

    @Override
    public synchronized void addItem(FormDataObjIFace item) {
        this.listModel.add(item);
        if (this.isOrderable) {
            this.setOrderIndices();
        }
    }
}

