/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.util.Pair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class MultiStateToggleButton
extends JButton {
    protected List<String> stateNames = new Vector<String>();
    protected List<Icon> icons = new Vector<Icon>();
    protected int currentIndex = 0;

    public MultiStateToggleButton(Pair<Icon, String> ... iconsAndNames) {
        Pair<Icon, String>[] pairArray = iconsAndNames;
        int n = iconsAndNames.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<Icon, String> iconNamePair = pairArray[n2];
            this.stateNames.add((String)iconNamePair.second);
            this.icons.add((Icon)iconNamePair.first);
            ++n2;
        }
        this.setupInternalActionListener();
    }

    public MultiStateToggleButton(Icon ... icons) {
        Icon[] iconArray = icons;
        int n = icons.length;
        int n2 = 0;
        while (n2 < n) {
            Icon icon = iconArray[n2];
            this.icons.add(icon);
            this.stateNames.add(null);
            ++n2;
        }
        this.setupInternalActionListener();
    }

    protected void setupInternalActionListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MultiStateToggleButton.this.clicked();
            }
        });
    }

    protected void clicked() {
        ++this.currentIndex;
        this.currentIndex %= this.stateNames.size();
        this.updateState();
    }

    protected void updateState() {
        this.setIcon(this.icons.get(this.currentIndex));
        String name = this.stateNames.get(this.currentIndex);
        if (name != null) {
            this.setText(name);
        }
    }

    public int getStateIndex() {
        return this.currentIndex;
    }

    public void setStateIndex(int index) {
        this.currentIndex = index;
        this.updateState();
    }

    public static void main(String[] args) {
        ImageIcon i1 = new ImageIcon("/home/jstewart/Desktop/RightSideUp.png");
        ImageIcon i2 = new ImageIcon("/home/jstewart/Desktop/LeftSideDown.png");
        ImageIcon i3 = new ImageIcon("/home/jstewart/Desktop/UpAndDown.png");
        JFrame f = new JFrame();
        MultiStateToggleButton btn = new MultiStateToggleButton(i1, i2, i3);
        f.add(btn);
        f.pack();
        f.setDefaultCloseOperation(3);
        btn.setStateIndex(0);
        btn.setText("Where");
        f.setVisible(true);
    }
}

