/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;

public class MouseOverJLabel
extends JLabel {
    protected EventListenerList actionListeners;
    protected int actionId;
    protected Color activatedTextColor;
    protected Color normalForeground;
    protected boolean mouseIsOver;

    public MouseOverJLabel() {
        this.init();
    }

    public MouseOverJLabel(String text) {
        super(text);
        this.init();
    }

    public MouseOverJLabel(Icon image) {
        super(image);
        this.init();
    }

    public MouseOverJLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public MouseOverJLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public MouseOverJLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.actionListeners.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(ActionListener.class, listener);
    }

    public Color getActivatedTextColor() {
        return this.activatedTextColor;
    }

    public void setActivatedTextColor(Color activatedTextColor) {
        this.activatedTextColor = activatedTextColor;
    }

    protected void fireActionPerformed() {
        ActionEvent ae = new ActionEvent(this, this.actionId++, "double-click");
        ActionListener[] actionListenerArray = (ActionListener[])this.actionListeners.getListeners(ActionListener.class);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(ae);
            ++n2;
        }
    }

    protected void init() {
        this.actionId = 0;
        this.actionListeners = new EventListenerList();
        this.activatedTextColor = Color.RED;
        this.normalForeground = this.getForeground();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MouseOverJLabel.this.fireActionPerformed();
                super.mouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseOverJLabel.this.mouseIsOver = true;
                super.mouseEntered(e);
                MouseOverJLabel.super.setForeground(MouseOverJLabel.this.activatedTextColor);
                MouseOverJLabel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseOverJLabel.this.mouseIsOver = false;
                super.mouseExited(e);
                MouseOverJLabel.super.setForeground(MouseOverJLabel.this.normalForeground);
                MouseOverJLabel.this.repaint();
            }
        });
    }

    @Override
    public void setForeground(Color fg) {
        this.normalForeground = fg;
        if (!this.mouseIsOver) {
            super.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        if (this.mouseIsOver) {
            return this.activatedTextColor;
        }
        return this.normalForeground;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        MouseOverJLabel l = new MouseOverJLabel("Some text");
        l.setForeground(Color.WHITE);
        l.setActivatedTextColor(Color.RED);
        l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println("click");
            }
        });
        f.add(l);
        f.setSize(200, 200);
        f.setVisible(true);
    }
}

