/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.DropDownButton;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MemoryDropDownButton
extends DropDownButton {
    protected JMenuItem lastChosen;
    protected PropertyChangeListener changeListener;

    public MemoryDropDownButton(String label, ImageIcon icon, int textPosition, List<JComponent> menus) {
        super(label, icon, textPosition, menus);
        boolean valid = false;
        for (JComponent comp : menus) {
            if (!(comp instanceof JMenuItem)) continue;
            valid = true;
            JMenuItem mi = (JMenuItem)comp;
            mi.addActionListener(this);
            if (this.lastChosen != null) continue;
            this.lastChosen = mi;
        }
        if (!valid) {
            throw new IllegalArgumentException("Menus list must contain at least one JMenuItem");
        }
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MemoryDropDownButton.this.fixMainButtonState();
            }
        };
        this.lastChosen.addPropertyChangeListener(this.changeListener);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.arrowBtn) {
            JPopupMenu popup = this.getPopupMenu();
            popup.addPopupMenuListener(this);
            popup.show(this.mainBtn, 0, this.mainBtn.getHeight());
        } else if (source instanceof JMenuItem) {
            this.lastChosen.removePropertyChangeListener("enabled", this.changeListener);
            this.lastChosen = (JMenuItem)source;
            this.lastChosen.addPropertyChangeListener("enabled", this.changeListener);
            this.fixMainButtonState();
        } else {
            this.lastChosen.doClick();
        }
    }

    protected void fixMainButtonState() {
        System.out.println("Fixing button state");
        this.mainBtn.setEnabled(this.lastChosen.isEnabled());
        this.mainBtn.setText(this.lastChosen.getText());
    }
}

