/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ListSlider
extends JPanel {
    private static final Logger log = Logger.getLogger(ListSlider.class);
    private JList sourceList;
    private JList destinationList;
    private String sourceListTitle = "";
    private String destinationListTitle = "";
    private DefaultListModel sourceListModel;
    private DefaultListModel destinationListModel;
    private String addString = ">";
    private String removeString = "<";
    private String addAllString = ">>";
    private String removeAllString = "<<";
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private Dimension preferredListSize = new Dimension(150, 150);
    private boolean isGrowableList = true;
    private boolean listChanged = false;

    private ListSlider(String[] sourceData, DefaultListModel sourceModel, String sourceListTitle, String[] destinationData, DefaultListModel destinationModel, String destinationListTitle) {
        this.sourceListTitle = sourceListTitle;
        this.destinationListTitle = destinationListTitle;
        this.sourceListModel = sourceModel;
        this.destinationListModel = destinationModel;
        this.addDataToListModel(this.sourceListModel, sourceData);
        this.addDataToListModel(this.destinationListModel, destinationData);
        this.setupListComponents(this.sourceListModel, this.destinationListModel);
    }

    private ListSlider(Object[] sourceData, DefaultListModel sourceModel, String sourceListTitle, Object[] destinationData, DefaultListModel destinationModel, String destinationListTitle) {
        this.sourceListTitle = sourceListTitle;
        this.destinationListTitle = destinationListTitle;
        this.sourceListModel = sourceModel;
        this.destinationListModel = destinationModel;
        this.addDataToListModel(this.sourceListModel, sourceData);
        this.addDataToListModel(this.destinationListModel, destinationData);
        this.setupListComponents(this.sourceListModel, this.destinationListModel);
    }

    private ListSlider(String[] sourceData, String sourceListTitle, String[] destinationData, String destinationListTitle) {
        this.sourceListTitle = sourceListTitle;
        this.destinationListTitle = destinationListTitle;
        this.sourceListModel = new DefaultListModel();
        this.addDataToListModel(this.sourceListModel, sourceData);
        this.destinationListModel = new DefaultListModel();
        this.addDataToListModel(this.destinationListModel, destinationData);
        this.setupListComponents(this.sourceListModel, this.destinationListModel);
    }

    public ListSlider(List<?> sourceData, String sourceListTitle, List<?> destinationData, String destinationListTitle) {
        this.sourceListTitle = sourceListTitle;
        this.destinationListTitle = destinationListTitle;
        this.sourceListModel = new DefaultListModel();
        this.addDataToListModel(this.sourceListModel, sourceData.toArray());
        this.destinationListModel = new DefaultListModel();
        this.addDataToListModel(this.destinationListModel, destinationData.toArray());
        this.setupListComponents(this.sourceListModel, this.destinationListModel);
    }

    private ListSlider(Object[] sourceData, String sourceListTitle, Object[] destinationData, String destinationListTitle) {
        this.sourceListTitle = sourceListTitle;
        this.destinationListTitle = destinationListTitle;
        this.sourceListModel = new DefaultListModel();
        this.addDataToListModel(this.sourceListModel, sourceData);
        this.destinationListModel = new DefaultListModel();
        this.addDataToListModel(this.destinationListModel, destinationData);
        this.setupListComponents(this.sourceListModel, this.destinationListModel);
    }

    public void setDefaultListCellRenderer(DefaultListCellRenderer cellRenderer) {
        this.sourceList.setCellRenderer(cellRenderer);
        this.destinationList.setCellRenderer(cellRenderer);
    }

    private void setupListComponents(DefaultListModel sourceListModel, DefaultListModel destListModel) {
        this.sourceList = new JList(sourceListModel);
        this.sourceList.setSelectedIndex(0);
        this.sourceList.addListSelectionListener(new SourceListSelectionHandler());
        this.sourceList.setVisibleRowCount(5);
        JPanel sourcePanel = this.getListPanel(this.sourceList, this.sourceListTitle);
        this.destinationList = new JList(destListModel);
        this.destinationList.setSelectedIndex(0);
        this.destinationList.addListSelectionListener(new DestinationListSelectionHandler());
        this.destinationList.setVisibleRowCount(5);
        JPanel destinationPanel = this.getListPanel(this.destinationList, this.destinationListTitle);
        this.addButton = UIHelper.createButton(this.addString);
        this.addAllButton = UIHelper.createButton(this.addAllString);
        this.removeButton = UIHelper.createButton(this.removeString);
        this.removeAllButton = UIHelper.createButton(this.removeAllString);
        AddListener addListener = new AddListener();
        this.addButton.addActionListener(addListener);
        this.addButton.setEnabled(true);
        this.addButton.setAlignmentX(0.5f);
        this.addButton.setMaximumSize(this.addButton.getPreferredSize());
        AddAllListener addAllListener = new AddAllListener();
        this.addAllButton.addActionListener(addAllListener);
        this.addAllButton.setEnabled(true);
        this.addAllButton.setAlignmentX(0.5f);
        this.addAllButton.setMaximumSize(this.addAllButton.getPreferredSize());
        RemoveListener removeListener = new RemoveListener();
        this.removeButton.addActionListener(removeListener);
        this.removeButton.setEnabled(false);
        this.removeButton.setAlignmentX(0.5f);
        this.removeButton.setMaximumSize(this.removeButton.getPreferredSize());
        RemoveAllListener removeAllListener = new RemoveAllListener();
        this.removeAllButton.addActionListener(removeAllListener);
        this.removeAllButton.setEnabled(true);
        this.removeAllButton.setAlignmentX(0.5f);
        this.removeAllButton.setMaximumSize(this.removeAllButton.getPreferredSize());
        ButtonStackBuilder builder = new ButtonStackBuilder();
        builder.addGridded((JComponent)this.addAllButton);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this.addButton);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this.removeButton);
        builder.addRelatedGap();
        builder.addGridded((JComponent)this.removeAllButton);
        JPanel buttonPanel = builder.getPanel();
        PanelBuilder panelBuilder = this.isGrowableList ? new PanelBuilder(new FormLayout("f:d:g(0.5),  7dlu,  c:p,  7dlu,  f:d:g(0.5)", "f:pref:g(0.5),  pref,  f:pref:g(0.5)"), (JPanel)this) : new PanelBuilder(new FormLayout("f:d,  7dlu,  c:p,  7dlu,  f:d", "t:d,  c:pref,  t:d"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        panelBuilder.add((Component)sourcePanel, cc.xywh(1, 1, 1, 3));
        panelBuilder.add((Component)buttonPanel, cc.xy(3, 2));
        panelBuilder.add((Component)destinationPanel, cc.xywh(5, 1, 1, 3));
    }

    public void setExternalActionListener(ActionListener listener) {
        this.addButton.addActionListener(listener);
        this.addAllButton.addActionListener(listener);
        this.removeButton.addActionListener(listener);
        this.removeAllButton.addActionListener(listener);
    }

    public Object[] getDestinationData() {
        if (this.destinationListModel == null) {
            log.debug((Object)"No data selected");
            return null;
        }
        int listSize = this.destinationListModel.getSize();
        Object[] values = new Object[listSize];
        int i = 0;
        while (i < listSize) {
            values[i] = this.destinationListModel.getElementAt(i);
            ++i;
        }
        log.debug((Object)"The following data is in the destination list");
        i = 0;
        while (i < values.length) {
            log.debug((Object)values[i].toString());
            ++i;
        }
        return values;
    }

    public Object[] getSourceData() {
        if (this.sourceListModel == null) {
            log.debug((Object)"No data selected");
            return null;
        }
        int listSize = this.sourceListModel.getSize();
        Object[] values = new Object[listSize];
        int i = 0;
        while (i < listSize) {
            values[i] = this.sourceListModel.getElementAt(i);
            ++i;
        }
        log.debug((Object)"The following data is in the destination list");
        i = 0;
        while (i < values.length) {
            log.debug((Object)values[i].toString());
            ++i;
        }
        return values;
    }

    public JList getDestinationList() {
        return new JList(this.destinationListModel);
    }

    public JList getSourceList() {
        return new JList(this.sourceListModel);
    }

    public static void testListSlider() {
    }

    public void setPreferredListSize(Dimension d) {
        this.preferredListSize = d;
    }

    public void setGrowableLists(boolean b) {
        this.isGrowableList = b;
    }

    public JPanel getListPanel(JList list, String title) {
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(this.preferredListSize);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListSlider.testListSlider();
            }
        });
    }

    public void setSourceSelectedValues(Integer[] ids) {
        log.debug((Object)"setSourceSelectedValues");
        Object[] vals = this.getSourceData();
        ArrayList<Integer> indicesToMove = new ArrayList<Integer>();
        int i = 0;
        while (i < vals.length) {
            Integer ctID;
            int j;
            Object o = vals[i];
            if (o instanceof SpPrincipal) {
                SpPrincipal spug = (SpPrincipal)o;
                Integer spugID = spug.getId();
                j = 0;
                while (j < ids.length) {
                    if (ids[j].intValue() == spugID.intValue()) {
                        log.debug((Object)("preparint to move: " + i));
                        indicesToMove.add(new Integer(i));
                    }
                    ++j;
                }
            } else if (o instanceof Discipline) {
                Discipline disc = (Discipline)o;
                ctID = disc.getId();
                j = 0;
                while (j < ids.length) {
                    if (ids[j].intValue() == ctID.intValue()) {
                        indicesToMove.add(new Integer(i));
                    }
                    ++j;
                }
            } else if (o instanceof SpecifyUser) {
                SpecifyUser ct = (SpecifyUser)o;
                ctID = ct.getId();
                j = 0;
                while (j < ids.length) {
                    if (ids[j].intValue() == ctID.intValue()) {
                        indicesToMove.add(new Integer(i));
                    }
                    ++j;
                }
            }
            ++i;
        }
        int[] indices = new int[indicesToMove.size()];
        int i2 = 0;
        while (i2 < indicesToMove.size()) {
            indices[i2] = (Integer)indicesToMove.get(i2);
            log.debug((Object)("selecting: " + Integer.valueOf((Integer)indicesToMove.get(i2))));
            ++i2;
        }
        this.sourceList.setSelectedIndices(indices);
        this.moveSelectedSourceDataToDestination();
    }

    public void moveSelectedDestinationDataToSource() {
        Object[] selectedVals = this.destinationList.getSelectedValues();
        this.addDataToListModel(this.sourceListModel, selectedVals);
        this.removeDataFromListModel(this.destinationListModel, selectedVals);
        this.destinationList.setSelectedIndex(0);
        if (this.destinationList.getModel().getSize() == 0) {
            this.sourceList.setSelectedIndex(1);
        }
    }

    public void moveAllDestinationDataToSource() {
        Object[] selectedVals = new Object[this.destinationList.getModel().getSize()];
        int i = 0;
        while (i < this.destinationList.getModel().getSize()) {
            selectedVals[i] = this.destinationList.getModel().getElementAt(i);
            ++i;
        }
        this.addDataToListModel(this.sourceListModel, selectedVals);
        this.removeDataFromListModel(this.destinationListModel, selectedVals);
        this.destinationList.setSelectedIndex(0);
        if (this.destinationList.getModel().getSize() == 0) {
            this.sourceList.setSelectedIndex(1);
        }
    }

    public void moveSelectedSourceDataToDestination() {
        Object[] selectedVals = this.sourceList.getSelectedValues();
        this.addDataToListModel(this.destinationListModel, selectedVals);
        this.removeDataFromListModel(this.sourceListModel, selectedVals);
        this.sourceList.setSelectedIndex(0);
        if (this.sourceList.getModel().getSize() == 0) {
            this.destinationList.setSelectedIndex(1);
        }
    }

    public void moveAllSourceDataToDestination() {
        Object[] selectedVals = new Object[this.sourceList.getModel().getSize()];
        int i = 0;
        while (i < this.sourceList.getModel().getSize()) {
            selectedVals[i] = this.sourceList.getModel().getElementAt(i);
            ++i;
        }
        this.addDataToListModel(this.destinationListModel, selectedVals);
        this.removeDataFromListModel(this.sourceListModel, selectedVals);
        this.sourceList.setSelectedIndex(0);
        if (this.sourceList.getModel().getSize() == 0) {
            this.destinationList.setSelectedIndex(1);
        }
    }

    private void addDataToListModel(DefaultListModel model, Object[] newValues) {
        int i = 0;
        while (i < newValues.length) {
            model.addElement(newValues[i]);
            ++i;
        }
        this.getDestinationData();
    }

    private void removeDataFromListModel(DefaultListModel model, Object[] newValues) {
        int i = 0;
        while (i < newValues.length) {
            model.removeElement(newValues[i]);
            ++i;
        }
        this.getDestinationData();
    }

    private void setButtons(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.sourceList.getSelectedIndex() == -1) {
                this.addButton.setEnabled(false);
                this.addAllButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
                this.addAllButton.setEnabled(true);
            }
            if (this.destinationList.getSelectedIndex() == -1) {
                this.removeButton.setEnabled(false);
                this.removeAllButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
                this.removeAllButton.setEnabled(true);
            }
        }
    }

    public boolean isListChanged() {
        return this.listChanged;
    }

    public void setListChanged(boolean listChanged) {
        this.listChanged = listChanged;
    }

    class AddAllListener
    implements ActionListener {
        AddAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSlider.this.sourceList.setSelectionInterval(0, ListSlider.this.sourceList.getModel().getSize() - 1);
            ListSlider.this.moveSelectedSourceDataToDestination();
            ListSlider.this.listChanged = true;
        }
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSlider.this.moveSelectedSourceDataToDestination();
            ListSlider.this.listChanged = true;
        }
    }

    class DestinationListSelectionHandler
    implements ListSelectionListener {
        DestinationListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSlider.this.setButtons(e);
        }
    }

    class RemoveAllListener
    implements ActionListener {
        RemoveAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSlider.this.destinationList.setSelectionInterval(0, ListSlider.this.destinationList.getModel().getSize() - 1);
            ListSlider.this.moveSelectedDestinationDataToSource();
            ListSlider.this.listChanged = true;
        }
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSlider.this.moveSelectedDestinationDataToSource();
            ListSlider.this.listChanged = true;
        }
    }

    class SourceListSelectionHandler
    implements ListSelectionListener {
        SourceListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSlider.this.setButtons(e);
        }
    }
}

