/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ListPopupDialog
extends JDialog {
    protected ListPopupCallback callback;
    protected Vector<Object> options;
    protected JPanel messagePanel;
    protected JPanel cbPanel;
    protected JPanel buttonPanel;
    protected JComboBox optionList;
    protected DefaultComboBoxModel model;
    protected JButton okButton;
    protected JButton cancelButton;

    public ListPopupDialog(Frame owner, String message, List<Object> options, ListPopupCallback popupCallback) {
        super(owner);
        this.setLayout(new BorderLayout());
        this.callback = popupCallback;
        this.options = new Vector<Object>(options);
        this.model = new DefaultComboBoxModel<Object>(this.options);
        this.optionList = UIHelper.createComboBox(this.model);
        this.cbPanel = new JPanel();
        this.cbPanel.add(this.optionList);
        this.add((Component)this.cbPanel, "Center");
        JLabel lbl = UIHelper.createLabel(message);
        this.add((Component)lbl, "North");
        this.buttonPanel = new JPanel(new FlowLayout());
        this.cancelButton = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupDialog.this.setVisible(false);
                ListPopupDialog.this.callback.cancelled();
            }
        });
        this.okButton = UIHelper.createButton(UIRegistry.getResourceString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupDialog.this.setVisible(false);
                ListPopupDialog.this.callback.completed(ListPopupDialog.this.optionList.getSelectedItem());
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.okButton);
        this.add((Component)this.buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ListPopupDialog.this.callback.cancelled();
            }
        });
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public void setComboBoxCellRenderer(ListCellRenderer renderer) {
        this.optionList.setRenderer(renderer);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.okButton.requestFocusInWindow();
        this.okButton.requestFocus();
    }

    public void addOption(Object option) {
        this.options.add(option);
    }

    public void removeOption(Object option) {
        this.options.remove(option);
    }

    public static interface ListPopupCallback {
        public void completed(Object var1);

        public void cancelled();
    }
}

