/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class JStatusBar
extends JPanel {
    private static final Color ERROR_COLOR = Color.RED;
    private static final Color NORMAL_COLOR = Color.BLACK;
    private static final Color WARNING_COLOR = Color.ORANGE;
    protected JLabel statusLabel = null;
    protected JLabel[] labels = null;
    protected JProgressBar progressBar = null;
    protected Icon errorIcon = null;
    protected Icon warningIcon = null;
    protected Exception lastException = null;
    protected Vector<ProgressItem> prgItemsRecycler = new Vector();
    protected Vector<ProgressItem> prgItems = new Vector();
    protected Hashtable<String, ProgressItem> prgHash = new Hashtable();

    public JStatusBar() {
        this((int[])null);
    }

    public JStatusBar(int[] sectionSize) {
        this.setLayout(new BorderLayout());
        this.setBorder(new MyBevelBorder());
        this.statusLabel = UIHelper.createLabel(" ");
        this.progressBar = UIHelper.createProgressBar(0, 100);
        this.statusLabel.setPreferredSize(new Dimension(100, this.statusLabel.getPreferredSize().height));
        this.progressBar.setPreferredSize(new Dimension(150, this.statusLabel.getPreferredSize().height));
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g,2px,right:p" + (UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX ? ",15px" : ""), "p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        if (sectionSize == null) {
            builder.add((Component)this.statusLabel, cc.xy(1, 1));
        } else {
            StringBuilder str = new StringBuilder("f:p:g");
            int[] nArray = sectionSize;
            int n = sectionSize.length;
            int n2 = 0;
            while (n2 < n) {
                int size = nArray[n2];
                str.append(",1px,p,1px,max(p;" + size + "dlu)");
                ++n2;
            }
            PanelBuilder sbBldr = new PanelBuilder(new FormLayout(str.toString(), "f:p:g"));
            sbBldr.add((Component)this.statusLabel, cc.xy(1, 1));
            this.labels = new JLabel[sectionSize.length];
            int col = 3;
            int i = 0;
            while (i < sectionSize.length) {
                this.labels[i] = new JLabel(" ", 0);
                UIHelper.setControlSize(this.labels[i]);
                Color bg = this.getBackground();
                sbBldr.add((Component)new VerticalSeparator(bg.darker(), bg.brighter()), cc.xy(col, 1));
                sbBldr.add((Component)this.labels[i], cc.xy(col += 2, 1));
                col += 2;
                ++i;
            }
            builder.add((Component)sbBldr.getPanel(), cc.xy(1, 1));
        }
        builder.add((Component)this.progressBar, cc.xy(3, 1));
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
        this.statusLabel.setForeground(NORMAL_COLOR);
        this.statusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && JStatusBar.this.lastException != null) {
                    String message = JStatusBar.this.lastException.getLocalizedMessage();
                    JOptionPane.showMessageDialog(JStatusBar.this.getParent(), message, JStatusBar.this.statusLabel.getText(), 0);
                }
            }
        });
    }

    public void setErrorIcon(Icon icon) {
        this.errorIcon = icon;
    }

    public void setWarningIcon(Icon icon) {
        this.warningIcon = icon;
    }

    public void setText(String text) {
        this.statusLabel.setForeground(NORMAL_COLOR);
        this.lastException = null;
        this.statusLabel.setText(text);
        this.statusLabel.setToolTipText(text);
        this.statusLabel.setIcon(null);
        this.statusLabel.repaint();
    }

    public JLabel getSectionLabel(int sectionInx) {
        return sectionInx > -1 && sectionInx < this.labels.length ? this.labels[sectionInx] : null;
    }

    public void setLocalizedText(String key, Object ... args) {
        this.setText(UIRegistry.getFormattedResStr(key, args));
    }

    public void setSectionText(int sectionInx, String text) {
        if (this.labels != null && sectionInx > -1 && sectionInx < this.labels.length) {
            this.labels[sectionInx].setText(text);
        }
    }

    public void setSectionToolTipText(int sectionInx, String text) {
        if (this.labels != null && sectionInx > -1 && sectionInx < this.labels.length) {
            this.labels[sectionInx].setToolTipText(text);
        }
    }

    public void setErrorMessage(String message, Exception e) {
        this.setText(message);
        this.statusLabel.setForeground(ERROR_COLOR);
        this.statusLabel.setIcon(this.errorIcon);
        this.lastException = e;
    }

    public void setErrorMessage(String message) {
        this.setText(message);
        this.statusLabel.setForeground(ERROR_COLOR);
        this.statusLabel.setIcon(this.errorIcon);
        this.lastException = null;
    }

    public void setLocalizedErrorMessage(String key, Object ... args) {
        this.setErrorMessage(UIRegistry.getFormattedResStr(key, args));
    }

    public void setWarningMessage(String message, Exception e) {
        this.setText(message);
        this.statusLabel.setForeground(WARNING_COLOR);
        this.statusLabel.setIcon(this.warningIcon);
        this.lastException = e;
    }

    public void setWarningMessage(String message) {
        this.setText(message);
        this.statusLabel.setForeground(WARNING_COLOR);
        this.statusLabel.setIcon(this.warningIcon);
        this.lastException = null;
    }

    protected synchronized ProgressItem getProgressItem(String name) {
        ProgressItem item = this.prgHash.get(name);
        if (item == null) {
            if (this.prgItemsRecycler.size() == 0) {
                item = new ProgressItem(name);
            } else {
                item = this.prgItemsRecycler.remove(0);
                item.setName(name);
            }
            item.clear();
            this.prgHash.put(name, item);
            this.prgItems.add(item);
        }
        return item;
    }

    protected synchronized void progressDone(String name) {
        ProgressItem item = this.prgHash.get(name);
        if (item != null) {
            this.prgHash.remove(name);
            this.prgItems.remove(item);
            this.prgItemsRecycler.add(item);
            if (this.prgItems.size() > 0) {
                this.updateProgress(this.prgItems.get(0));
            }
        }
    }

    protected boolean isCurrent(ProgressItem item) {
        return this.prgItems.size() > 0 && this.prgItems.get(0) == item;
    }

    public synchronized void setIndeterminate(String name, boolean isIndeterminate) {
        this.setIndeterminate(name, isIndeterminate, false);
    }

    public synchronized void setIndeterminate(String name, boolean isIndeterminate, boolean usePlatformLnF) {
        ProgressItem item;
        if (this.progressBar != null && (item = this.getProgressItem(name)) != null) {
            item.setIndeterminate(isIndeterminate);
            item.setUsePlatformUI(usePlatformLnF);
            this.updateProgress(item);
        }
    }

    public synchronized void incrementRange(String name) {
        if (this.progressBar != null) {
            if (this.prgHash.get(name) == null) {
                this.setProgressRange(name, 0, 1, 0);
            } else {
                ProgressItem item = this.getProgressItem(name);
                item.setMax(item.getMax() + 1);
                this.updateProgress(item);
            }
        }
    }

    public synchronized void incrementValue(String name) {
        if (this.progressBar != null) {
            if (this.prgHash.get(name) == null) {
                this.setProgressRange(name, 0, 1);
            }
            ProgressItem item = this.getProgressItem(name);
            item.setValue(item.getValue() + 1);
            this.updateProgress(item);
        }
    }

    public synchronized void setProgressDone(String name) {
        ProgressItem item;
        if (this.progressBar != null && (item = this.getProgressItem(name)) != null) {
            item.clear();
            item.setIndStatusChanged(true);
            this.updateProgress(item);
            this.prgHash.remove(name);
            this.prgItems.remove(item);
            this.prgItemsRecycler.add(item);
        }
    }

    protected void updateProgress(final ProgressItem item) {
        if (this.isCurrent(item)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (item.isIndStatusChanged()) {
                        if (UIHelper.isMacOS()) {
                            JStatusBar.this.progressBar.putClientProperty("JProgressBar.style", item.isUsePlatformUI() ? "circular" : null);
                        }
                        JStatusBar.this.progressBar.setIndeterminate(item.isIndeterminate());
                    }
                    if (!item.isIndeterminate() && item.hasRange()) {
                        JStatusBar.this.progressBar.setMinimum(item.getMin());
                        JStatusBar.this.progressBar.setMaximum(item.getMax());
                        JStatusBar.this.progressBar.setValue(item.getValue());
                        if (item.getMax() == item.getValue()) {
                            JStatusBar.this.setProgressDone(item.getName());
                            return;
                        }
                    }
                    if (JStatusBar.this.progressBar.isVisible()) {
                        if (!item.isIndeterminate() && !item.hasRange()) {
                            JStatusBar.this.progressBar.setVisible(false);
                            JStatusBar.this.validate();
                        }
                    } else if (item.isIndeterminate() || item.hasRange()) {
                        JStatusBar.this.progressBar.setVisible(true);
                        JStatusBar.this.validate();
                    }
                }
            });
        }
    }

    public synchronized void setProgressRange(String name, int min, int max) {
        this.setProgressRange(name, min, max, min);
    }

    public synchronized void setProgressRange(String name, int min, int max, int value) {
        if (this.progressBar != null) {
            ProgressItem item = this.getProgressItem(name);
            item.setProgressRange(min, max, value);
            this.updateProgress(item);
        }
    }

    public synchronized void setValue(String name, int value) {
        ProgressItem item;
        if (this.progressBar != null && (item = this.getProgressItem(name)) != null && item.getValue() != value) {
            item.setValue(value);
            this.updateProgress(item);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public class EndsBorder
    extends BevelBorder {
        protected Insets insets;

        public EndsBorder(boolean bothEnds) {
            super(1);
            this.insets = new Insets(2, 0, 0, bothEnds ? 2 : 0);
        }

        @Override
        protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(1, 0, 1, h - 1);
            if (this.insets.right > 0) {
                g.setColor(this.getShadowInnerColor(c));
                g.drawLine(w - 2, 1, w - 2, h - 2);
                g.setColor(this.getHighlightOuterColor(c));
                g.drawLine(w - 1, 1, w - 1, h - 2);
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }
    }

    private class MyBevelBorder
    extends BevelBorder {
        public MyBevelBorder() {
            super(1);
        }

        @Override
        protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    public class ProgressItem {
        private String name;
        private int min;
        private int max;
        private int value;
        private boolean isIndeterminate = false;
        private boolean usePlatformUI = false;
        private boolean indStatusChanged = false;

        public ProgressItem(String name) {
            this.name = name;
        }

        public void setIndStatusChanged(boolean indStatusChanged) {
            this.indStatusChanged = indStatusChanged;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void clear() {
            this.value = 0;
            this.max = 0;
            this.min = 0;
            this.indStatusChanged = false;
            this.isIndeterminate = false;
        }

        public boolean hasRange() {
            return this.min != 0 || this.max != 0;
        }

        public boolean isIndeterminate() {
            return this.isIndeterminate;
        }

        public void setIndeterminate(boolean isIndeterminate) {
            this.indStatusChanged = this.isIndeterminate ^ isIndeterminate;
            this.isIndeterminate = isIndeterminate;
        }

        public boolean isIndStatusChanged() {
            return this.indStatusChanged;
        }

        public boolean isUsePlatformUI() {
            return this.usePlatformUI;
        }

        public void setUsePlatformUI(boolean usePlatformUI) {
            this.usePlatformUI = usePlatformUI;
        }

        public void setProgressRange(int min, int max) {
            this.setProgressRange(min, max, min);
        }

        public void setProgressRange(int minArg, int maxArg, int valueArg) {
            this.min = minArg;
            this.max = maxArg;
            this.value = valueArg;
            this.setIndeterminate(false);
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }
    }
}

