/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class InfiniteProgressIndicator
extends JComponent
implements MouseListener {
    protected Area[] ticker = null;
    protected Thread animation = null;
    protected boolean started = false;
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.7f;
    protected String text = "";
    protected int barsCount = 14;
    protected float fps = 15.0f;
    protected RenderingHints hints = null;

    public InfiniteProgressIndicator() {
        this("");
    }

    public InfiniteProgressIndicator(String text) {
        this(text, 14);
    }

    public InfiniteProgressIndicator(String text, int barsCount) {
        this(text, barsCount, 0.7f);
    }

    public InfiniteProgressIndicator(String text, int barsCount, float shield) {
        this(text, barsCount, shield, 15.0f);
    }

    public InfiniteProgressIndicator(String text, int barsCount, float shield, float fps) {
        this(text, barsCount, shield, fps, 300);
    }

    public InfiniteProgressIndicator(String text, int barsCount, float shield, float fps, int rampDelay) {
        this.text = text;
        this.rampDelay = rampDelay >= 0 ? rampDelay : 0;
        this.shield = shield >= 0.0f ? shield : 0.0f;
        this.fps = fps > 0.0f ? fps : 15.0f;
        this.barsCount = barsCount > 0 ? barsCount : 14;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void start() {
        this.addMouseListener(this);
        this.setVisible(true);
        this.ticker = this.buildTicker();
        this.animation = new Thread(new Animator(true));
        this.animation.start();
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.animation = new Thread(new Animator(false));
            this.animation.start();
        }
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.started) {
            Rectangle2D bounds;
            int width = this.getWidth();
            double maxY = 0.0;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.hints);
            g2.setColor(new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield)));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int i = 0;
            while (i < this.ticker.length) {
                int channel = 224 - 128 / (i + 1);
                g2.setColor(new Color(channel, channel, channel, this.alphaLevel));
                g2.fill(this.ticker[i]);
                bounds = this.ticker[i].getBounds2D();
                if (bounds.getMaxY() > maxY) {
                    maxY = bounds.getMaxY();
                }
                ++i;
            }
            if (this.text != null && this.text.length() > 0) {
                FontRenderContext context = g2.getFontRenderContext();
                TextLayout layout = new TextLayout(this.text, this.getFont(), context);
                bounds = layout.getBounds();
                g2.setColor(this.getForeground());
                layout.draw(g2, (float)((double)width - bounds.getWidth()) / 2.0f, (float)(maxY + (double)layout.getLeading() + (double)(2.0f * layout.getAscent())));
            }
        }
    }

    private Area[] buildTicker() {
        Area[] tickerArray = new Area[this.barsCount];
        Point2D.Double center = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double fixedAngle = Math.PI * 2 / (double)this.barsCount;
        double i = 0.0;
        while (i < (double)this.barsCount) {
            Area primitive = this.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(2.0, -0.5);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            tickerArray[(int)i] = primitive;
            i += 1.0;
        }
        return tickerArray;
    }

    private Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(1.0, 0.0, 4.0, 2.0);
        Ellipse2D.Double head = new Ellipse2D.Double(0.0, 0.0, 2.0, 2.0);
        Ellipse2D.Double tail = new Ellipse2D.Double(4.0, 0.0, 2.0, 2.0);
        Area tick = new Area(body);
        tick.add(new Area(head));
        tick.add(new Area(tail));
        return tick;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class Animator
    implements Runnable {
        private boolean rampUp = true;

        protected Animator(boolean rampUp) {
            this.rampUp = rampUp;
        }

        @Override
        public void run() {
            Point2D.Double center = new Point2D.Double((double)InfiniteProgressIndicator.this.getWidth() / 2.0, (double)InfiniteProgressIndicator.this.getHeight() / 2.0);
            double fixedIncrement = Math.PI * 2 / (double)InfiniteProgressIndicator.this.barsCount;
            AffineTransform toCircle = AffineTransform.getRotateInstance(fixedIncrement, center.getX(), center.getY());
            long start = System.currentTimeMillis();
            if (InfiniteProgressIndicator.this.rampDelay == 0) {
                InfiniteProgressIndicator.this.alphaLevel = this.rampUp ? 255 : 0;
            }
            InfiniteProgressIndicator.this.started = true;
            boolean inRamp = this.rampUp;
            while (!Thread.interrupted()) {
                block10: {
                    block9: {
                        if (!inRamp) {
                            int i = 0;
                            while (i < InfiniteProgressIndicator.this.ticker.length) {
                                InfiniteProgressIndicator.this.ticker[i].transform(toCircle);
                                ++i;
                            }
                        }
                        InfiniteProgressIndicator.this.repaint();
                        if (!this.rampUp) break block9;
                        if (InfiniteProgressIndicator.this.alphaLevel >= 255) break block10;
                        InfiniteProgressIndicator.this.alphaLevel = (int)(255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressIndicator.this.rampDelay);
                        if (InfiniteProgressIndicator.this.alphaLevel < 255) break block10;
                        InfiniteProgressIndicator.this.alphaLevel = 255;
                        inRamp = false;
                        break block10;
                    }
                    if (InfiniteProgressIndicator.this.alphaLevel > 0) {
                        InfiniteProgressIndicator.this.alphaLevel = (int)(255L - 255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressIndicator.this.rampDelay);
                        if (InfiniteProgressIndicator.this.alphaLevel <= 0) {
                            InfiniteProgressIndicator.this.alphaLevel = 0;
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(inRamp ? 10 : (int)(1000.0f / InfiniteProgressIndicator.this.fps));
                }
                catch (InterruptedException ie) {
                    break;
                }
                Thread.yield();
            }
            if (!this.rampUp) {
                InfiniteProgressIndicator.this.started = false;
                InfiniteProgressIndicator.this.repaint();
                InfiniteProgressIndicator.this.setVisible(false);
                InfiniteProgressIndicator.this.removeMouseListener(InfiniteProgressIndicator.this);
            }
        }
    }
}

