/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class ImageDisplay
extends JPanel
implements GetSetValueIFace {
    public static final int kImageOK = 0;
    public static final int kError = 1;
    public static final int kHttpError = 2;
    public static final int kInterruptedError = 3;
    public static final int kIOError = 4;
    public static final int kURLError = 5;
    private byte[] bytes = null;
    protected Image image = null;
    protected String url;
    protected boolean isEditMode = true;
    protected JButton editBtn;
    protected ImageGetter getter = null;
    protected String noImageStr = UIRegistry.getResourceString("noimage");
    protected String loadingImageStr = UIRegistry.getResourceString("loadingimage");
    protected boolean isNoImage = true;
    protected JFileChooser chooser;
    protected boolean doShowText = true;
    protected ChangeListener changeListener = null;
    private int status = 0;
    private ArrayList<File> fileCache = new ArrayList();

    public ImageDisplay(int imgWidth, int imgHeight, boolean isEditMode, boolean hasBorder) {
        super(new BorderLayout());
        this.setBorder(hasBorder ? new EtchedBorder(1) : BorderFactory.createEmptyBorder());
        this.setPreferredSize(new Dimension(imgWidth, imgHeight));
        this.isEditMode = isEditMode;
        this.createUI();
        this.setDoubleBuffered(true);
    }

    public ImageDisplay(ImageIcon imgIcon, boolean isEditMode, boolean hasBorder) {
        this(imgIcon.getIconWidth(), imgIcon.getIconHeight(), isEditMode, hasBorder);
        this.setImage(imgIcon.getImage());
    }

    public ImageDisplay(Image imgIcon, boolean isEditMode, boolean hasBorder) {
        this(imgIcon.getWidth(null), imgIcon.getHeight(null), isEditMode, hasBorder);
        this.setImage(imgIcon);
    }

    protected void createUI() {
        this.setLayout((LayoutManager)new FormLayout("f:p:g" + (this.isEditMode ? ",2px,p" : ""), "p"));
        CellConstraints cc = new CellConstraints();
        if (this.isEditMode) {
            ImageIcon icon = IconManager.getImage("EditIcon", IconManager.IconSize.NonStd);
            this.editBtn = new JButton(icon);
            this.editBtn.setMargin(new Insets(1, 1, 1, 1));
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ImageDisplay.this.selectNewImage();
                }
            });
            this.add((Component)this.editBtn, cc.xy(3, 1));
        }
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    public boolean isInError() {
        return this.status != 0;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNewImage() {
        String oldURL = this.url;
        ImageDisplay imageDisplay = this;
        synchronized (imageDisplay) {
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
        }
        int returnVal = this.chooser.showOpenDialog(UIRegistry.getTopWindow());
        if (returnVal == 0) {
            File file = new File(this.chooser.getSelectedFile().getAbsolutePath());
            try {
                this.setImage(ImageIO.read(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.url = file.getAbsolutePath();
            this.repaint();
        }
        this.firePropertyChange("imageURL", oldURL, this.url);
    }

    public synchronized void setImage(Image newImage) {
        if (newImage != null && newImage.getWidth(null) > 0 && newImage.getHeight(null) > 0) {
            this.image = newImage;
            this.setNoImage(false);
        } else {
            this.image = null;
            this.setNoImage(true);
        }
        this.repaint();
        this.doLayout();
    }

    public synchronized void setImage(ImageIcon newImageIcon) {
        if (newImageIcon != null) {
            this.setImage(newImageIcon.getImage());
        } else {
            this.setImage((Image)null);
        }
    }

    private void notifyChangeListener() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void loadImage() {
        this.status = 0;
        if (StringUtils.isNotEmpty((String)this.url)) {
            this.setNoImage(false);
            this.repaint();
            if (this.getter != null) {
                this.getter.setManualStop(true);
                this.getter.stop();
            }
            if (this.url.startsWith("file")) {
                try {
                    File f = new File(new URI(this.url));
                    BufferedImage img = ImageIO.read(f);
                    this.setImage(img);
                    this.repaint();
                    this.notifyChangeListener();
                    return;
                }
                catch (Exception e) {
                    this.status = 5;
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ImageDisplay.class, e);
                    e.printStackTrace();
                }
            }
            this.getter = new ImageGetter(this.url);
            this.getter.start();
        } else {
            this.status = 5;
            this.setNoImage(true);
            this.setImage((Image)null);
            this.notifyChangeListener();
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        boolean doScale = true;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.image != null && !this.isNoImage && this.status == 0) {
            int imgW = this.image.getWidth(null);
            int imgH = this.image.getHeight(null);
            if (doScale && (imgW > w || imgH > h)) {
                double scaleW = 1.0;
                double scaleH = 1.0;
                double scale = 1.0;
                if (imgW > w) {
                    scaleW = (double)w / (double)imgW;
                }
                if (imgH > h) {
                    scaleH = (double)h / (double)imgH;
                }
                scale = Math.min(scaleW, scaleH);
                imgW = (int)((double)imgW * scale);
                imgH = (int)((double)imgH * scale);
            }
            int x = 0;
            int y = 0;
            if (imgW < w) {
                x = (w - imgW) / 2;
            }
            if (imgH < h) {
                y = (h - imgH) / 2;
            }
            g.drawImage(this.image, x, y, imgW, imgH, null);
        } else if (this.doShowText) {
            String label = this.isNoImage ? this.noImageStr : this.loadingImageStr;
            FontMetrics fm = g.getFontMetrics();
            g.drawString(label, (w - fm.stringWidth(label)) / 2, (h - fm.getAscent()) / 2);
        }
    }

    public void setNoImage(boolean isNoImage) {
        this.isNoImage = isNoImage;
        this.repaint();
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value instanceof String) {
            this.url = (String)value;
            this.loadImage();
        }
    }

    @Override
    public Object getValue() {
        return this.url;
    }

    public boolean isDoShowText() {
        return this.doShowText;
    }

    public void setDoShowText(boolean doShowText) {
        this.doShowText = doShowText;
    }

    private boolean fillFileFromWeb(String urlStr, File tmpFile) {
        if (this.bytes == null) {
            this.bytes = new byte[102400];
        }
        try {
            URL urlObj = new URL(urlStr);
            InputStream inpStream = urlObj.openStream();
            if (inpStream != null) {
                int numBytes;
                BufferedInputStream in = new BufferedInputStream(inpStream);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
                while ((numBytes = in.read(this.bytes)) != -1) {
                    bos.write(this.bytes, 0, numBytes);
                }
                in.close();
                bos.close();
                return true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private synchronized File getFileFromWeb(String urlStr) {
        try {
            File tmpFile = File.createTempFile("sp6", ".img", null);
            return this.fillFileFromWeb(urlStr, tmpFile) ? tmpFile : null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public class ImageGetter
    implements Runnable {
        private Thread thread = null;
        private String urlStr;
        private boolean isManualStop = false;

        public ImageGetter(String urlStr) {
            this.urlStr = urlStr;
        }

        public int getStatus() {
            return ImageDisplay.this.status;
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        public void setManualStop(boolean isManualStop) {
            this.isManualStop = isManualStop;
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            if (!this.isManualStop) {
                ImageDisplay.this.status = 3;
                ImageDisplay.this.notifyChangeListener();
            }
            this.thread = null;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                ImageDisplay.this.setNoImage(false);
                File localFile = ImageDisplay.this.getFileFromWeb(this.urlStr);
                if (localFile != null) {
                    localFile.deleteOnExit();
                    ImageDisplay.this.setImage(ImageIO.read(localFile));
                    ImageDisplay.this.status = 0;
                    if (ImageDisplay.this.fileCache.size() > 2) {
                        File f = (File)ImageDisplay.this.fileCache.get(0);
                        ImageDisplay.this.fileCache.remove(0);
                        f.delete();
                    }
                    ImageDisplay.this.fileCache.add(localFile);
                } else {
                    ImageDisplay.this.status = 4;
                }
                ImageDisplay.this.getter = null;
            }
            catch (MalformedURLException e) {
                ImageDisplay.this.status = 5;
                e.printStackTrace();
            }
            catch (Exception e) {
                ImageDisplay.this.status = 1;
                e.printStackTrace();
            }
            ImageDisplay.this.notifyChangeListener();
        }
    }
}

