/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.ui.DefaultModifiableListModel;
import edu.ku.brc.ui.ModifiableListModel;
import edu.ku.brc.ui.renderers.TrayListCellRenderer;
import edu.ku.brc.util.FormDataObjComparator;
import edu.ku.brc.util.Orderable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class IconTray
extends JPanel {
    protected static final Logger log = Logger.getLogger(IconTray.class);
    public static final int SINGLE_ROW = 1;
    public static final int MULTIPLE_ROWS = 2;
    protected int minHeight = 64;
    protected int maxWidth = 750;
    protected JList iconListWidget;
    protected ModifiableListModel<Object> listModel;
    protected JScrollPane listScrollPane;
    protected int style;

    public IconTray(int layoutStyle) {
        this.style = layoutStyle;
        this.listModel = new DefaultModifiableListModel<Object>();
        TrayListCellRenderer renderer = new TrayListCellRenderer();
        this.iconListWidget = new JList<Object>(this.listModel);
        this.iconListWidget.setCellRenderer(renderer);
        this.iconListWidget.setLayoutOrientation(2);
        if (this.style == 1) {
            this.iconListWidget.setVisibleRowCount(1);
        }
        this.iconListWidget.setSelectionMode(0);
        JPanel listPanel = new JPanel();
        listPanel.setBackground(this.iconListWidget.getBackground());
        listPanel.setLayout(new BoxLayout(listPanel, 2));
        listPanel.add(Box.createHorizontalGlue());
        listPanel.add(this.iconListWidget);
        listPanel.add(Box.createHorizontalGlue());
        this.listScrollPane = new JScrollPane(listPanel, 21, 32);
        this.setLayout(new BorderLayout());
        this.add((Component)this.listScrollPane, "Center");
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.iconListWidget.addMouseListener(l);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.iconListWidget.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.iconListWidget.removeListSelectionListener(listener);
    }

    public FormDataObjIFace getSelectedValue() {
        return (FormDataObjIFace)this.iconListWidget.getSelectedValue();
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.iconListWidget.setCellRenderer(renderer);
    }

    public synchronized void setFixedCellHeight(int height) {
        this.iconListWidget.setFixedCellHeight(height);
    }

    protected void reorder() {
        int i = 0;
        while (i < this.listModel.getSize()) {
            Object obj = this.listModel.getElementAt(i);
            if (obj instanceof Orderable) {
                ((Orderable)obj).setOrderIndex(i);
            }
            ++i;
        }
    }

    public synchronized void addItem(FormDataObjIFace item) {
        this.listModel.add(item);
        this.reorder();
    }

    public synchronized boolean removeItem(FormDataObjIFace item) {
        boolean retVal = this.listModel.remove(item);
        this.iconListWidget.clearSelection();
        this.reorder();
        return retVal;
    }

    public synchronized void removeAllItems() {
        while (this.listModel.getSize() > 0) {
            this.listModel.remove(0);
        }
    }

    public synchronized Set<Object> getItems() {
        HashSet<Object> set = new HashSet<Object>();
        int i = 0;
        while (i < this.listModel.getSize()) {
            set.add(this.listModel.getElementAt(i));
            ++i;
        }
        return set;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = Math.max(this.minHeight, d.height);
        d.width = Math.min(this.maxWidth, d.width);
        return d;
    }

    public FormDataObjIFace getSelection() {
        Object selection = this.iconListWidget.getSelectedValue();
        if (selection == null) {
            return null;
        }
        return (FormDataObjIFace)selection;
    }

    public void setSelectedIndex(int index) {
        this.iconListWidget.setSelectedIndex(-1);
    }

    protected Vector<FormDataObjIFace> sortSet(Set<?> values) {
        Vector<FormDataObjIFace> tmpList = new Vector<FormDataObjIFace>(values.size());
        for (Object o : values) {
            FormDataObjIFace obj = (FormDataObjIFace)o;
            tmpList.add(obj);
        }
        Collections.sort(tmpList, new FormDataObjComparator());
        return tmpList;
    }
}

