/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.IconEntry;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class IconManager
extends Component {
    private static final Logger log = Logger.getLogger(IconManager.class);
    public static final IconSize STD_ICON_SIZE = IconSize.Std20;
    protected static final String relativePath = "images/";
    protected static final IconManager instance = new IconManager();
    protected static String subdirPath = null;
    protected Class<?> appClass = null;
    protected Hashtable<String, Vector<String>> iconSets = new Hashtable();
    protected Hashtable<String, IconEntry> defaultEntries = new Hashtable();
    protected Vector<String> iconListForType = null;

    protected IconManager() {
    }

    public static void setApplicationClass(Class<?> appClass) {
        IconManager.instance.appClass = appClass;
        if (IconManager.instance.defaultEntries.size() == 0) {
            IconManager.loadIcons();
        }
    }

    public static IconEntry register(String iconName, String fileName, IconSize id) {
        URL url = IconManager.getImagePath(fileName);
        if (url == null) {
            log.error((Object)("Couldn't find URL for resource path: [" + relativePath + (subdirPath != null ? subdirPath : "") + fileName + "]"));
        }
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(url);
        }
        catch (NullPointerException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(IconManager.class, ex);
            log.error((Object)("Image at URL [" + url + "] [" + iconName + "] [" + fileName + "] couldn't be loaded."));
        }
        return icon != null ? IconManager.register(iconName, icon, url, id) : null;
    }

    public static IconEntry register(String iconName, ImageIcon icon, URL path, IconSize id) {
        if (IconManager.instance.iconListForType != null && IconManager.instance.defaultEntries.get(iconName) != null) {
            log.error((Object)("Icon name is already registered[" + iconName + "]"));
            return null;
        }
        if (icon != null) {
            IconEntry entry = new IconEntry(iconName, id, path);
            if (path == null) {
                entry.setIcon(icon);
            }
            IconManager.instance.defaultEntries.put(iconName, entry);
            if (IconManager.instance.iconListForType != null) {
                IconManager.instance.iconListForType.add(iconName);
            }
            return entry;
        }
        log.error((Object)("Can't register null icon name[" + iconName + "] Size:" + id.toString()));
        return null;
    }

    public static IconSize getIconSize(int size, boolean bw, boolean faded) {
        if (size != 32 && size != 24 && size != 16) {
            throw new RuntimeException("Wrong icon size! " + size);
        }
        if (bw) {
            switch (size) {
                case 32: {
                    return IconSize.Std32BW;
                }
                case 24: {
                    return IconSize.Std24BW;
                }
                case 16: {
                    return IconSize.Std16BW;
                }
            }
        } else if (faded) {
            switch (size) {
                case 32: {
                    return IconSize.Std32Fade;
                }
                case 24: {
                    return IconSize.Std24Fade;
                }
                case 16: {
                    return IconSize.Std16Fade;
                }
            }
        } else {
            switch (size) {
                case 32: {
                    return IconSize.Std32;
                }
                case 24: {
                    return IconSize.Std24;
                }
                case 20: {
                    return IconSize.Std20;
                }
                case 16: {
                    return IconSize.Std16;
                }
            }
        }
        return null;
    }

    public static ImageIcon getScaledIcon(ImageIcon icon, IconSize iconSize, IconSize scaledIconSize) {
        IconEntry entry = null;
        for (IconEntry et : IconManager.instance.defaultEntries.values()) {
            if (et.getIcon() != icon) continue;
            entry = et;
            break;
        }
        if (entry != null) {
            return entry.getIcon(scaledIconSize);
        }
        if (icon != null) {
            return IconManager.createNewScaledIcon(icon, iconSize, scaledIconSize);
        }
        log.error((Object)("Couldn't find icon [" + (Object)((Object)iconSize) + "] to scale to [" + (Object)((Object)scaledIconSize) + "]"));
        return null;
    }

    public static ImageIcon createNewScaledIcon(ImageIcon icon, IconSize iconSize, IconSize scaledIconSize) {
        return new ImageIcon(instance.getFastScale(icon, iconSize, scaledIconSize));
    }

    public static ImageIcon getIcon(String iconName, IconSize id) {
        IconEntry entry = IconManager.instance.defaultEntries.get(iconName);
        if (entry != null) {
            return entry.getIcon(id);
        }
        return null;
    }

    public static ImageIcon getIcon(String iconName) {
        if (iconName == null) {
            throw new NullPointerException("icon name should not be null!");
        }
        IconEntry entry = IconManager.instance.defaultEntries.get(iconName);
        if (entry != null) {
            return entry.getIcon();
        }
        return null;
    }

    protected static IconSize getSizeFromInt(int size) {
        switch (size) {
            case 16: {
                return IconSize.Std16;
            }
            case 20: {
                return IconSize.Std20;
            }
            case 24: {
                return IconSize.Std24;
            }
            case 32: {
                return IconSize.Std32;
            }
        }
        throw new ConfigurationException("Desired Icon size doesn't exist! [" + size + "]");
    }

    public static void loadIcons() {
        IconManager.loadIcons(XMLHelper.getConfigDir("icons.xml"));
    }

    public static void loadIcons(File iconFile) {
        try {
            Element root = XMLHelper.readFileToDOM4J(iconFile);
            if (root != null) {
                Hashtable<String, String> aliases = new Hashtable<String, String>();
                Element iconsNode = (Element)root.selectSingleNode("/icons");
                String type = XMLHelper.getAttr(iconsNode, "type", null);
                String subdir = XMLHelper.getAttr(iconsNode, "subdir", null);
                if (StringUtils.isNotEmpty((String)type)) {
                    if (IconManager.instance.iconSets.get(type) == null) {
                        IconManager.instance.iconListForType = new Vector();
                        IconManager.instance.iconSets.put(type, IconManager.instance.iconListForType);
                    } else {
                        log.debug((Object)("Type [" + type + "] has already been loaded."));
                    }
                }
                subdirPath = StringUtils.isNotEmpty((String)subdir) ? String.valueOf(subdir) + "/" : null;
                List boxes = root.selectNodes("/icons/icon");
                for (Element iconElement : boxes) {
                    String name = iconElement.attributeValue("name");
                    String sizes = iconElement.attributeValue("sizes");
                    String file = iconElement.attributeValue("file");
                    String alias = iconElement.attributeValue("alias");
                    if (StringUtils.isNotEmpty((String)alias)) {
                        aliases.put(name, alias);
                        continue;
                    }
                    if (sizes == null || sizes.length() == 0 || sizes.toLowerCase().equals("all")) {
                        IconManager.register(name, file, IconSize.Std32);
                        continue;
                    }
                    if (sizes.toLowerCase().equals("nonstd")) {
                        IconManager.register(name, file, IconSize.NonStd);
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(sizes, ",");
                    while (st.hasMoreTokens()) {
                        String sz = st.nextToken();
                        IconManager.register(name, file, IconManager.getSizeFromInt(Integer.parseInt(sz)));
                    }
                }
                for (String name : aliases.keySet()) {
                    IconEntry entry = IconManager.instance.defaultEntries.get(aliases.get(name));
                    if (entry == null) continue;
                    IconManager.instance.defaultEntries.put(name, entry);
                }
            } else {
                log.debug((Object)"Couldn't open icons.xml");
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(IconManager.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
        subdirPath = null;
        IconManager.instance.iconListForType = null;
    }

    public static void makeAlias(String iconName, String aliasName) {
        IconEntry entry = IconManager.instance.defaultEntries.get(iconName);
        if (entry != null) {
            IconEntry aliasEntry = new IconEntry(entry.getName(), entry.getSize(), entry.getUrl(), true, entry.getIcons());
            IconManager.instance.defaultEntries.put(aliasName, aliasEntry);
        }
    }

    public static void aliasImages(String iconName, String aliasName) {
        IconEntry entry = IconManager.instance.defaultEntries.get(iconName);
        if (entry != null) {
            IconEntry aliasEntry = IconManager.instance.defaultEntries.get(aliasName);
            if (entry != null) {
                aliasEntry.setIcon(entry.getIcon());
                aliasEntry.setIcons(entry.getIcons());
                aliasEntry.setUrl(entry.getUrl());
                aliasEntry.setSize(entry.getSize());
            } else {
                log.error((Object)("Couldn't find icon entry[" + aliasName + "] (destination of images)"));
            }
        } else {
            log.error((Object)("Couldn't find icon entry[" + iconName + "] (source of images)"));
        }
    }

    public static List<Pair<String, ImageIcon>> getListByType(String type, IconSize size) {
        Vector<String> nameList = IconManager.instance.iconSets.get(type);
        if (nameList != null) {
            Vector<Pair<String, ImageIcon>> icons = new Vector<Pair<String, ImageIcon>>();
            for (String key : nameList) {
                ImageIcon ii = IconManager.getIcon(key, size);
                if (ii == null) continue;
                icons.add(new Pair<String, ImageIcon>(key, ii));
            }
            return icons;
        }
        return null;
    }

    public static URL getURLForIcon(ImageIcon icon, IconSize size) {
        for (IconEntry entry : IconManager.instance.defaultEntries.values()) {
            for (IconEntry.IconSizeEntry sizeEntry : entry.getIcons().values()) {
                if (!sizeEntry.isIconAvailable() || icon != sizeEntry.getImageIcon()) continue;
                return entry.getUrl();
            }
        }
        return null;
    }

    public static ImageIcon createBWImage(ImageIcon img) {
        BufferedImage bi = new BufferedImage(img.getIconWidth(), img.getIconHeight(), 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img.getImage(), 0, 0, null);
        ColorConvertOp colorConvert = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        colorConvert.filter(bi, bi);
        ImageIcon icon = new ImageIcon(bi);
        g.dispose();
        return icon;
    }

    public static ImageIcon createFadedImage(ImageIcon icon) {
        Image image = GrayFilter.createDisabledImage(icon.getImage());
        return new ImageIcon(image);
    }

    public static URL getImagePath(String imageName) {
        return IconManager.instance.appClass.getResource(relativePath + (subdirPath != null ? subdirPath : "") + imageName);
    }

    public static IconEntry getIconEntryByName(String iconName) {
        return IconManager.instance.defaultEntries.get(iconName);
    }

    public static ImageIcon getImage(String imageName) {
        return IconManager.getIcon(imageName, IconSize.Std32);
    }

    public static ImageIcon getImage(String imageName, IconSize id) {
        return IconManager.getIcon(imageName, id);
    }

    public Image getFastScale(ImageIcon icon, IconSize iconSize, IconSize scaledIconSize) {
        if (icon != null) {
            int width = scaledIconSize.size();
            int height = scaledIconSize.size();
            if (width < 0 || height < 0) {
                width = icon.getIconWidth();
                height = icon.getIconHeight();
            }
            Image imgMemory = this.createImage(icon.getImage().getSource());
            imgMemory = new ImageIcon(imgMemory).getImage();
            BufferedImage thumbImage = new BufferedImage(width, height, 2);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(imgMemory, 0, 0, width, height, null);
            graphics2D.dispose();
            imgMemory = thumbImage;
            return imgMemory;
        }
        log.error((Object)("Couldn't find icon [" + (Object)((Object)iconSize) + "] to scale to [" + (Object)((Object)scaledIconSize) + "]"));
        return null;
    }

    public static String makeIconName(String baseName) {
        String postFix = "";
        if (UIRegistry.isEmbedded().booleanValue()) {
            postFix = "E";
        } else if (UIRegistry.isMobile()) {
            postFix = "M";
        }
        return String.valueOf(baseName) + postFix;
    }

    public static enum IconSize {
        Std32(32, false, false),
        Std24(24, false, false),
        Std20(20, false, false),
        Std16(16, false, false),
        Std8(8, false, false),
        Std32Fade(32, true, false),
        Std24Fade(24, true, false),
        Std16Fade(16, true, false),
        Std8Fade(8, true, false),
        Std32BW(32, false, true),
        Std24BW(24, false, true),
        Std16BW(16, false, true),
        Std8BW(8, false, true),
        Std32FadeBW(32, true, true),
        Std24FadeBW(24, true, true),
        Std16FadeBW(16, true, true),
        Std8FadeBW(8, true, true),
        NonStd(-1, false, false);

        private int size;
        private boolean faded;
        private boolean blackWhite;

        private IconSize(int size, boolean faded, boolean blackWhite) {
            this.size = size;
            this.faded = faded;
            this.blackWhite = blackWhite;
        }

        public Integer size() {
            return this.size;
        }

        public boolean faded() {
            return this.faded;
        }

        public boolean blackWhite() {
            return this.blackWhite;
        }

        public String toString() {
            return "Std" + Integer.toString(this.size) + (this.faded ? "f" : "") + (this.blackWhite ? "BW" : "");
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setFaded(boolean faded) {
            this.faded = faded;
        }

        public void setBlackWhite(boolean bw) {
            this.blackWhite = bw;
        }
    }
}

