/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.IconManager;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class IconEntry {
    private String name;
    private boolean isAlias;
    private Hashtable<IconManager.IconSize, IconSizeEntry> icons = null;
    private IconManager.IconSize size;
    private URL url;
    private ImageIcon imageIcon = null;

    public IconEntry(String name, IconManager.IconSize size, URL url, boolean isAlias, Hashtable<IconManager.IconSize, IconSizeEntry> iconHash) {
        this.name = name;
        this.size = size;
        this.url = url;
        this.isAlias = isAlias;
        this.icons = iconHash;
    }

    public IconEntry(String name, IconManager.IconSize size, URL url) {
        this(name, size, url, false, new Hashtable<IconManager.IconSize, IconSizeEntry>());
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public void setAlias(boolean isAlias) {
        this.isAlias = isAlias;
    }

    public Hashtable<IconManager.IconSize, IconSizeEntry> getIcons() {
        return this.icons;
    }

    public void setIcons(Hashtable<IconManager.IconSize, IconSizeEntry> icons) {
        if (this.icons == null) {
            this.icons = new Hashtable();
        }
        this.icons.clear();
        for (IconManager.IconSize sz : icons.keySet()) {
            this.icons.put(sz, icons.get((Object)sz));
        }
    }

    public ImageIcon getIcon(IconManager.IconSize id) {
        this.imageIcon = this.getIcon();
        IconSizeEntry sizeEntry = this.icons.get((Object)id);
        if (sizeEntry == null) {
            ImageIcon imgIcon = IconManager.createNewScaledIcon(this.imageIcon, this.size, id);
            if (id.blackWhite()) {
                imgIcon = IconManager.createBWImage(imgIcon);
            }
            if (id.faded()) {
                imgIcon = IconManager.createFadedImage(imgIcon);
            }
            IconSizeEntry newSizeEntry = new IconSizeEntry(id, imgIcon);
            this.icons.put(id, newSizeEntry);
            return imgIcon;
        }
        return sizeEntry.getImageIcon();
    }

    public IconManager.IconSize getSize() {
        return this.size;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setSize(IconManager.IconSize size) {
        this.size = size;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    public ImageIcon getIcon() {
        if (this.imageIcon == null) {
            this.imageIcon = new ImageIcon(this.url);
        }
        return this.imageIcon;
    }

    public String getName() {
        return this.name;
    }

    public class IconSizeEntry {
        protected IconManager.IconSize iseSize;
        protected ImageIcon iseImageIcon;

        public IconSizeEntry(IconManager.IconSize size) {
            this.iseSize = size;
            this.iseImageIcon = null;
        }

        public IconSizeEntry(IconManager.IconSize size, ImageIcon imageIcon) {
            this.iseSize = size;
            this.iseImageIcon = imageIcon;
        }

        public boolean isIconAvailable() {
            return this.iseImageIcon != null;
        }

        public ImageIcon getImageIcon() {
            if (this.iseImageIcon == null) {
                this.iseImageIcon = new ImageIcon(IconEntry.this.url);
            }
            return this.iseImageIcon;
        }

        public void setImageIcon(ImageIcon iseImageIcon) {
            this.iseImageIcon = iseImageIcon;
        }

        public IconManager.IconSize getSize() {
            return this.iseSize;
        }
    }
}

