/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.Triple;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class IconButton
extends JButton {
    protected Color hoverColor = UIHelper.getHoverColor();
    protected Color focusColor = null;
    protected Border emptyBorder;
    protected Border focusBorder = null;
    protected boolean hasFocus = false;
    protected boolean isHovering = false;

    public IconButton(Icon icon, boolean withEmptyBorder) {
        super(icon);
        this.init(withEmptyBorder);
    }

    public IconButton(String text, Icon icon, boolean withEmptyBorder) {
        super(text, icon);
        this.init(withEmptyBorder);
    }

    protected void init(boolean withEmptyBorder) {
        Triple<Border, Border, Color> focusInfo = UIHelper.getFocusBorders(this);
        this.focusBorder = (Border)focusInfo.first;
        this.emptyBorder = (Border)focusInfo.second;
        this.focusColor = (Color)focusInfo.third;
        this.setOpaque(false);
        if (!withEmptyBorder) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    IconButton.this.isHovering = true;
                    IconButton.this.repaint();
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    IconButton.this.isHovering = false;
                    IconButton.this.repaint();
                    super.mouseExited(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    IconButton.this.hasFocus = true;
                    if (((JButton)e.getSource()).isEnabled()) {
                        ((JButton)e.getSource()).setBorder(IconButton.this.focusBorder);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    IconButton.this.hasFocus = false;
                    if (((JButton)e.getSource()).isEnabled()) {
                        ((JButton)e.getSource()).setBorder(IconButton.this.emptyBorder);
                    }
                }
            });
            this.setBorder(this.emptyBorder);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isHovering && !this.hasFocus && this.isEnabled()) {
            g.setColor(this.hoverColor);
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(insets.left, insets.top, size.width - insets.right - insets.left, size.height - insets.bottom - insets.top, 10.0, 10.0);
            g2d.setStroke(UIHelper.getStdLineStroke());
            g2d.draw(rr);
            rr = new RoundRectangle2D.Double(insets.left + 1, insets.top + 1, size.width - insets.right - insets.left - 2, size.height - insets.bottom - insets.top - 2, 10.0, 10.0);
            g2d.draw(rr);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!enable) {
            this.setBorder(this.emptyBorder);
            this.repaint();
        }
    }
}

