/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.util.UUEncoder;
import sun.misc.UUDecoder;

public class GraphicsUtils {
    protected static RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static void drawCircle(Graphics g, int x, int y, int diameter) {
        ((Graphics2D)g).addRenderingHints(hints);
        g.drawOval(x - diameter / 2, y - diameter / 2, diameter, diameter);
    }

    public static void fillCircle(Graphics g, int x, int y, int diameter) {
        ((Graphics2D)g).addRenderingHints(hints);
        g.fillOval(x - diameter / 2, y - diameter / 2, diameter, diameter);
    }

    public static void drawCenteredString(String s, Graphics g, int x, int y) {
        ((Graphics2D)g).addRenderingHints(hints);
        FontMetrics fm = g.getFontMetrics();
        int ht = fm.getAscent() + fm.getDescent();
        int width = fm.stringWidth(s);
        g.drawString(s, x - width / 2, y + (fm.getAscent() - ht / 2));
    }

    public static void drawArrow(Graphics g, int xCenter, int yCenter, int x, int y, int headSize, float stroke) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(hints);
        double aDir = Math.atan2(xCenter - x, yCenter - y);
        Stroke origStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(stroke));
        g2d.drawLine(x, y, xCenter, yCenter);
        Polygon tmpPoly = new Polygon();
        int i1 = 2 * headSize + (int)stroke;
        int i2 = headSize + (int)stroke;
        tmpPoly.addPoint(x, y);
        tmpPoly.addPoint(x + GraphicsUtils.xCor(i1, aDir + 0.5), y + GraphicsUtils.yCor(i1, aDir + 0.5));
        tmpPoly.addPoint(x + GraphicsUtils.xCor(i2, aDir), y + GraphicsUtils.yCor(i2, aDir));
        tmpPoly.addPoint(x + GraphicsUtils.xCor(i1, aDir - 0.5), y + GraphicsUtils.yCor(i1, aDir - 0.5));
        tmpPoly.addPoint(x, y);
        g2d.drawPolygon(tmpPoly);
        g2d.fillPolygon(tmpPoly);
        g2d.setStroke(origStroke);
    }

    public static Point getPointAlongLine(Point start, Point end, float percent) {
        int x = start.x + (int)(percent * (float)(end.x - start.x));
        int y = start.y + (int)(percent * (float)(end.y - start.y));
        return new Point(x, y);
    }

    public static double distance(Point a, Point b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0));
    }

    private static int yCor(int len, double dir) {
        return (int)((double)len * Math.cos(dir));
    }

    private static int xCor(int len, double dir) {
        return (int)((double)len * Math.sin(dir));
    }

    public static void turnOnAntialiasedDrawing(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public static ImageIcon scaleImageToIconImage(BufferedImage img, int maxHeight, int maxWidth, boolean preserveAspectRatio, boolean doHighQuality) throws IOException {
        byte[] bytes = GraphicsUtils.scaleImage(img, maxHeight, maxWidth, preserveAspectRatio, doHighQuality);
        if (bytes != null && bytes.length > 0) {
            return new ImageIcon(bytes);
        }
        return null;
    }

    public static byte[] scaleImage(byte[] imgData, int maxHeight, int maxWidth, boolean preserveAspectRatio, boolean doHighQuality) throws IOException {
        ByteArrayInputStream inputStr = new ByteArrayInputStream(imgData);
        BufferedImage orig = ImageIO.read(inputStr);
        return GraphicsUtils.scaleImage(orig, maxHeight, maxWidth, preserveAspectRatio, doHighQuality);
    }

    public static byte[] scaleImage(BufferedImage orig, int maxHeight, int maxWidth, boolean preserveAspectRatio, boolean doHighQuality) throws IOException {
        int targetW = maxWidth;
        int targetH = maxHeight;
        if (preserveAspectRatio) {
            double scaledRatio;
            int origHeight;
            int origWidth = orig.getWidth();
            double origRatio = (double)origWidth / (double)(origHeight = orig.getHeight());
            if (origRatio > (scaledRatio = (double)maxWidth / (double)maxHeight)) {
                targetH = (int)((double)targetW / origRatio);
            } else {
                targetW = (int)((double)targetH * origRatio);
            }
        }
        BufferedImage scaled = GraphicsUtils.getScaledInstance(orig, targetW, targetH, doHighQuality);
        ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
        ImageIO.write((RenderedImage)scaled, "jpeg", output);
        byte[] outputBytes = output.toByteArray();
        output.close();
        return outputBytes;
    }

    public static BufferedImage generateScaledImage(BufferedImage bufImg, Object hintsArg, int size) {
        BufferedImage sourceImage = bufImg;
        int srcWidth = sourceImage.getWidth();
        int srcHeight = sourceImage.getHeight();
        double longSideForSource = Math.max(srcWidth, srcHeight);
        double longSideForDest = size;
        double multiplier = longSideForDest / longSideForSource;
        int destWidth = (int)((double)srcWidth * multiplier);
        int destHeight = (int)((double)srcHeight * multiplier);
        BufferedImage destImage = null;
        destImage = new BufferedImage(destWidth, destHeight, 1);
        Graphics2D graphics2D = destImage.createGraphics();
        graphics2D.drawImage(sourceImage, 0, 0, destWidth, destHeight, null);
        graphics2D.dispose();
        return destImage;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, boolean higherQuality) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage temp = img;
        BufferedImage result = new BufferedImage(targetWidth, targetHeight, type);
        Graphics2D g2 = result.createGraphics();
        if (higherQuality) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g2.drawImage(temp, 0, 0, targetWidth, targetHeight, null);
        g2.dispose();
        return result;
    }

    public static String clipString(FontMetrics fm, String text, int availableWidth) {
        if (text == null) {
            return "";
        }
        if (fm.stringWidth(text) < availableWidth) {
            return text;
        }
        String dots = "...";
        StringBuilder sb = new StringBuilder(String.valueOf(text) + dots);
        while (fm.stringWidth(sb.toString()) > availableWidth) {
            sb.deleteCharAt(sb.length() - 4);
        }
        return sb.toString();
    }

    public static BufferedImage getBufferedImage(ImageIcon icon) {
        Image imgMemory = icon.getImage();
        imgMemory = new ImageIcon(imgMemory).getImage();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(w, h, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(imgMemory, 0, 0, w, h, 0, 0, w, h, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image getScaledImage(ImageIcon icon, int newMaxWidth, int newMaxHeight, boolean maintainRatio) {
        if (icon != null) {
            int dstWidth = newMaxWidth;
            int dstHeight = newMaxHeight;
            int srcWidth = icon.getIconWidth();
            int srcHeight = icon.getIconHeight();
            if (dstWidth < 0 || dstHeight < 0) {
                dstWidth = icon.getIconWidth();
                dstHeight = icon.getIconHeight();
            }
            if (maintainRatio) {
                double longSideForSource = Math.max(srcWidth, srcHeight);
                double longSideForDest = Math.max(dstWidth, dstHeight);
                double multiplier = longSideForDest / longSideForSource;
                dstWidth = (int)((double)srcWidth * multiplier);
                dstHeight = (int)((double)srcHeight * multiplier);
            }
            Image imgMemory = icon.getImage();
            imgMemory = new ImageIcon(imgMemory).getImage();
            BufferedImage thumbImage = new BufferedImage(dstWidth, dstHeight, 2);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(imgMemory, 0, 0, dstWidth, dstHeight, 0, 0, srcWidth, srcHeight, null);
            graphics2D.dispose();
            return thumbImage;
        }
        return null;
    }

    public static byte[] readImage(String srcFile) {
        return GraphicsUtils.readImage(new File(srcFile));
    }

    public static byte[] readImage(File srcFile) {
        if (srcFile != null && srcFile.exists()) {
            try {
                String ext = FilenameUtils.getExtension((String)srcFile.getName());
                if (ext.equals("tif") || ext.equals("tiff")) {
                    return GraphicsUtils.readTiffImage(srcFile);
                }
                return FileUtils.readFileToByteArray((File)srcFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] readTiffImage(String fileName) {
        return GraphicsUtils.readTiffImage(new File(fileName));
    }

    public static byte[] readTiffImage(File fileName) {
        return null;
    }

    public static String uuencodeImage(String name, ImageIcon imgIcon) {
        try {
            BufferedImage tmp = new BufferedImage(imgIcon.getIconWidth(), imgIcon.getIconWidth(), 2);
            Graphics2D g2 = tmp.createGraphics();
            g2.drawImage(imgIcon.getImage(), 0, 0, imgIcon.getIconWidth(), imgIcon.getIconWidth(), null);
            g2.dispose();
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            ImageIO.write((RenderedImage)tmp, "PNG", output);
            byte[] outputBytes = output.toByteArray();
            output.close();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            UUEncoder uuencode = new UUEncoder(name);
            uuencode.encode((InputStream)new ByteArrayInputStream(outputBytes), (OutputStream)bos);
            return bos.toString();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(GraphicsUtils.class, ex);
            ex.printStackTrace();
            return "";
        }
    }

    public static ImageIcon uudecodeImage(String name, String str) {
        try {
            UUDecoder decoder = new UUDecoder();
            ByteBuffer bb = decoder.decodeBufferToByteBuffer(str);
            ImageIcon img = new ImageIcon(bb.array());
            return img;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(GraphicsUtils.class, ex);
            ex.printStackTrace();
            return null;
        }
    }
}

