/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class GradiantLabel
extends JLabel {
    protected Color textColor = null;
    protected Color textColorShadow = null;
    protected Color bgBaseColor = null;
    protected Color gradiantTop = null;
    protected Color gradiantBot = null;

    public GradiantLabel(String text) {
        super(text);
        this.setTextColor(Color.BLACK);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.bgBaseColor = new JLabel().getBackground();
    }

    public GradiantLabel(String text, int align) {
        super(text, align);
        this.setTextColor(Color.BLACK);
        this.bgBaseColor = new JLabel().getBackground();
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        float scale = 1.25f * this.getFont().getSize2D();
        int w = fm.stringWidth(text);
        w += (int)(scale * 1.4f);
        int h = fm.getHeight();
        h += (int)(scale * 0.3f);
        Icon icon = this.getIcon();
        if (icon != null) {
            h = Math.max(icon.getIconHeight(), h);
            w += icon.getIconWidth() + this.getIconTextGap();
        }
        return new Dimension(w, h);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        String text = this.getText();
        int textWidth = g2.getFontMetrics().stringWidth(text);
        int w = this.getWidth();
        int h = this.getHeight();
        g2.fillRect(0, 0, w, h);
        this.drawLabelBody(w, h, this.bgBaseColor, g2);
        Icon icon = this.getIcon();
        if (icon == null) {
            this.drawText(w, h, text, textWidth, g2);
        } else if (this.getHorizontalTextPosition() == 2) {
            int offsetX = this.drawText(w, h, text, textWidth, g2);
            icon.paintIcon(this, g2, offsetX + textWidth + this.getIconTextGap(), h > icon.getIconHeight() ? (h - icon.getIconHeight()) / 2 : 0);
        } else {
            icon.paintIcon(this, g2, 0, h > icon.getIconHeight() ? (h - icon.getIconHeight()) / 2 : 0);
            this.drawText(this.getIconTextGap() + icon.getIconWidth(), h, text, g2);
        }
    }

    protected void drawLabelBody(int w, int h, Color base, Graphics2D g2) {
        Color grad_top = this.gradiantTop != null ? this.gradiantTop : base.brighter();
        Color grad_bot = this.gradiantBot != null ? this.gradiantBot : base.darker();
        GradientPaint bg = new GradientPaint(new Point(0, 0), grad_top, new Point(0, h), grad_bot);
        g2.setPaint(bg);
        g2.fillRect(0, 0, w, h);
    }

    protected int drawText(int w, int h, String text, int textWidth, Graphics2D g2) {
        int textx = this.getHorizontalAlignment() == 2 ? Math.max(this.getInsets().left, 2) : (w - textWidth) / 2;
        this.drawText(textx, h, text, g2);
        return textx;
    }

    protected void drawText(int x, int h, String text, Graphics2D g2) {
        int fh = g2.getFontMetrics().getAscent() - g2.getFontMetrics().getDescent();
        int texty = h / 2 + fh / 2;
        g2.setColor(this.textColorShadow);
        g2.drawString(text, x, texty);
        g2.setColor(this.textColor);
        g2.drawString(text, x, texty);
    }

    protected static Color alphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public void setGradiants(Color gradiantTop, Color gradiantBot) {
        this.gradiantTop = gradiantTop;
        this.gradiantBot = gradiantBot;
    }

    public Color getTextColorShadow() {
        return this.textColorShadow;
    }

    public void setTextColorShadow(Color textColorShadow) {
        this.textColorShadow = textColorShadow;
    }

    public Color getBGBaseColor() {
        return this.bgBaseColor;
    }

    public void setBGBaseColor(Color bgBaseColor) {
        this.bgBaseColor = bgBaseColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.textColorShadow = new Color(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), 70);
    }
}

