/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.UIRegistry;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;

public class GradiantButton
extends JButton
implements MouseListener {
    protected Color textColor = null;
    protected Color textColorShadow = null;
    protected float iconAlpha = 0.8f;
    protected ImageIcon icon = null;
    protected GradiantButton itself;
    protected boolean isHover = false;
    protected boolean pressed = false;

    public GradiantButton(String text) {
        super(text);
        this.init();
    }

    public GradiantButton(ImageIcon icon) {
        super("");
        this.icon = icon;
        this.setIcon(icon);
        this.init();
    }

    protected void init() {
        this.itself = this;
        this.setTextColor(Color.BLACK);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        super.setBorderPainted(false);
        this.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        float scale = 1.25f * this.getFont().getSize2D();
        int w = fm.stringWidth(text);
        w += (int)(scale * 1.4f);
        int h = fm.getHeight();
        h += (int)(scale * 0.3f);
        if (this.icon != null) {
            if (h <= this.icon.getIconHeight()) {
                h = this.icon.getIconHeight() + 4;
            }
            if (w <= this.icon.getIconWidth()) {
                w = this.icon.getIconWidth() + 2;
            }
        }
        return new Dimension(w, h);
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon paintedIcon;
        String text;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        this.drawButtonBody(g2, w, h, this.getForeground());
        if (this.pressed) {
            g2.translate(1, 1);
        }
        if (StringUtils.isNotEmpty((String)(text = this.getText()))) {
            this.drawText(g2, w, h, this.getText());
        }
        Icon roIcon = this.getRolloverIcon();
        Icon icon = paintedIcon = this.isHover && roIcon != null ? roIcon : this.icon;
        if (paintedIcon != null) {
            g2.setComposite(AlphaComposite.getInstance(3, this.iconAlpha));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            paintedIcon.paintIcon(this, g2, (w - this.icon.getIconWidth()) / 2, (h - this.icon.getIconHeight()) / 2);
        }
    }

    protected void drawButtonBody(Graphics2D g2, int w, int h, Color color) {
        Color grad_top = color.brighter();
        Color grad_bot = color.darker();
        GradientPaint bg = new GradientPaint(new Point(0, 0), grad_top, new Point(0, h), grad_bot);
        g2.setPaint(bg);
        g2.fillRect(0, 0, w, h);
    }

    protected void drawText(Graphics2D g2, int w, int h, String text) {
        int fw = g2.getFontMetrics().stringWidth(text);
        int fh = g2.getFontMetrics().getAscent() - g2.getFontMetrics().getDescent();
        int textx = this.getHorizontalAlignment() == 2 ? Math.max(this.getInsets().left, 2) : (w - fw) / 2;
        int texty = h / 2 + fh / 2;
        g2.setColor(this.textColorShadow);
        g2.drawString(text, textx, texty);
        g2.setColor(this.textColor);
        g2.drawString(text, textx, texty);
    }

    protected static Color alphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.textColorShadow = new Color(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), 70);
    }

    public void setIconAlpha(float iconAlpha) {
        this.iconAlpha = iconAlpha;
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.isHover = false;
        this.repaint();
        UIRegistry.displayStatusBarText("");
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.isHover = true;
        this.repaint();
        UIRegistry.displayStatusBarText(this.itself.getToolTipText());
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.pressed = false;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.pressed = true;
    }
}

