/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.ui.FeedBackSenderItem;
import edu.ku.brc.ui.UIRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class FeedBackSender {
    private static final Logger log = Logger.getLogger(FeedBackSender.class);

    public void capture(Class<?> cls, Exception exception) {
        this.connectToServerNow(this.getFeedBackSenderItem(cls, exception));
    }

    public void capture(Class<?> cls, String message, Exception exception) {
        this.connectToServerNow(this.getFeedBackSenderItem(cls, message, exception));
    }

    public void sendMsg(Class<?> cls, String message, Exception exception) {
        FeedBackSenderItem item = this.getFeedBackSenderItem(cls, message, exception);
        item.setIncludeEmail(false);
        this.connectToServerNow(item);
    }

    public void sendFeedback() {
        this.connectToServerNow(this.getFeedBackSenderItem(null, null));
    }

    protected FeedBackSenderItem getFeedBackSenderItem(Class<?> cls, Exception exception) {
        return this.getFeedBackSenderItem(cls, null, exception);
    }

    protected FeedBackSenderItem getFeedBackSenderItem(Class<?> cls, String comments, Exception exception) {
        FeedBackSenderItem item = new FeedBackSenderItem();
        item.setStackTrace(exception != null ? exception.getMessage() : null);
        item.setClassName(cls != null ? cls.getName() : null);
        item.setComments(comments);
        return item;
    }

    protected abstract String getSenderURL();

    protected void send(FeedBackSenderItem item) throws Exception {
        if (item != null) {
            HttpClient httpClient = new HttpClient();
            httpClient.getParams().setParameter("http.useragent", (Object)this.getClass().getName());
            PostMethod postMethod = new PostMethod(this.getSenderURL());
            NameValuePair[] postParams = this.createPostParameters(item);
            postMethod.setRequestBody(postParams);
            try {
                httpClient.executeMethod((HttpMethod)postMethod);
                String responseString = postMethod.getResponseBodyAsString();
                if (StringUtils.isNotEmpty((String)responseString)) {
                    System.err.println(responseString);
                }
            }
            catch (UnknownHostException uex) {
                log.error((Object)uex.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected NameValuePair[] createPostParameters(FeedBackSenderItem item) {
        Vector<NameValuePair> postParams = new Vector<NameValuePair>();
        try {
            postParams.add(new NameValuePair("bug", item.getBug()));
            postParams.add(new NameValuePair("class_name", item.getClassName()));
            postParams.add(new NameValuePair("comments", item.getComments()));
            postParams.add(new NameValuePair("stack_trace", item.getStackTrace()));
            postParams.add(new NameValuePair("task_name", item.getTaskName()));
            postParams.add(new NameValuePair("title", item.getTitle()));
            String installID = UsageTracker.getInstallId();
            postParams.add(new NameValuePair("id", installID));
            Runtime runtime = Runtime.getRuntime();
            Long usedMemory = runtime.maxMemory() - (runtime.totalMemory() + runtime.freeMemory());
            Long maxMemory = runtime.maxMemory();
            postParams.add(new NameValuePair("os_name", System.getProperty("os.name")));
            postParams.add(new NameValuePair("os_version", System.getProperty("os.version")));
            postParams.add(new NameValuePair("java_version", System.getProperty("java.version")));
            postParams.add(new NameValuePair("java_vendor", System.getProperty("java.vendor")));
            postParams.add(new NameValuePair("max_memory", maxMemory.toString()));
            postParams.add(new NameValuePair("used_memory", usedMemory.toString()));
            Properties props = item.getProps();
            if (props != null) {
                for (Object key : props.keySet()) {
                    postParams.add(new NameValuePair(key.toString(), props.getProperty(key.toString())));
                }
            }
            postParams.add(new NameValuePair("user_name", System.getProperty("user.name")));
            try {
                postParams.add(new NameValuePair("ip", InetAddress.getLocalHost().getHostAddress()));
            }
            catch (UnknownHostException key) {
                // empty catch block
            }
            String resAppVersion = UIRegistry.getAppVersion();
            if (StringUtils.isEmpty((String)resAppVersion)) {
                resAppVersion = "Unknown";
            }
            postParams.add(new NameValuePair("app_version", resAppVersion));
            Vector<NameValuePair> extraStats = this.collectionSecondaryInfo(item);
            if (extraStats != null) {
                postParams.addAll(extraStats);
            }
            NameValuePair[] paramArray = new NameValuePair[postParams.size()];
            int i = 0;
            while (i < paramArray.length) {
                paramArray[i] = (NameValuePair)postParams.get(i);
                ++i;
            }
            return paramArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Vector<NameValuePair> collectionSecondaryInfo(FeedBackSenderItem item) {
        return null;
    }

    protected void connectToServerNow(final FeedBackSenderItem item) {
        if (item != null) {
            SwingWorker workerThread = new SwingWorker(){

                @Override
                public Object construct() {
                    try {
                        FeedBackSender.this.send(item);
                        return null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return e;
                    }
                }

                @Override
                public void finished() {
                }
            };
            workerThread.start();
        }
    }
}

