/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.ExtendedTabPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

public class ExtendedTabbedPane
extends JTabbedPane {
    private static final Logger log = Logger.getLogger(ExtendedTabbedPane.class);
    protected static final int CLOSER_SIZE = 5;
    protected Rectangle closerRect = new Rectangle();
    protected boolean isOver = false;

    public ExtendedTabbedPane() {
        this.init();
    }

    public ExtendedTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.init();
    }

    public ExtendedTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.init();
    }

    protected void init() {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ExtendedTabbedPane.this.closerRect.contains(e.getPoint())) {
                    ExtendedTabbedPane.this.isOver = false;
                    ExtendedTabbedPane.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ExtendedTabbedPane.this.closerRect.contains(e.getPoint())) {
                    ExtendedTabbedPane.this.isOver = true;
                    ExtendedTabbedPane.this.repaint();
                } else if (ExtendedTabbedPane.this.isOver) {
                    ExtendedTabbedPane.this.isOver = false;
                    ExtendedTabbedPane.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ExtendedTabbedPane.this.closerRect.contains(e.getPoint())) {
                    ExtendedTabbedPane.this.closeCurrent();
                }
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    protected ExtendedTabPanel adjustTab(String title, Icon icon, Component comp, int index) {
        ExtendedTabPanel tabUI = new ExtendedTabPanel(comp, title, icon);
        this.setTabComponentAt(index, tabUI);
        return tabUI;
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(null, null, component, tip, index);
        this.adjustTab(title, icon, component, index);
    }

    protected void closeCurrent() {
        this.remove(this.getSelectedComponent());
    }

    protected void drawCloser(Graphics g, int x, int y, int w, int h) {
        this.closerRect.setBounds(x, y, w, h);
        g.drawLine(x, y, x + w, y + h);
        g.drawLine(x + w, y, x, y + h);
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error((Object)ex);
        }
        if (this.getTabCount() > 0) {
            Dimension s = this.getSize();
            s.width -= 6;
            s.height -= 6;
            Color color = this.getBackground();
            int x = s.width - 5;
            int y = s.height - 5;
            if (this.isOver) {
                g.setColor(Color.RED);
                this.drawCloser(g, x, y, 5, 5);
            } else {
                g.setColor(color.darker());
                this.drawCloser(g, x, y, 5, 5);
            }
        } else {
            this.closerRect.setBounds(0, 0, 0, 0);
        }
    }
}

