/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExtendedTabPanel
extends JPanel {
    protected JLabel textLabel;
    protected Icon icon;
    protected Component comp;

    public ExtendedTabPanel(Component comp, String title, Icon icon) {
        super(new BorderLayout());
        this.comp = comp;
        this.icon = icon;
        JLabel closeBtn = new JLabel(IconManager.getIcon("Close"));
        closeBtn.setBorder(null);
        closeBtn.setOpaque(false);
        closeBtn.addMouseListener(new TabMouseAdapter(comp, closeBtn));
        if (UIHelper.isMacOS()) {
            this.setOpaque(false);
        }
        this.textLabel = new JLabel(title, icon, 4);
        this.add((Component)this.textLabel, "West");
        this.add((Component)new JLabel(" "), "Center");
        this.add((Component)closeBtn, "East");
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Component getComp() {
        return this.comp;
    }

    public void setTitle(String titleStr) {
        this.textLabel.setText(titleStr);
        this.validate();
    }

    class TabMouseAdapter
    extends MouseAdapter {
        protected Component tabComp;
        protected JLabel closeBtn;

        public TabMouseAdapter(Component tabComp, JLabel closeBtn) {
            this.tabComp = tabComp;
            this.closeBtn = closeBtn;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SubPaneIFace subPane = (SubPaneIFace)((Object)this.tabComp);
            SubPaneMgr.getInstance().showPane(subPane);
            SubPaneMgr.getInstance().closeCurrent();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.closeBtn.setIcon(IconManager.getIcon("CloseHover"));
            this.closeBtn.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.closeBtn.setIcon(IconManager.getIcon("Close"));
            this.closeBtn.repaint();
        }
    }
}

