/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EditDeleteAddPanel
extends JPanel {
    protected JButton addBtn;
    protected JButton delBtn;
    protected JButton editBtn;

    protected EditDeleteAddPanel() {
    }

    public EditDeleteAddPanel(ActionListener editAL, ActionListener delAL, ActionListener addAL) {
        this.createUI(editAL, delAL, addAL, "", "", "");
    }

    public EditDeleteAddPanel(ActionListener editAL, ActionListener delAL, ActionListener addAL, String editTTKey, String delTTKey, String addTTKey) {
        this.createUI(editAL, delAL, addAL, editTTKey, delTTKey, addTTKey);
    }

    protected PanelBuilder createUI(ActionListener editAL, ActionListener delAL, ActionListener addAL, String editTTKey, String delTTKey, String addTTKey) {
        if (editAL != null) {
            this.editBtn = UIHelper.createIconBtn("EditIcon", editTTKey, editAL);
        }
        if (delAL != null) {
            this.delBtn = UIHelper.createIconBtn("MinusSign", delTTKey, delAL);
        }
        if (addAL != null) {
            this.addBtn = UIHelper.createIconBtn("PlusSign", addTTKey, addAL);
        }
        return this.doBuildLayout();
    }

    protected PanelBuilder doBuildLayout() {
        int numBtns = (this.addBtn != null ? 1 : 0) + (this.delBtn != null ? 1 : 0) + (this.editBtn != null ? 1 : 0);
        CellConstraints cc = new CellConstraints();
        PanelBuilder btnPb = new PanelBuilder(this.createFormLayout(numBtns), (JPanel)this);
        int x = this.getStartingIndex();
        if (this.editBtn != null) {
            btnPb.add((Component)this.editBtn, cc.xy(x, 1));
            x += 2;
        }
        if (this.delBtn != null) {
            btnPb.add((Component)this.delBtn, cc.xy(x, 1));
            x += 2;
        }
        if (this.addBtn != null) {
            btnPb.add((Component)this.addBtn, cc.xy(x, 1));
            x += 2;
        }
        return btnPb;
    }

    protected FormLayout createFormLayout(int numBtns) {
        return new FormLayout("f:p:g," + UIHelper.createDuplicateJGoodiesDef("P", "2px", numBtns), "p");
    }

    protected int getStartingIndex() {
        return 2;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.editBtn != null) {
            this.editBtn.setEnabled(enabled);
        }
        if (this.delBtn != null) {
            this.delBtn.setEnabled(enabled);
        }
        if (this.addBtn != null) {
            this.addBtn.setEnabled(enabled);
        }
    }

    public JButton getAddBtn() {
        return this.addBtn;
    }

    public JButton getDelBtn() {
        return this.delBtn;
    }

    public JButton getEditBtn() {
        return this.editBtn;
    }
}

