/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.google.common.collect.ImmutableList;
import edu.ku.brc.ui.DropDownButton;
import edu.ku.brc.ui.DropDownMenuInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DropDownButtonStateless
extends DropDownButton {
    public final MenuGenerator menuGenerator;
    private List<MenuInfo> menuInfos;
    private String initialLabel;

    public DropDownButtonStateless(String label, ImageIcon icon, String tooltip, MenuGenerator menuGenerator) {
        this.menuGenerator = menuGenerator;
        this.initialLabel = label;
        this.fillinMenus();
        this.init(this.initialLabel, icon, tooltip, true);
    }

    public List<MenuInfo> getMenuInfos() {
        return this.menuInfos;
    }

    public void setSelected(MenuInfo mi) {
        this.mainBtn.setText(mi.getLabel());
        mi.selected();
    }

    public void reset() {
        this.mainBtn.setText(this.initialLabel);
    }

    private void fillinMenus() {
        this.menuInfos = ImmutableList.copyOf(this.menuGenerator.getItems());
        this.menus = new LinkedList();
        for (final MenuInfo mi : this.menuInfos) {
            JMenuItem menuItem = new JMenuItem(mi.getLabel(), mi.getImageIcon());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DropDownButtonStateless.this.mainBtn.setText(mi.getLabel());
                    mi.selected();
                }
            });
            this.menus.add(menuItem);
        }
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        this.fillinMenus();
        return super.getPopupMenu();
    }

    public static interface MenuGenerator {
        public List<MenuInfo> getItems();
    }

    public static class MenuInfo
    extends DropDownMenuInfo {
        public MenuInfo(String label, ImageIcon imageIcon, String tooltip) {
            super(label, imageIcon, tooltip);
        }

        public void selected() {
        }
    }
}

