/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.DropDownButton;
import edu.ku.brc.ui.DropDownMenuInfo;
import edu.ku.brc.ui.UIHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DropDownButtonStateful
extends DropDownButton {
    protected List<DropDownMenuInfo> menuInfoItems;
    protected int currInx = 0;
    protected int nxtInx = 0;
    protected Dimension preferredSize = null;
    protected boolean doAdvance = true;
    protected boolean doShowCurrent = true;
    protected List<JButton> btns = new Vector<JButton>();
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel;

    public DropDownButtonStateful(List<DropDownMenuInfo> items) {
        this(items, true);
    }

    public DropDownButtonStateful(List<DropDownMenuInfo> items, boolean doAdvance) {
        super(items.get(0).getLabel(), items.get(0).getImageIcon(), items.get(0).getTooltip(), 4, items.size() > 0);
        this.menuInfoItems = items;
        this.overrideButtonBorder = true;
        this.init(doAdvance);
    }

    public DropDownButtonStateful(List<String> labels, List<ImageIcon> imgIcons) {
        this(labels, imgIcons, null);
    }

    public DropDownButtonStateful(List<String> labels, List<ImageIcon> imgIcons, List<String> toolTips) {
        int length = 0;
        if (imgIcons != null) {
            length = imgIcons.size();
        } else if (labels != null) {
            length = labels.size();
        }
        this.init(labels != null && labels.size() > 0 ? labels.get(0) : null, imgIcons != null && imgIcons.size() > 0 ? imgIcons.get(0) : null, toolTips != null && toolTips.size() > 0 ? toolTips.get(0) : null, length > 0);
        this.mainBtn.setHorizontalTextPosition(0);
        this.mainBtn.setVerticalTextPosition(0);
        this.menuInfoItems = new Vector<DropDownMenuInfo>();
        int i = 0;
        while (i < length) {
            this.menuInfoItems.add(new DropDownMenuInfo(labels != null && i < labels.size() ? labels.get(i) : null, imgIcons != null && i < imgIcons.size() ? imgIcons.get(i) : null, toolTips != null && i < toolTips.size() ? toolTips.get(i) : null));
            ++i;
        }
        this.init(true);
    }

    public void setDoShowCurrent(boolean doShowCurrent) {
        this.doShowCurrent = doShowCurrent;
    }

    protected void init(boolean doAdvanceArg) {
        this.doAdvance = doAdvanceArg;
        ActionListener menuAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int prevInx = DropDownButtonStateful.this.currInx;
                DropDownButtonStateful.this.itemSelected(actionEvent.getSource());
                DropDownButtonStateful.this.cardLayout.show(DropDownButtonStateful.this.cardPanel, Integer.toString(DropDownButtonStateful.this.currInx));
                if (DropDownButtonStateful.this.currInx != prevInx) {
                    for (ActionListener al : DropDownButtonStateful.this.listeners) {
                        al.actionPerformed(actionEvent);
                    }
                }
            }
        };
        ActionListener btnAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DropDownButtonStateful.this.doAdvanceToNextState(ae);
            }
        };
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setOpaque(false);
        FocusListener focusListener = this.createFocusListener();
        MouseInputAdapter mouseInputAdapter = this.createMouseInputAdapter();
        CellConstraints cc = new CellConstraints();
        this.menus = new ArrayList();
        int i = 0;
        for (DropDownMenuInfo mi : this.menuInfoItems) {
            int nextIndex = i < this.menuInfoItems.size() - 1 ? i + 1 : 0;
            JMenuItem menuItem = new JMenuItem(mi.getLabel(), mi.getImageIcon());
            UIHelper.setControlSize(menuItem);
            menuItem.addActionListener(menuAL);
            this.menus.add(menuItem);
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p", "p"));
            JButton btn = DropDownButtonStateful.createLabelBtn(this.menuInfoItems.get(nextIndex).getLabel(), this.menuInfoItems.get(nextIndex).getImageIcon(), this.menuInfoItems.get(nextIndex).getTooltip(), this, focusListener, mouseInputAdapter, btnAL, this, false);
            this.btns.add(btn);
            btn.setOpaque(false);
            pb.getPanel().setOpaque(false);
            pb.add((Component)btn, cc.xy(2, 1));
            this.cardPanel.add((Component)pb.getPanel(), Integer.toString(i));
            ++i;
        }
        this.setLayout(null);
        this.removeAll();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,p", "f:p:g"), (JPanel)this);
        pb.add((Component)this.cardPanel, cc.xy(1, 1));
        pb.add((Component)this.arrowBtn, cc.xy(2, 1));
        this.popupAnchorComponent = this.cardPanel;
        this.arrowBtn.setVisible(this.getPopMenuSize() > 0);
        this.setCurrentIndex(0);
    }

    private void doAdvanceToNextState(ActionEvent ae) {
        if (this.doAdvance) {
            ++this.currInx;
            if (this.currInx >= this.menuInfoItems.size()) {
                this.currInx = 0;
            }
        }
        this.setCurrentIndex(this.currInx);
        this.cardLayout.show(this.cardPanel, Integer.toString(this.currInx));
        for (ActionListener al : this.listeners) {
            al.actionPerformed(ae);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public int getNextIndex() {
        return (this.currInx + 1) % this.menuInfoItems.size();
    }

    public void setCurrentIndex(int index) {
        this.currInx = index;
        this.nxtInx = this.doAdvance && !this.doShowCurrent ? this.getNextIndex() : index;
        this.cardLayout.show(this.cardPanel, Integer.toString(this.nxtInx));
    }

    public int getCurrentIndex() {
        return this.currInx;
    }

    protected void itemSelected(Object obj) {
        if (obj instanceof JMenuItem) {
            int i = 0;
            for (JComponent mi : this.menus) {
                if (mi == obj) {
                    this.setCurrentIndex(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void doAdvance(final ActionEvent ae) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DropDownButtonStateful.this.doAdvanceToNextState(ae);
            }
        });
    }

    @Override
    protected void finalize() throws Throwable {
        this.menuInfoItems.clear();
        super.finalize();
    }

    public boolean isDoAdvance() {
        return this.doAdvance;
    }

    public void setDoAdvance(boolean doAdvance) {
        this.doAdvance = doAdvance;
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        for (JButton btn : this.btns) {
            btn.setEnabled(value);
        }
        this.repaint();
    }
}

