/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MacBtnBorder;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DropDownButton
extends JPanel
implements ChangeListener,
PopupMenuListener,
ActionListener,
PropertyChangeListener {
    protected static BasicStroke lineStroke = new BasicStroke(2.0f, 1, 1);
    protected static Color focusColor = null;
    protected Color hoverColor = UIHelper.getHoverColor();
    protected EmptyBorder emptyBorder = null;
    protected Border focusBorder = null;
    protected boolean hasFocus = false;
    protected JButton mainBtn;
    protected JButton arrowBtn = null;
    protected boolean popupVisible = false;
    protected String statusBarHintText = null;
    protected boolean overrideButtonBorder = false;
    protected List<JComponent> menus = null;
    protected List<ActionListener> listeners = new ArrayList<ActionListener>();
    protected boolean isHovering = false;
    protected JComponent popupAnchorComponent = null;
    protected static ImageIcon dropDownArrow = IconManager.getIcon("DropDownArrow");

    public DropDownButton() {
        this.init(null, null, null, false);
    }

    public DropDownButton(boolean addArrow) {
        this.init(null, null, null, addArrow);
    }

    public DropDownButton(ImageIcon icon, boolean addArrow) {
        this.init(null, icon, null, addArrow);
    }

    @Override
    public void setFont(Font font) {
        if (this.mainBtn != null) {
            this.mainBtn.setFont(font);
        }
    }

    public DropDownButton(String label, ImageIcon icon, String toolTip, int horzTextPosition, boolean addArrow) {
        this(label, icon, toolTip, horzTextPosition, 0, addArrow);
    }

    public DropDownButton(String label, ImageIcon icon, String toolTip, int horzTextPosition, int vertTextPosition, boolean addArrow) {
        this.init(label, icon, toolTip, addArrow);
        this.mainBtn.setHorizontalTextPosition(horzTextPosition);
        this.mainBtn.setVerticalTextPosition(vertTextPosition);
    }

    public DropDownButton(String label, ImageIcon icon, int vertTextPosition, List<JComponent> menus) {
        this.menus = menus;
        this.init(label, icon, null, menus != null && menus.size() > 0);
        this.mainBtn.setVerticalTextPosition(vertTextPosition);
        if (vertTextPosition == 3 || vertTextPosition == 1) {
            this.mainBtn.setHorizontalTextPosition(0);
        }
    }

    protected void init(String label, ImageIcon icon, String toolTip, boolean addArrowBtn) {
        this.setOpaque(false);
        FocusListener focusListener = UIHelper.isMacOS() ? this.createFocusListener() : null;
        MouseInputAdapter mouseInputAdapter = this.createMouseInputAdapter();
        this.mainBtn = DropDownButton.createLabelBtn(label, icon, toolTip, this, focusListener, mouseInputAdapter, this, this, this.overrideButtonBorder);
        this.arrowBtn = this.createArrowBtn(mouseInputAdapter);
        this.mainBtn.setOpaque(false);
        this.popupAnchorComponent = this.mainBtn;
        PanelBuilder pb = new PanelBuilder(new FormLayout("p:g" + (addArrowBtn ? ",p" : ""), "f:p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.mainBtn, cc.xy(1, 1));
        if (addArrowBtn) {
            pb.add((Component)this.arrowBtn, cc.xy(2, 1));
        }
        if (UIHelper.isMacOS()) {
            this.focusBorder = new MacBtnBorder();
            this.emptyBorder = new EmptyBorder(this.focusBorder.getBorderInsets(this));
        } else {
            focusColor = UIManager.getLookAndFeel() instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getFocusColor() : UIManager.getColor("Button.focus");
            if (focusColor == null) {
                focusColor = Color.DARK_GRAY;
            }
        }
        if (!this.overrideButtonBorder) {
            this.setBorder(this.emptyBorder);
        }
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    public FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DropDownButton.this.hasFocus = true;
                DropDownButton.this.setBorder(DropDownButton.this.focusBorder);
                DropDownButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DropDownButton.this.hasFocus = false;
                DropDownButton.this.setBorder(DropDownButton.this.emptyBorder);
                DropDownButton.this.repaint();
            }
        };
    }

    public MouseInputAdapter createMouseInputAdapter() {
        return new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DropDownButton.this.isEnabled()) {
                    DropDownButton.this.isHovering = true;
                    if (DropDownButton.this.statusBarHintText != null) {
                        UIRegistry.displayStatusBarText(DropDownButton.this.statusBarHintText);
                    }
                    DropDownButton.this.arrowBtn.setEnabled(DropDownButton.this.getPopMenuSize() > 0 && DropDownButton.this.isEnabled());
                    DropDownButton.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DropDownButton.this.isHovering = false;
                if (DropDownButton.this.isEnabled()) {
                    UIRegistry.displayStatusBarText(null);
                    if (DropDownButton.this.popupVisible) {
                        DropDownButton.this.popupVisible = false;
                        DropDownButton.this.mainBtn.getModel().setRollover(false);
                        DropDownButton.this.arrowBtn.getModel().setSelected(false);
                    }
                }
                DropDownButton.this.repaint();
            }
        };
    }

    public static JButton createLabelBtn(String label, ImageIcon icon, String toolTip, ChangeListener changeListener, FocusListener focusListener, MouseInputAdapter mouseInputAdapter, ActionListener al, PropertyChangeListener pcl, boolean overRideButtonBorder) {
        JButton btn = UIHelper.createButton(label, icon);
        btn.setOpaque(false);
        btn.addFocusListener(focusListener);
        if (!overRideButtonBorder) {
            btn.setBorder(new EmptyBorder(3, 6, 3, 4));
        }
        btn.setIconTextGap(1);
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.getModel().addChangeListener(changeListener);
        btn.setHorizontalTextPosition(4);
        btn.setVerticalTextPosition(0);
        btn.addPropertyChangeListener("enabled", pcl);
        if (toolTip != null) {
            btn.setToolTipText(toolTip);
        }
        btn.addMouseListener(mouseInputAdapter);
        btn.addMouseMotionListener(mouseInputAdapter);
        btn.addActionListener(al);
        return btn;
    }

    public JButton createArrowBtn(MouseInputAdapter mouseInputAdapter) {
        JButton arwBtn = new JButton(dropDownArrow);
        arwBtn.setOpaque(false);
        arwBtn.setBorder(new EmptyBorder(4, 4, 4, 4));
        arwBtn.getModel().addChangeListener(this);
        arwBtn.addActionListener(this);
        arwBtn.setMargin(new Insets(3, 3, 3, 3));
        arwBtn.setFocusPainted(false);
        arwBtn.setFocusable(false);
        arwBtn.setVisible(this.getPopMenuSize() > 0);
        arwBtn.addMouseListener(mouseInputAdapter);
        arwBtn.addMouseMotionListener(mouseInputAdapter);
        return arwBtn;
    }

    public void setOverrideBorder(boolean val, Border border) {
        this.overrideButtonBorder = val;
        if (val) {
            this.setBorder(border);
        }
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public String getText() {
        return this.mainBtn.getText();
    }

    public void setIcon(ImageIcon icon) {
        this.mainBtn.setIcon(icon);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.mainBtn.getModel() || source == this.arrowBtn.getModel()) {
            this.arrowBtn.setEnabled(this.mainBtn.isEnabled());
            if (!this.arrowBtn.isVisible()) {
                this.arrowBtn.setVisible(this.getPopMenuSize() > 0);
                this.invalidate();
                this.doLayout();
                this.repaint();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.mainBtn.getModel()) {
            if (this.popupVisible && !this.mainBtn.getModel().isRollover()) {
                this.mainBtn.getModel().setRollover(true);
                return;
            }
            this.arrowBtn.getModel().setRollover(this.mainBtn.getModel().isRollover());
            this.arrowBtn.setSelected(this.mainBtn.getModel().isArmed() && this.mainBtn.getModel().isPressed());
        } else {
            if (this.popupVisible && !this.arrowBtn.getModel().isSelected()) {
                this.arrowBtn.getModel().setSelected(true);
                return;
            }
            this.mainBtn.getModel().setRollover(this.arrowBtn.getModel().isRollover());
        }
        this.arrowBtn.setVisible(this.getPopMenuSize() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.arrowBtn) {
            JPopupMenu popup = this.getPopupMenu();
            popup.addPopupMenuListener(this);
            popup.show(this.popupAnchorComponent, 0, this.popupAnchorComponent.getHeight());
        } else {
            for (ActionListener al : this.listeners) {
                al.actionPerformed(ae);
            }
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.popupVisible = true;
        this.mainBtn.getModel().setRollover(true);
        this.arrowBtn.getModel().setSelected(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.popupVisible = false;
        this.mainBtn.getModel().setRollover(false);
        this.arrowBtn.getModel().setSelected(false);
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.popupVisible = false;
    }

    protected JPopupMenu getPopupMenu() {
        if (this.menus != null) {
            JPopupMenu popupMenu = new JPopupMenu();
            for (JComponent comp : this.menus) {
                if (comp instanceof JMenuItem) {
                    popupMenu.add((JMenuItem)comp);
                    continue;
                }
                if (!(comp instanceof JSeparator)) continue;
                popupMenu.add(comp);
            }
            return popupMenu;
        }
        return null;
    }

    protected int getPopMenuSize() {
        return this.menus == null ? 0 : this.menus.size();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isHovering && !this.hasFocus && this.isEnabled()) {
            g.setColor(this.hoverColor);
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RoundRectangle2D.Double rr = new RoundRectangle2D.Double(insets.left + 1, insets.top + 1, size.width - insets.right - insets.left - 3, size.height - insets.bottom - insets.top - 3, 10.0, 10.0);
            g2d.setStroke(lineStroke);
            g2d.draw(rr);
        }
    }

    public List<JComponent> getMenus() {
        return this.menus;
    }

    public void setMenus(List<JComponent> menus) {
        this.menus = menus;
    }

    public String getStatusBarHintText() {
        return this.statusBarHintText;
    }

    public void setStatusBarHintText(String statusBarHintText) {
        this.statusBarHintText = statusBarHintText;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setBorder(this.emptyBorder);
        }
        this.mainBtn.setEnabled(enabled);
        this.arrowBtn.setEnabled(enabled);
        if (!enabled && this.isHovering) {
            this.isHovering = false;
            this.repaint();
        }
    }

    protected void finalize() throws Throwable {
        this.listeners.clear();
        this.menus.clear();
        UIHelper.removeMouseListeners(this);
        super.finalize();
    }
}

