/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import edu.ku.brc.ui.dnd.ShadowFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;

public class DraggableJLabel
extends JLabel
implements GhostActionable {
    public static final DataFlavor DATAOBJREP_FLAVOR = new DataFlavor(DraggableJLabel.class, "DraggableJLabel");
    protected static final int SHADOW_SIZE = 10;
    protected BufferedImage sizeBufImg = null;
    protected GhostMouseInputAdapter mouseInputAdapter = null;
    protected BufferedImage shadowBuffer = null;
    protected BufferedImage buffer = null;
    protected boolean generateImgBuf = true;
    protected Object data = null;
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    protected List<DataFlavor> dragFlavors = new ArrayList<DataFlavor>();

    public DraggableJLabel() {
        this.createMouseInputAdapter();
    }

    public DraggableJLabel(String text) {
        super(text);
        this.createMouseInputAdapter();
    }

    public DraggableJLabel(Icon image) {
        super(image);
        this.createMouseInputAdapter();
    }

    public DraggableJLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.createMouseInputAdapter();
    }

    public DraggableJLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.createMouseInputAdapter();
    }

    public DraggableJLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.createMouseInputAdapter();
    }

    @Override
    public void setText(String label) {
        String oldLabel = super.getText();
        super.setText(label);
        if (label == null || oldLabel == null || !oldLabel.equals(label)) {
            this.generateImgBuf = true;
        }
    }

    @Override
    public void doAction(GhostActionable src) {
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return UIHelper.getDataForClass(this.data, classObj);
    }

    @Override
    public void createMouseInputAdapter() {
        this.mouseInputAdapter = new GhostMouseInputAdapter(UIRegistry.getGlassPane(), "action", this);
        this.addMouseListener(this.mouseInputAdapter);
        this.addMouseMotionListener(this.mouseInputAdapter);
    }

    @Override
    public void setActive(boolean isActive) {
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return this.mouseInputAdapter;
    }

    public int getItemWidth() {
        return this.getPreferredSize().width + 10;
    }

    public int getItemHeight() {
        return this.getPreferredSize().height;
    }

    private void renderOffscreen() {
        BufferedImage bgBufImg = this.getBackgroundImageBuffer();
        this.buffer = new BufferedImage(bgBufImg.getWidth(), bgBufImg.getHeight(), 2);
        int shadowWidth = bgBufImg.getWidth() - this.getItemWidth();
        int shadowHeight = bgBufImg.getHeight() - this.getItemHeight();
        int left = (int)((double)shadowWidth * 0.5);
        int top = (int)((double)shadowHeight * 0.4);
        int width = this.getItemWidth() - 2;
        int height = this.getItemHeight() - 2;
        Graphics2D g2 = this.buffer.createGraphics();
        g2.setRenderingHints(UIHelper.createTextRenderingHints());
        g2.drawImage(bgBufImg, 0, 0, bgBufImg.getWidth(), bgBufImg.getHeight(), null);
        g2.fillRect(left, top, width, height);
        g2.setClip(left, top, width, height);
        g2.translate(left, top);
        super.paint(g2);
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.buffer == null || this.generateImgBuf) {
            this.renderOffscreen();
        }
        return this.buffer;
    }

    private BufferedImage getBackgroundImageBuffer() {
        if (this.shadowBuffer == null || this.generateImgBuf) {
            ShadowFactory factory = new ShadowFactory(10, 0.17f, Color.BLACK);
            BufferedImage image = new BufferedImage(this.getItemWidth(), this.getItemHeight(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            this.shadowBuffer = factory.createShadow(image);
        }
        return this.shadowBuffer;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return this.dragFlavors;
    }
}

