/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.DragDropCallback;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import javax.swing.ListModel;
import org.apache.log4j.Logger;

public class DragDropJList
extends JList
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static Logger log = Logger.getLogger(DragDropJList.class);
    protected static DataFlavor localObjectFlavor;
    protected static DataFlavor[] supportedFlavors;
    protected DragSource dragSource;
    protected DropTarget dropTarget;
    protected int draggedIndex = -1;
    protected DragDropCallback dragDropCallback;
    protected Cursor dragCursor = null;
    protected Cursor defaultCursor = new Cursor(0);
    protected Cursor dropCursor = new Cursor(12);

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    public DragDropJList(ListModel model, DragDropCallback dragDropCallback, boolean isDraggable) {
        super(model);
        this.dragDropCallback = dragDropCallback;
        this.setFixedCellHeight(this.getFont().getSize() * 2);
        if (isDraggable) {
            this.dragSource = new DragSource();
            int actions = 3;
            this.dragSource.createDefaultDragGestureRecognizer(this, actions, this);
            this.dropTarget = new DropTarget(this, this);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        int index = this.locationToIndex(clickPoint);
        if (index == -1) {
            return;
        }
        Object target = this.getModel().getElementAt(index);
        RJLTransferable trans = new RJLTransferable(target);
        this.draggedIndex = index;
        this.dragSource.startDrag(dge, null, trans, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        log.debug((Object)"processing dragDropEnd notification");
        if (this.dragDropCallback != null) {
            boolean dropSuccess = dsde.getDropSuccess();
            log.debug((Object)("Notifying callback that a DnD operation ended with success status " + dropSuccess));
            this.dragDropCallback.dragDropEnded(dropSuccess);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.shouldAccept(dtde)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    protected void setDragCursor(boolean okToDrop, int action) {
        if (action == 2) {
            if (okToDrop) {
                if (this.dragCursor == null || this.dragCursor != this.dropCursor) {
                    this.dragCursor = this.dropCursor;
                    this.setCursor(this.dragCursor);
                }
            } else if (this.dragCursor == null || this.dragCursor != this.defaultCursor) {
                this.dragCursor = this.defaultCursor;
                this.setCursor(this.dragCursor);
            }
        } else if (this.dragCursor != null) {
            this.dragCursor = null;
            this.setCursor(null);
        }
    }

    protected boolean shouldAccept(DropTargetDragEvent dtde) {
        Point loc = dtde.getLocation();
        int index = this.locationToIndex(loc);
        Object droppedOn = this.getModel().getElementAt(index);
        Object dragged = null;
        try {
            dragged = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setDragCursor(false, dtde.getDropAction());
            return false;
        }
        if (dragged == null) {
            this.setDragCursor(false, dtde.getDropAction());
            return false;
        }
        if (droppedOn == dragged) {
            this.setDragCursor(false, dtde.getDropAction());
        }
        if (this.dragDropCallback.dropAcceptable(dragged, droppedOn, dtde.getDropAction())) {
            this.setDragCursor(true, dtde.getDropAction());
            return true;
        }
        this.setDragCursor(false, dtde.getDropAction());
        return false;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        log.debug((Object)"processing drop");
        Point loc = dtde.getLocation();
        int index = this.locationToIndex(loc);
        Object droppedOn = this.getModel().getElementAt(index);
        Object dragged = null;
        try {
            dragged = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean dropped = false;
        if (this.dragDropCallback.dropAcceptable(dragged, droppedOn, dtde.getDropAction())) {
            log.debug((Object)"notifying callback that an acceptable drop occurred");
            dropped = this.dragDropCallback.dropOccurred(dragged, droppedOn, dtde.getDropAction());
        } else {
            log.debug((Object)"notifying callback that an unacceptable drop occurred, ending the DnD operation");
            this.dragDropCallback.dragDropEnded(false);
            dropped = false;
        }
        this.setDragCursor(false, dtde.getDropAction());
        dtde.dropComplete(dropped);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        log.debug((Object)"processing dropActionChanged notification");
        if (this.shouldAccept(dtde)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    class RJLTransferable
    implements Transferable {
        Object object;

        public RJLTransferable(Object o) {
            this.object = o;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.equals(localObjectFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }
}

