/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.util.Calendar;
import java.util.Date;

public class DateParser {
    protected static char[] standardSeps = new char[]{'/', '-', '.'};
    protected static char defaultSep = (char)47;
    protected int[] daysInMonth;
    protected String monthFormat;
    protected String dayFormat;
    protected String defaultDateFormatStr;
    protected boolean isMonthFirst;
    protected boolean isYearFirst;
    protected DateErrorType dateError;

    public DateParser(String defaultDateFormat) {
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        this.daysInMonth = nArray;
        this.monthFormat = "MM";
        this.dayFormat = "dd";
        this.defaultDateFormatStr = null;
        this.isMonthFirst = false;
        this.isYearFirst = false;
        this.dateError = DateErrorType.None;
        this.setDefaultDateFormatStr(defaultDateFormat);
    }

    public void setDefaultDateFormatStr(String defaultDateFormatStr) {
        this.defaultDateFormatStr = defaultDateFormatStr;
        this.initialize();
    }

    private void initialize() {
        this.isYearFirst = DateParser.isYearFirstInDateStr(this.defaultDateFormatStr);
        int inx = this.isYearFirst ? 5 : 0;
        this.isMonthFirst = this.defaultDateFormatStr.charAt(inx) == 'M';
        inx = 1;
        while (Character.isLetter(this.defaultDateFormatStr.charAt(inx))) {
            ++inx;
        }
        defaultSep = this.defaultDateFormatStr.charAt(inx);
    }

    protected static boolean isYearFirstInDateStr(String dateStr) {
        int x = 0;
        char[] cArray = dateStr.substring(0, 4).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!Character.isLetter(ch) && !Character.isDigit(ch)) {
                return x > 3;
            }
            ++x;
            ++n2;
        }
        return true;
    }

    public static DateFormatType getDateFormatType(String dateStr) {
        DateFormatType type = DateFormatType.Unknown;
        int len = dateStr.length();
        if (len > 7 && len < 11) {
            boolean isYearFirst = DateParser.isYearFirstInDateStr(dateStr);
            char sep = DateParser.getSep(dateStr);
            if (len == 10) {
                if (dateStr.charAt(4) == sep && dateStr.charAt(7) == sep || dateStr.charAt(2) == sep && dateStr.charAt(5) == sep) {
                    type = isYearFirst ? DateFormatType.YYYY_AA_BB : DateFormatType.AA_BB_YYYY;
                }
            } else if (len == 9) {
                int inx = isYearFirst ? 6 : 1;
                char sepChar = dateStr.charAt(inx);
                if (sepChar == sep) {
                    if (dateStr.charAt(4) == sep && dateStr.charAt(6) == sep || dateStr.charAt(1) == sep && dateStr.charAt(4) == sep) {
                        type = isYearFirst ? DateFormatType.YYYY_A_BB : DateFormatType.A_BB_YYYY;
                    }
                } else if (dateStr.charAt(4) == sep && dateStr.charAt(7) == sep || dateStr.charAt(2) == sep && dateStr.charAt(4) == sep) {
                    type = isYearFirst ? DateFormatType.YYYY_AA_B : DateFormatType.AA_B_YYYY;
                }
            } else if (len == 8 && (dateStr.charAt(4) == sep && dateStr.charAt(6) == sep || dateStr.charAt(1) == sep && dateStr.charAt(3) == sep)) {
                return isYearFirst ? DateFormatType.YYYY_A_B : DateFormatType.A_B_YYYY;
            }
        }
        return type;
    }

    protected static char getSep(String dateStr) {
        char[] cArray = dateStr.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!Character.isLetter(ch) && !Character.isDigit(ch)) {
                char[] cArray2 = standardSeps;
                int n3 = standardSeps.length;
                int n4 = 0;
                while (n4 < n3) {
                    char st = cArray2[n4];
                    if (ch == st) {
                        return ch;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return defaultSep;
    }

    protected boolean isLeapYear(int year) {
        if (year % 4 == 0) {
            if (year % 100 == 0 && year % 400 == 0) {
                return true;
            }
            return true;
        }
        return false;
    }

    protected Date parseForDate(DateFormatType type, String dateStr, boolean isZeroMnOK, boolean isZeroDyOK) {
        int dy;
        int mn;
        int yr;
        block21: {
            block20: {
                block19: {
                    String yy = "";
                    String aa = "";
                    String bb = "";
                    switch (type) {
                        case YYYY_AA_BB: {
                            yy = dateStr.substring(0, 4);
                            aa = dateStr.substring(5, 7);
                            bb = dateStr.substring(8, 10);
                            break;
                        }
                        case YYYY_A_BB: {
                            yy = dateStr.substring(0, 4);
                            aa = dateStr.substring(5, 6);
                            bb = dateStr.substring(7, 9);
                            break;
                        }
                        case YYYY_AA_B: {
                            yy = dateStr.substring(0, 4);
                            aa = dateStr.substring(5, 7);
                            bb = dateStr.substring(8, 9);
                            break;
                        }
                        case YYYY_A_B: {
                            yy = dateStr.substring(0, 4);
                            aa = dateStr.substring(5, 6);
                            bb = dateStr.substring(7, 8);
                            break;
                        }
                        case AA_BB_YYYY: {
                            aa = dateStr.substring(0, 2);
                            bb = dateStr.substring(3, 5);
                            yy = dateStr.substring(6, 10);
                            break;
                        }
                        case A_BB_YYYY: {
                            aa = dateStr.substring(0, 1);
                            bb = dateStr.substring(2, 4);
                            yy = dateStr.substring(5, 9);
                            break;
                        }
                        case AA_B_YYYY: {
                            aa = dateStr.substring(0, 2);
                            bb = dateStr.substring(3, 4);
                            yy = dateStr.substring(5, 9);
                            break;
                        }
                        case A_B_YYYY: {
                            aa = dateStr.substring(0, 1);
                            bb = dateStr.substring(2, 3);
                            yy = dateStr.substring(4, 8);
                            break;
                        }
                        case Unknown: {
                            this.dateError = DateErrorType.UnknownFormat;
                            return null;
                        }
                    }
                    try {
                        yr = Integer.parseInt(yy);
                        mn = this.isMonthFirst ? Integer.parseInt(aa) : Integer.parseInt(bb);
                        int n = dy = this.isMonthFirst ? Integer.parseInt(bb) : Integer.parseInt(aa);
                        if (yr >= 0 && yr <= 2999) break block19;
                        this.dateError = DateErrorType.BadYear;
                        return null;
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(DateParser.class, ex);
                        this.dateError = DateErrorType.UnknownError;
                        return null;
                    }
                }
                if (mn == 0 && isZeroMnOK) {
                    mn = 1;
                    break block20;
                }
                if (mn >= 1 && mn <= 12) break block20;
                this.dateError = DateErrorType.BadMonth;
                return null;
            }
            if (dy == 0 && isZeroDyOK) {
                dy = 1;
            }
            int dysInMn = this.daysInMonth[mn];
            if (mn == 2 && this.isLeapYear(yr)) {
                ++dysInMn;
            }
            if (dy >= 1 && dy <= dysInMn) break block21;
            this.dateError = DateErrorType.BadDay;
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(yr, mn - 1, dy);
        return cal.getTime();
    }

    public Date parseDate(String dateStr) {
        return this.parseDate(dateStr, false, false);
    }

    public Date parseDate(String dateStr, boolean isZeroMnOK, boolean isZeroDyOK) {
        this.dateError = DateErrorType.None;
        DateFormatType type = DateParser.getDateFormatType(dateStr);
        if (type != DateFormatType.Unknown) {
            return this.parseForDate(type, dateStr, isZeroMnOK, isZeroDyOK);
        }
        this.dateError = DateErrorType.UnknownFormat;
        return null;
    }

    public DateErrorType getDateError() {
        return this.dateError;
    }

    public static enum DateErrorType {
        None,
        BadYear,
        BadMonth,
        BadDay,
        UnknownFormat,
        UnknownError;

    }

    public static enum DateFormatType {
        Unknown,
        YYYY_AA_BB,
        YYYY_A_BB,
        YYYY_AA_B,
        YYYY_A_B,
        AA_BB_YYYY,
        A_BB_YYYY,
        AA_B_YYYY,
        A_B_YYYY;

    }
}

