/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class CustomFrame
extends JFrame {
    public static final int OK_BTN = 1;
    public static final int CANCEL_BTN = 2;
    public static final int HELP_BTN = 4;
    public static final int APPLY_BTN = 8;
    public static final int OKCANCEL = 3;
    public static final int OKHELP = 5;
    public static final int OKCANCELHELP = 7;
    public static final int OKCANCELAPPLY = 11;
    public static final int OKCANCELAPPLYHELP = 15;
    protected static ImageIcon appIcon = null;
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    protected JButton helpBtn = null;
    protected JButton applyBtn = null;
    protected String okLabel = null;
    protected String cancelLabel = null;
    protected String helpLabel = null;
    protected String applyLabel = null;
    protected ImageIcon icon = null;
    protected boolean isCancelled = true;
    protected int btnPressed = 2;
    protected JPanel mainPanel;
    protected int whichBtns = 1;
    protected String helpContext = null;
    protected Component contentPanel = null;

    public CustomFrame(String title, Component contentPanel) throws HeadlessException {
        this(title, 3, contentPanel);
    }

    public CustomFrame(String title, int whichBtns, Component contentPanel) throws HeadlessException {
        super(title);
        this.whichBtns = whichBtns;
        this.contentPanel = contentPanel;
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public void setWindowModified(boolean isModified) {
        UIHelper.setWindowModified(this, isModified);
    }

    public void createUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        if (this.contentPanel != null) {
            this.mainPanel.add(this.contentPanel, "Center");
        }
        this.okBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.okLabel) ? this.okLabel : UIRegistry.getResourceString("OK"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CustomFrame.this.okButtonPressed();
            }
        });
        this.getRootPane().setDefaultButton(this.okBtn);
        if ((this.whichBtns & 2) == 2) {
            this.cancelBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.cancelLabel) ? this.cancelLabel : UIRegistry.getResourceString("CANCEL"));
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CustomFrame.this.cancelButtonPressed();
                }
            });
        }
        if ((this.whichBtns & 4) == 4) {
            this.helpBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.cancelLabel) ? this.cancelLabel : UIRegistry.getResourceString("HELP"));
            if (StringUtils.isNotEmpty((String)this.helpContext)) {
                HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
            } else {
                this.helpBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CustomFrame.this.helpButtonPressed();
                    }
                });
            }
        }
        if ((this.whichBtns & 8) == 8) {
            this.applyBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.applyLabel) ? this.applyLabel : UIRegistry.getResourceString("Apply"));
            this.applyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CustomFrame.this.applyButtonPressed();
                }
            });
        }
        JPanel bb = this.whichBtns == 1 ? ButtonBarFactory.buildOKBar((JButton)this.okBtn) : (this.whichBtns == 3 ? ButtonBarFactory.buildOKCancelBar((JButton)this.okBtn, (JButton)this.cancelBtn) : (this.whichBtns == 11 ? ButtonBarFactory.buildOKCancelApplyBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.applyBtn) : (this.whichBtns == 5 ? ButtonBarFactory.buildOKHelpBar((JButton)this.okBtn, (JButton)this.helpBtn) : (this.whichBtns == 7 ? ButtonBarFactory.buildOKCancelHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.helpBtn) : (this.whichBtns == 15 ? ButtonBarFactory.buildOKCancelApplyHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.applyBtn, (JButton)this.helpBtn) : ButtonBarFactory.buildOKBar((JButton)this.okBtn))))));
        this.mainPanel.add((Component)bb, "South");
        super.setContentPane(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void setContentPane(Container contentPanelArg) {
        if (this.contentPanel != null) {
            this.mainPanel.remove(this.contentPanel);
        }
        this.contentPanel = contentPanelArg;
        this.mainPanel.add(this.contentPanel, "Center");
    }

    protected void cancelButtonPressed() {
        this.isCancelled = true;
        this.btnPressed = 2;
        this.setVisible(false);
    }

    protected void okButtonPressed() {
        this.isCancelled = false;
        this.btnPressed = 1;
        this.setVisible(false);
    }

    protected void helpButtonPressed() {
        this.isCancelled = false;
        this.btnPressed = 4;
    }

    protected void applyButtonPressed() {
        this.isCancelled = false;
        this.btnPressed = 4;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setOkLabel(String text) {
        this.okLabel = text;
    }

    public void setCancelLabel(String text) {
        this.cancelLabel = text;
    }

    public int getBtnPressed() {
        return this.btnPressed;
    }

    public void setApplyLabel(String applyLabel) {
        this.applyLabel = applyLabel;
    }

    public void setHelpContext(String helpContext) {
        this.helpContext = helpContext;
    }

    public void setHelpLabel(String helpLabel) {
        this.helpLabel = helpLabel;
    }

    public JButton getApplyBtn() {
        return this.applyBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getHelpBtn() {
        return this.helpBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            UIRegistry.pushWindow(this);
        } else {
            UIRegistry.popWindow(this);
        }
        if (this.okBtn == null && visible) {
            this.createUI();
            UIHelper.centerWindow(this);
        }
        super.setVisible(visible);
    }

    public static ImageIcon getAppIcon() {
        return appIcon;
    }

    public static void setAppIcon(ImageIcon appIcon) {
        CustomFrame.appIcon = appIcon;
    }
}

