/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.GradiantLabel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class CustomDialog
extends JDialog {
    public static final int NONE_BTN = 0;
    public static final int OK_BTN = 1;
    public static final int CANCEL_BTN = 2;
    public static final int HELP_BTN = 4;
    public static final int APPLY_BTN = 8;
    public static final int OKCANCEL = 3;
    public static final int OKHELP = 5;
    public static final int OKCANCELHELP = 7;
    public static final int OKCANCELAPPLY = 11;
    public static final int OKCANCELAPPLYHELP = 15;
    public static final int CANCELHELP = 6;
    protected static ImageIcon appIcon = null;
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    protected JButton helpBtn = null;
    protected JButton applyBtn = null;
    protected String okLabel = null;
    protected String cancelLabel = null;
    protected String helpLabel = null;
    protected String applyLabel = null;
    protected boolean isCancelled = true;
    protected boolean closeOnApplyClk = false;
    protected boolean closeOnHelpClk = false;
    protected int btnPressed = 0;
    protected boolean isCreated = false;
    protected JPanel mainPanel;
    protected int whichBtns = 1;
    protected int defaultBtn = 1;
    protected String helpContext = null;
    protected Component contentPanel = null;
    protected JComponent extraBtn = null;
    protected GradiantLabel titleBarLabel = null;
    protected Color borderColor = null;

    public CustomDialog(Frame frame, String title, boolean isModal, Component contentPanel) throws HeadlessException {
        this(frame, title, isModal, 3, contentPanel);
    }

    public CustomDialog(Frame frame, String title, boolean isModal, int whichBtns, Component contentPanel) throws HeadlessException {
        super(frame, title, isModal);
        this.whichBtns = whichBtns;
        this.contentPanel = contentPanel;
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public CustomDialog(Frame frame, String title, boolean isModal, int whichBtns, Component contentPanel, int defaultBtn) throws HeadlessException {
        super(frame, title, isModal);
        this.whichBtns = whichBtns;
        this.contentPanel = contentPanel;
        this.defaultBtn = defaultBtn;
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public CustomDialog(Dialog dialog, String title, boolean isModal, int whichBtns, Component contentPanel) throws HeadlessException {
        super(dialog, title, isModal);
        this.whichBtns = whichBtns;
        this.contentPanel = contentPanel;
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public void setWindowModified(boolean isModified) {
        UIHelper.setWindowModified(this, isModified);
    }

    protected JButton findDefaultBtn() {
        if (this.defaultBtn == 2) {
            return this.cancelBtn;
        }
        if (this.defaultBtn == 4) {
            return this.helpBtn;
        }
        if (this.defaultBtn == 8) {
            return this.applyBtn;
        }
        return this.okBtn;
    }

    protected JPanel createMainPanel() {
        return new JPanel(new BorderLayout());
    }

    public void setWhichBtns(int whichBtns) {
        this.whichBtns = whichBtns;
    }

    protected void createButtons() {
        if ((this.whichBtns & 1) == 1) {
            this.okBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.okLabel) ? this.okLabel : UIRegistry.getResourceString("OK"));
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CustomDialog.this.okButtonPressed();
                }
            });
        }
        if ((this.whichBtns & 2) == 2) {
            this.cancelBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.cancelLabel) ? this.cancelLabel : UIRegistry.getResourceString("CANCEL"));
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CustomDialog.this.cancelButtonPressed();
                }
            });
        }
        if ((this.whichBtns & 4) == 4) {
            this.helpBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.helpLabel) ? this.helpLabel : UIRegistry.getResourceString("HELP"));
            if (StringUtils.isNotEmpty((String)this.helpContext)) {
                HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
            } else {
                this.helpBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CustomDialog.this.helpButtonPressed();
                    }
                });
            }
        }
        if ((this.whichBtns & 8) == 8) {
            this.applyBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.applyLabel) ? this.applyLabel : UIRegistry.getResourceString("Apply"));
            this.applyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CustomDialog.this.applyButtonPressed();
                }
            });
        }
    }

    protected JPanel buildButtonBar() {
        JPanel bb = null;
        if (this.whichBtns == 1) {
            bb = ButtonBarFactory.buildOKBar((JButton)this.okBtn);
        } else if (this.whichBtns == 2) {
            bb = ButtonBarFactory.buildOKBar((JButton)this.cancelBtn);
        } else if (this.whichBtns == 3) {
            bb = ButtonBarFactory.buildOKCancelBar((JButton)this.okBtn, (JButton)this.cancelBtn);
        } else if (this.whichBtns == 11) {
            bb = ButtonBarFactory.buildOKCancelApplyBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.applyBtn);
        } else if (this.whichBtns == 5) {
            bb = ButtonBarFactory.buildOKHelpBar((JButton)this.okBtn, (JButton)this.helpBtn);
        } else if (this.whichBtns == 7) {
            bb = ButtonBarFactory.buildOKCancelHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.helpBtn);
        } else if (this.whichBtns == 15) {
            bb = ButtonBarFactory.buildOKCancelApplyHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.applyBtn, (JButton)this.helpBtn);
        } else if (this.whichBtns == 6) {
            bb = ButtonBarFactory.buildOKHelpBar((JButton)this.cancelBtn, (JButton)this.helpBtn);
        }
        return bb;
    }

    public void createUI() {
        this.isCreated = true;
        this.setDefaultCloseOperation(2);
        this.mainPanel = this.createMainPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 5, 2));
        if (this.titleBarLabel != null) {
            this.mainPanel.add((Component)this.titleBarLabel, "North");
            this.mainPanel.setBorder(BorderFactory.createLineBorder(this.borderColor));
        }
        if (this.contentPanel != null) {
            this.mainPanel.add(this.contentPanel, "Center");
        }
        this.createButtons();
        this.getRootPane().setDefaultButton(this.findDefaultBtn());
        JPanel bb = this.buildButtonBar();
        if (this.extraBtn != null) {
            PanelBuilder builder = new PanelBuilder(new FormLayout("p,f:p:g", "p"));
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.extraBtn, cc.xy(1, 1));
            builder.add((Component)bb, cc.xy(2, 1));
            builder.getPanel().setOpaque(false);
            bb = builder.getPanel();
        }
        if (bb != null) {
            bb.setOpaque(false);
            JPanel bbComp = bb;
            if (UIHelper.getOSType() == UIHelper.OSTYPE.MacOSX) {
                PanelBuilder builder = new PanelBuilder(new FormLayout("p:g,15px", "p"));
                CellConstraints cc = new CellConstraints();
                builder.add((Component)bb, cc.xy(1, 1));
                builder.getPanel().setOpaque(false);
                bbComp = builder.getPanel();
            }
            this.mainPanel.add((Component)bbComp, "South");
        }
        this.setContentPane(this.mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setCustomTitleBar(String title) {
        this.setUndecorated(true);
        this.titleBarLabel = new GradiantLabel(title, 0);
        this.borderColor = SystemColor.windowBorder;
        Color textColor = SystemColor.activeCaptionText;
        if (UIHelper.isLinux()) {
            this.borderColor = SystemColor.activeCaptionBorder;
            textColor = SystemColor.activeCaptionText;
            if (this.borderColor.getRed() == this.borderColor.getGreen() && this.borderColor.getGreen() == this.borderColor.getBlue()) {
                this.borderColor = new Color(132, 170, 216);
                textColor = Color.WHITE;
            }
        } else if (UIHelper.isWindows()) {
            this.borderColor = (Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.activeCaptionColor");
            textColor = (Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.captionTextColor");
        }
        this.titleBarLabel.setTextColor(textColor);
        this.titleBarLabel.setBGBaseColor(this.borderColor);
        this.titleBarLabel.setGradiants(UIHelper.makeLighter(this.borderColor, 0.2), UIHelper.makeDarker(this.borderColor, 0.2));
    }

    public JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.createUI();
        }
        return this.mainPanel;
    }

    public Component getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(Component contentPanel) {
        this.contentPanel = contentPanel;
    }

    protected void cancelButtonPressed() {
        this.isCancelled = true;
        this.btnPressed = 2;
        this.setVisible(false);
    }

    protected void okButtonPressed() {
        this.isCancelled = false;
        this.btnPressed = 1;
        this.setVisible(false);
    }

    protected void helpButtonPressed() {
        if (this.closeOnHelpClk) {
            this.isCancelled = false;
        }
        this.btnPressed = 4;
        HelpMgr.getHelpForContext();
        if (this.closeOnHelpClk) {
            this.setVisible(false);
        }
    }

    protected void applyButtonPressed() {
        this.isCancelled = false;
        this.btnPressed = 8;
        if (this.closeOnApplyClk) {
            this.setVisible(false);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setOkLabel(String text) {
        this.okLabel = text;
        if (this.okBtn != null) {
            this.okBtn.setText(this.okLabel);
        }
    }

    public void setCancelLabel(String text) {
        this.cancelLabel = text;
        if (this.cancelBtn != null) {
            this.cancelBtn.setText(this.cancelLabel);
        }
    }

    public int getBtnPressed() {
        return this.btnPressed;
    }

    public void setApplyLabel(String applyLabel) {
        this.applyLabel = applyLabel;
        if (this.applyBtn != null) {
            this.applyBtn.setText(applyLabel);
        }
    }

    public void setCloseOnApplyClk(boolean closeOnApplyClk) {
        this.closeOnApplyClk = closeOnApplyClk;
    }

    public void setHelpContext(String helpContext) {
        this.helpContext = helpContext;
    }

    public void setHelpLabel(String helpLabel) {
        this.helpLabel = helpLabel;
        if (this.helpBtn != null) {
            this.helpBtn.setText(helpLabel);
        }
    }

    public void setCloseOnHelpClk(boolean closeOnHelpClk) {
        this.closeOnHelpClk = closeOnHelpClk;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            UIRegistry.pushWindow(this);
            if (!this.isCreated && visible) {
                this.createUI();
            }
            UIHelper.centerWindow(this);
        } else {
            UIRegistry.popWindow(this);
        }
        super.setVisible(visible);
    }

    public JButton getApplyBtn() {
        return this.applyBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getHelpBtn() {
        return this.helpBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public void cleanUp() {
    }

    public static ImageIcon getAppIcon() {
        return appIcon;
    }

    public static void setAppIcon(ImageIcon appIcon) {
        CustomDialog.appIcon = appIcon;
    }

    public JComponent getExtraBtn() {
        return this.extraBtn;
    }

    public void setExtraBtn(JComponent extraBtn) {
        this.extraBtn = extraBtn;
    }
}

