/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class CurvedBorder
extends AbstractBorder {
    protected Color borderInnerColor = Color.LIGHT_GRAY;
    protected Color borderOuterColor = Color.DARK_GRAY;
    protected int borderWidth = 2;
    protected int arcSize = 10;
    protected Dimension size = new Dimension(1, 1);

    public CurvedBorder() {
    }

    public CurvedBorder(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public CurvedBorder(Color borderColor) {
        this.borderOuterColor = borderColor;
    }

    public CurvedBorder(int borderWidth, Color borderColor) {
        this.borderWidth = borderWidth;
        this.borderOuterColor = borderColor;
    }

    public CurvedBorder(int borderWidth, Color borderInnerColor, Color borderOuterColor) {
        this.borderWidth = borderWidth;
        this.borderOuterColor = borderOuterColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int xc, int yc, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stdLineStroke = new BasicStroke(1.0f, 1, 1);
        g2d.setStroke(stdLineStroke);
        g2d.setColor(new Color(64, 64, 64));
        this.borderInnerColor = Color.WHITE;
        this.borderOuterColor = UIManager.getColor("Button.shadow");
        this.borderInnerColor = UIManager.getColor("Button.shadow");
        this.borderOuterColor = Color.WHITE;
        this.arcSize = 16;
        int x = xc;
        int y = yc;
        int w = width;
        int h = height;
        int i = 0;
        while (i < 1) {
            g2d.setColor(this.borderOuterColor);
            this.paintUpperLeftBorder(g2d, x - i, y - i, w - i, h - i, this.arcSize);
            g2d.setColor(this.borderInnerColor);
            this.paintLowerRightBorder(g2d, x - i, y - i, w - i, h - i, this.arcSize);
            ++i;
        }
        g2d.setColor(Color.BLACK);
        stdLineStroke = new BasicStroke(1.0f, 1, 1);
        g2d.setStroke(stdLineStroke);
    }

    protected void paintUpperLeftBorder(Graphics2D g2d, int x, int y, int w, int h, int arcSz) {
        int halfArc = arcSz / 2;
        int lenH = h - arcSz / 2;
        g2d.drawLine(x + halfArc + 1, 0, x + w - halfArc - 1, 0);
        g2d.drawLine(x, y + 1 + arcSz / 2, x, y + lenH);
        g2d.drawArc(x, y, arcSz, arcSz, 90, 90);
        g2d.drawArc(x + w - arcSz - 1, y, arcSz, arcSz, 45, 45);
        g2d.drawArc(x, y + h - arcSz - 1, arcSz, arcSz, 180, 45);
    }

    protected void paintLowerRightBorder(Graphics2D g2d, int x, int y, int w, int h, int arcSz) {
        int halfArc = arcSz / 2;
        int lenH = h - halfArc;
        g2d.drawLine(x + halfArc + 1, y + h - 1, x + w - halfArc - 1, y + h - 1);
        g2d.drawLine(x + w - 1, y - 1 + arcSz / 2, x + w - 1, y + lenH);
        g2d.drawArc(x, y + h - arcSz - 1, arcSz, arcSz, 225, 45);
        g2d.drawArc(x + w - arcSz - 1, y, arcSz, arcSz, 0, 45);
        g2d.drawArc(x + w - arcSz - 1, y + h - arcSz - 1, arcSz, arcSz, 270, 90);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        i.bottom = i.top = this.borderWidth;
        i.right = i.top;
        i.left = i.top;
        return i;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getBorderInnerColor() {
        return this.borderInnerColor;
    }

    public Color getBorderOuterColor() {
        return this.borderOuterColor;
    }

    public void setBorderInnerColor(Color borderInnerColor) {
        this.borderInnerColor = borderInnerColor;
    }

    public void setBorderOuterColor(Color borderOuterColor) {
        this.borderOuterColor = borderOuterColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }
}

