/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Random;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class CsvTableModel
implements TableModel {
    protected Vector<TableModelListener> listeners = new Vector();
    protected File csvFile;
    protected Vector<String[]> rowData;
    protected Vector<String> methods;
    protected String[] header;
    protected Random rand = new Random();
    protected int randStart = this.rand.nextInt(2756);

    public CsvTableModel(File csvFile) throws Exception {
        this.rowData = new Vector();
        this.methods = new Vector();
        this.csvFile = csvFile;
        FileReader fr = new FileReader(csvFile);
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        this.header = StringUtils.split((String)line);
        line = br.readLine();
        while (line != null) {
            String[] row = StringUtils.split((String)line);
            if (row.length > 0) {
                this.rowData.add(row);
            }
            line = br.readLine();
        }
        int i = 0;
        while (i < this.rowData.size()) {
            int j = this.rand.nextInt(15);
            if (j == 0) {
                this.methods.add("dynamite");
            } else if (j == 1) {
                this.methods.add("boat electro-shocker");
            } else {
                this.methods.add("seine");
            }
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        return this.header[column];
    }

    @Override
    public int getRowCount() {
        return this.rowData.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            int x = row + this.randStart;
            return "ACB-2006-" + x;
        }
        if (column == 3) {
            return this.methods.elementAt(row);
        }
        if (column == 1 || column == 2) {
            String[] r = this.rowData.get(row);
            return r[column - 1];
        }
        String[] r = this.rowData.get(row);
        return r[column - 2];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

