/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandListener;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CommandDispatcher {
    protected static final Logger log = Logger.getLogger(CommandDispatcher.class);
    private static final CommandDispatcher instance = new CommandDispatcher();
    protected Hashtable<String, Vector<CommandListener>> listeners = new Hashtable();

    protected CommandDispatcher() {
    }

    public static CommandDispatcher getInstance() {
        return instance;
    }

    public static void register(String type, CommandListener listener) {
        Vector<CommandListener> list = CommandDispatcher.instance.listeners.get(type);
        if (list == null) {
            list = new Vector();
            CommandDispatcher.instance.listeners.put(type, list);
        }
        if (!list.contains(listener)) {
            list.addElement(listener);
        } else {
            log.error((Object)("Listener has already been registered. " + listener));
        }
    }

    public static void unregister(String type, CommandListener listener) {
        Vector<CommandListener> list = CommandDispatcher.instance.listeners.get(type);
        if (list.contains(listener)) {
            list.removeElement(listener);
        } else {
            log.error((Object)("Listener is not registered." + listener));
        }
    }

    public static boolean dispatch(CommandAction cmdAction) {
        Vector<CommandListener> list = CommandDispatcher.instance.listeners.get(cmdAction.getType());
        if (list != null) {
            for (CommandListener l : new Vector<CommandListener>(list)) {
                l.doCommand(cmdAction);
                if (!cmdAction.isConsumed) continue;
                return true;
            }
            return false;
        }
        if (!cmdAction.getType().endsWith("Database")) {
            log.warn((Object)("Type of Listeners couldn't be found[" + cmdAction.getType() + "]"));
        }
        return false;
    }
}

