/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class CommandAction
implements Cloneable {
    protected String type;
    protected String action;
    protected int tableId;
    protected Object data;
    protected Object srcObj;
    protected Object dstObj;
    protected boolean isConsumed = false;
    protected Properties properties = null;

    public CommandAction(String type, String action, Object srcObj, Object dstObj, Object data) {
        this.type = type;
        this.action = action;
        this.tableId = -1;
        this.srcObj = srcObj;
        this.dstObj = dstObj;
        this.data = data;
    }

    public CommandAction(String type, String action, Object data) {
        this.type = type;
        this.action = action;
        this.tableId = -1;
        this.data = data;
        this.srcObj = null;
        this.dstObj = null;
    }

    public CommandAction(String type, String action, int tableId) {
        this(type, action, tableId, null);
    }

    public CommandAction(String type, String action, int tableId, Hashtable<String, String> strParams) {
        this.type = type;
        this.action = action;
        this.tableId = tableId;
        this.data = null;
        this.srcObj = null;
        this.dstObj = null;
        if (strParams != null) {
            for (String key : strParams.keySet()) {
                this.setProperty(key, strParams.get(key));
            }
        }
    }

    public CommandAction(String type, String action, Hashtable<String, String> strParams) {
        this(type, action, -1, strParams);
    }

    public CommandAction(String type, String action) {
        this.type = type;
        this.action = action;
        this.tableId = -1;
        this.data = null;
        this.srcObj = null;
        this.dstObj = null;
    }

    public void set(CommandAction ca) {
        this.type = ca.type;
        this.action = ca.action;
        this.tableId = ca.tableId;
        this.srcObj = ca.srcObj;
        this.dstObj = ca.dstObj;
        this.data = ca.data;
        if (this.properties != null && ca.properties != null) {
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)ca.properties);
        }
    }

    public boolean isType(String typ) {
        return this.type != null && this.type.equals(typ);
    }

    public boolean isAction(String act) {
        return this.action != null && this.action.equals(act);
    }

    public String getAction() {
        return this.action;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isConsumed() {
        return this.isConsumed;
    }

    public void setConsumed(boolean isConsumed) {
        this.isConsumed = isConsumed;
    }

    public int getTableId() {
        return this.tableId;
    }

    public Object getDstObj() {
        return this.dstObj;
    }

    public Object getSrcObj() {
        return this.srcObj;
    }

    public void setSrcObj(Object srcObj) {
        this.srcObj = srcObj;
    }

    public Object getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public String getPropertyAsString(String name) {
        if (this.properties != null) {
            Object obj = this.properties.get(name);
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(name, value);
    }

    public void addProperties(Properties props) {
        if (props != null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.putAll((Map<?, ?>)props);
        }
    }

    public void addStringProperties(Properties props) {
        if (props != null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.putAll((Map<?, ?>)props);
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Object clone() throws CloneNotSupportedException {
        CommandAction obj = (CommandAction)super.clone();
        obj.type = this.type;
        obj.action = this.action;
        obj.tableId = this.tableId;
        obj.data = this.data;
        obj.srcObj = this.srcObj;
        obj.dstObj = this.dstObj;
        if (this.properties != null) {
            obj.properties = (Properties)this.properties.clone();
        }
        return obj;
    }

    public String toString() {
        return "CommandAction Type[" + this.type + "]  Action[" + this.action + "] data[" + (this.data != null ? this.data.getClass().getSimpleName() : "null") + "]";
    }
}

