/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import java.awt.Color;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ColorWrapper {
    private static final Logger log = Logger.getLogger(ColorWrapper.class);
    protected Color color;

    public ColorWrapper(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("ColorWrapper - The Color string is null!");
        }
        this.color = color;
    }

    public ColorWrapper(int r, int g, int b) {
        this.setRGB(r, g, b);
    }

    public ColorWrapper(String rgbStr) {
        this.setRGB(rgbStr);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color setRGB(int r, int g, int b) {
        int rr = Math.min(Math.max(0, r), 255);
        int gg = Math.min(Math.max(0, g), 255);
        int bb = Math.min(Math.max(0, b), 255);
        this.color = new Color(rr, gg, bb);
        return this.color;
    }

    public Color setRGB(String rgbStr) {
        if (rgbStr == null) {
            throw new IllegalArgumentException("ColorWrapper - The Color string is null!");
        }
        String[] rgbVals = StringUtils.split((String)rgbStr, (String)" ,");
        if (rgbVals.length == 3) {
            if (StringUtils.isNumeric((String)rgbVals[0]) && StringUtils.isNumeric((String)rgbVals[1]) && StringUtils.isNumeric((String)rgbVals[2])) {
                int r = Integer.parseInt(rgbVals[0]);
                int g = Integer.parseInt(rgbVals[1]);
                int b = Integer.parseInt(rgbVals[2]);
                this.setRGB(r, g, b);
            } else {
                this.setRGB(255, 255, 255);
                log.error((Object)("ColorWrapper - one of the values is not numeric [" + rgbStr + "] r[" + rgbVals[0] + "] g[" + rgbVals[1] + "] b[" + rgbVals[2] + "]"));
            }
        } else if (StringUtils.isNotEmpty((String)rgbStr)) {
            throw new IllegalArgumentException("ColorWrapper - The Color string doesn't parse [" + rgbStr + "]");
        }
        return this.color;
    }

    public static String toString(Color c) {
        return String.valueOf(c.getRed()) + ", " + c.getGreen() + ", " + c.getBlue();
    }

    public String toString() {
        return ColorWrapper.toString(this.color);
    }
}

