/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ColorChooser
extends JButton
implements AncestorListener,
GetSetValueIFace {
    protected JComponent drop_down_comp;
    protected JComponent visible_comp;
    protected Color color;
    protected JWindow popup;
    protected ColorSelectionPanel colorPanel;
    protected boolean justLostFocus = false;
    protected static int[] rgbs;

    static {
        int[] nArray = new int[168];
        nArray[3] = 255;
        nArray[4] = 255;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[10] = 255;
        nArray[14] = 255;
        nArray[15] = 255;
        nArray[16] = 255;
        nArray[18] = 255;
        nArray[20] = 255;
        nArray[22] = 255;
        nArray[23] = 255;
        nArray[24] = 128;
        nArray[28] = 128;
        nArray[32] = 128;
        nArray[33] = 128;
        nArray[34] = 128;
        nArray[36] = 128;
        nArray[38] = 128;
        nArray[40] = 128;
        nArray[41] = 128;
        nArray[42] = 192;
        nArray[43] = 192;
        nArray[44] = 192;
        nArray[45] = 128;
        nArray[46] = 128;
        nArray[47] = 128;
        nArray[48] = 153;
        nArray[49] = 153;
        nArray[50] = 255;
        nArray[51] = 153;
        nArray[52] = 51;
        nArray[53] = 102;
        nArray[54] = 255;
        nArray[55] = 255;
        nArray[56] = 204;
        nArray[57] = 204;
        nArray[58] = 255;
        nArray[59] = 255;
        nArray[60] = 102;
        nArray[62] = 102;
        nArray[63] = 255;
        nArray[64] = 128;
        nArray[65] = 128;
        nArray[67] = 102;
        nArray[68] = 204;
        nArray[69] = 204;
        nArray[70] = 204;
        nArray[71] = 255;
        nArray[74] = 128;
        nArray[75] = 255;
        nArray[77] = 255;
        nArray[78] = 255;
        nArray[79] = 255;
        nArray[82] = 255;
        nArray[83] = 255;
        nArray[84] = 128;
        nArray[86] = 128;
        nArray[87] = 128;
        nArray[91] = 128;
        nArray[92] = 128;
        nArray[95] = 255;
        nArray[97] = 204;
        nArray[98] = 255;
        nArray[99] = 204;
        nArray[100] = 255;
        nArray[101] = 255;
        nArray[102] = 204;
        nArray[103] = 255;
        nArray[104] = 204;
        nArray[105] = 255;
        nArray[106] = 255;
        nArray[107] = 153;
        nArray[108] = 153;
        nArray[109] = 204;
        nArray[110] = 255;
        nArray[111] = 255;
        nArray[112] = 153;
        nArray[113] = 204;
        nArray[114] = 204;
        nArray[115] = 153;
        nArray[116] = 255;
        nArray[117] = 255;
        nArray[118] = 204;
        nArray[119] = 153;
        nArray[120] = 51;
        nArray[121] = 102;
        nArray[122] = 255;
        nArray[123] = 51;
        nArray[124] = 204;
        nArray[125] = 204;
        nArray[126] = 153;
        nArray[127] = 204;
        nArray[129] = 255;
        nArray[130] = 204;
        nArray[132] = 255;
        nArray[133] = 153;
        nArray[135] = 255;
        nArray[136] = 102;
        nArray[138] = 102;
        nArray[139] = 102;
        nArray[140] = 153;
        nArray[141] = 150;
        nArray[142] = 150;
        nArray[143] = 150;
        nArray[145] = 51;
        nArray[146] = 102;
        nArray[147] = 51;
        nArray[148] = 153;
        nArray[149] = 102;
        nArray[151] = 51;
        nArray[153] = 51;
        nArray[154] = 51;
        nArray[156] = 153;
        nArray[157] = 51;
        nArray[159] = 153;
        nArray[160] = 51;
        nArray[161] = 102;
        nArray[162] = 51;
        nArray[163] = 51;
        nArray[164] = 153;
        nArray[165] = 51;
        nArray[166] = 51;
        nArray[167] = 51;
        rgbs = nArray;
    }

    public ColorChooser(Color color) {
        this.color = color;
        this.visible_comp = this;
        this.setBackground(color);
        this.setPreferredSize(new Dimension(16, 16));
        this.init();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    protected void init() {
        this.drop_down_comp = new ColorSelectionPanel();
        this.drop_down_comp.addPropertyChangeListener("selectedColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ColorChooser.this.hidePopup();
                Color colorVal = (Color)evt.getNewValue();
                ColorChooser.this.setValue(colorVal, null);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!(ColorChooser.this.justLostFocus || ColorChooser.this.popup != null && ColorChooser.this.popup.isVisible())) {
                    ColorChooser.this.createColorPanelWindow();
                }
                ColorChooser.this.justLostFocus = false;
            }
        });
        this.addAncestorListener(this);
    }

    protected void createColorPanelWindow() {
        if (this.popup != null && this.popup.isVisible()) {
            this.hidePopup();
        } else {
            Dialog parentDlg = this.getDialog(this);
            this.popup = parentDlg != null ? new JWindow(parentDlg) : new JWindow(this.getFrame(this));
            this.popup.getContentPane().add(this.drop_down_comp);
            this.popup.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent evt) {
                    ColorChooser.this.justLostFocus = true;
                    ColorChooser.this.hidePopup();
                }
            });
            this.popup.pack();
            Point pt = this.visible_comp.getLocationOnScreen();
            pt.translate(this.visible_comp.getWidth() - this.popup.getWidth(), this.visible_comp.getHeight());
            this.popup.setLocation(pt);
            this.popup.toFront();
            this.popup.setVisible(true);
            this.popup.requestFocusInWindow();
        }
    }

    protected Frame getFrame(Component component) {
        Component comp = component;
        if (comp == null) {
            comp = this;
        }
        if (comp.getParent() instanceof Frame) {
            return (Frame)comp.getParent();
        }
        return this.getFrame(comp.getParent());
    }

    protected Dialog getDialog(Component comp) {
        if (comp.getParent() instanceof Dialog) {
            return (Dialog)comp.getParent();
        }
        return this.getDialog(comp.getParent());
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.hidePopup();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.hidePopup();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (event.getSource() != this.popup) {
            this.hidePopup();
        }
    }

    public void hidePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        Object data = value;
        if (data instanceof String) {
            data = new ColorWrapper((String)data).getColor();
        }
        if (data instanceof Color) {
            Color newValue = (Color)data;
            Color oldColor = this.color;
            this.color = newValue;
            this.visible_comp.setBackground(this.color);
            this.firePropertyChange("setValue", oldColor, newValue);
        }
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    class ColorSelectionPanel
    extends JPanel {
        protected Color selectedColor = Color.black;

        public ColorSelectionPanel() {
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gbl);
            ActionListener color_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColorChooser.this.hidePopup();
                    ColorSelectionPanel.this.selectColor(((JButton)evt.getSource()).getBackground());
                }
            };
            ActionListener othercolor_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Color newColor = JColorChooser.showDialog(ColorChooser.this, "Choose Color", ColorChooser.this.getBackground());
                    if (newColor != null) {
                        ColorSelectionPanel.this.selectColor(newColor);
                    }
                }
            };
            c.gridheight = 1;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            int numCols = 8;
            int numRows = rgbs.length / 3 / numCols;
            Dimension dim = new Dimension(15, 15);
            int inx = 0;
            int i = 0;
            while (i < numRows) {
                int j = 0;
                while (j < numCols) {
                    c.gridx = j;
                    c.gridy = i;
                    if (inx > rgbs.length) {
                        JLabel lbl = new JLabel();
                        gbl.setConstraints(lbl, c);
                        lbl.setSize(dim);
                        lbl.setPreferredSize(dim);
                        lbl.setMinimumSize(dim);
                        this.add(lbl);
                    } else {
                        JButton button = new JButton("");
                        button.setSize(dim);
                        button.setPreferredSize(dim);
                        button.setMinimumSize(dim);
                        Color colorVal = new Color(rgbs[inx++], rgbs[inx++], rgbs[inx++]);
                        button.setBackground(colorVal);
                        button.setForeground(colorVal);
                        button.setOpaque(true);
                        button.setBorderPainted(false);
                        button.setBorder(BorderFactory.createEtchedBorder());
                        gbl.setConstraints(button, c);
                        this.add(button);
                        button.addActionListener(color_listener);
                    }
                    ++j;
                }
                ++i;
            }
            JButton button = new JButton("Other...");
            button.setBorder(BorderFactory.createEtchedBorder());
            c.fill = 1;
            c.gridx = 0;
            c.gridy = numRows;
            c.gridwidth = 0;
            gbl.setConstraints(button, c);
            this.add(button);
            button.addActionListener(othercolor_listener);
        }

        public void selectColor(Color newColor) {
            Color oldColor = this.selectedColor;
            this.selectedColor = newColor;
            this.firePropertyChange("selectedColor", oldColor, newColor);
        }
    }
}

