/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import edu.ku.brc.ui.GradiantButton;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class CloseButton
extends GradiantButton {
    protected Color closeColor = Color.WHITE;
    protected Color closeHoverColor = new Color(200, 102, 102);
    protected boolean isHovering = false;

    public CloseButton() {
        super("");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CloseButton.this.isHovering = true;
                CloseButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CloseButton.this.isHovering = false;
                CloseButton.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int w = (int)((double)fm.getAscent() * 0.8);
        Rectangle r = new Rectangle((this.getWidth() - w) / 2, (this.getHeight() - w) / 2, w, w);
        if (this.pressed) {
            g.translate(1, 1);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.isHovering ? this.closeHoverColor : this.closeColor);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(this.isHovering ? new Color(64, 64, 64) : this.getForeground());
        r.grow(-3, -3);
        g.drawLine(r.x, r.y, r.x + r.width - 1, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + r.width - 1, r.y);
    }

    public Color getCloseColor() {
        return this.closeColor;
    }

    public void setCloseColor(Color closeColor) {
        this.closeColor = closeColor;
        this.repaint();
    }
}

