/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.IconListCellRenderer;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ChooseFromListDlg<T>
extends JDialog {
    public static final int OK_BTN = 1;
    public static final int CANCEL_BTN = 2;
    public static final int HELP_BTN = 4;
    public static final int APPLY_BTN = 8;
    public static final int OKCANCEL = 3;
    public static final int OKHELP = 5;
    public static final int OKCANCELHELP = 7;
    public static final int OKCANCELAPPLY = 11;
    public static final int OKCANCELAPPLYHELP = 15;
    private static final Logger log = Logger.getLogger(ChooseFromListDlg.class);
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    protected JButton helpBtn = null;
    protected JButton applyBtn = null;
    protected String okLabel = null;
    protected String cancelLabel = null;
    protected String helpLabel = null;
    protected String applyLabel = null;
    protected JList list = null;
    protected List<T> items;
    protected ImageIcon icon = null;
    protected boolean isCancelled = true;
    protected int btnPressed = 2;
    protected String title = null;
    protected String desc = null;
    protected int whichBtns = 1;
    protected String helpContext = null;
    protected boolean isMultiSelect = false;
    protected int[] selectedIndices = null;
    protected boolean isCloseOnApply = false;

    public ChooseFromListDlg(Frame frame, String title, List<T> itemList) throws HeadlessException {
        this(frame, title, 3, itemList);
    }

    public ChooseFromListDlg(Frame frame, String title, int whichBtns, List<T> itemList) throws HeadlessException {
        this(frame, title, null, whichBtns, itemList);
    }

    public ChooseFromListDlg(Frame frame, String title, String desc, int whichBtns, List<T> itemList) throws HeadlessException {
        this(frame, title, desc, whichBtns, itemList, null);
    }

    public ChooseFromListDlg(Frame frame, String title, String desc, int whichBtns, List<T> itemList, String helpContext) throws HeadlessException {
        super(frame, true);
        this.title = title;
        this.desc = desc;
        this.items = itemList;
        this.whichBtns = whichBtns;
        this.helpContext = helpContext;
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public ChooseFromListDlg(Frame frame, String title, List<T> itemList, ImageIcon icon) throws HeadlessException {
        this(frame, title, 3, itemList, icon, null);
    }

    public ChooseFromListDlg(Frame frame, String title, int whichBtns, List<T> itemList, ImageIcon icon) throws HeadlessException {
        this(frame, title, whichBtns, itemList, icon, null);
    }

    public ChooseFromListDlg(Frame frame, String title, int whichBtns, List<T> itemList, ImageIcon icon, String helpContext) throws HeadlessException {
        this(frame, title, whichBtns, itemList);
        this.icon = icon;
        this.helpContext = helpContext;
        this.setModal(true);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
    }

    public ChooseFromListDlg(Dialog dlg, String title, String desc, int whichBtns, List<T> itemList, String helpContext) throws HeadlessException {
        super(dlg, true);
        this.title = title;
        this.desc = desc;
        this.items = itemList;
        this.whichBtns = whichBtns;
        this.helpContext = helpContext;
        this.setLocationRelativeTo(dlg);
        this.setDefaultCloseOperation(2);
        ImageIcon appIcon = IconManager.getIcon("AppIcon");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
        }
    }

    public ChooseFromListDlg(Dialog dlg, String title, List<T> itemList) throws HeadlessException {
        this(dlg, title, null, 3, itemList, null);
    }

    public void createUI() {
        this.setTitle(this.title);
        boolean hasDesc = StringUtils.isNotEmpty((String)this.desc);
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:max(300px;p):g", "p," + (hasDesc ? "2px,p," : "") + "5px,p"));
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        int y = 1;
        if (hasDesc) {
            JLabel lbl = UIHelper.createLabel(this.desc, 0);
            builder.add((Component)lbl, cc.xy(1, y));
            y += 2;
        }
        try {
            AbstractListModel listModel = new AbstractListModel(){

                @Override
                public int getSize() {
                    return ChooseFromListDlg.this.items.size();
                }

                @Override
                public Object getElementAt(int index) {
                    return ChooseFromListDlg.this.items.get(index).toString();
                }
            };
            this.list = new JList(listModel);
            if (this.icon != null) {
                this.list.setCellRenderer(this.getListCellRenderer());
            }
            this.list.setSelectionMode(this.isMultiSelect ? 2 : 0);
            this.list.setVisibleRowCount(10);
            if (this.selectedIndices != null) {
                this.list.setSelectedIndices(this.selectedIndices);
            }
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ChooseFromListDlg.this.okBtn.doClick();
                    }
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ChooseFromListDlg.this.updateUIState();
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.list);
            builder.add((Component)listScroller, cc.xy(1, y));
            y += 2;
            this.okBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.okLabel) ? this.okLabel : UIRegistry.getResourceString("OK"));
            this.okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ChooseFromListDlg.this.isCancelled = false;
                    ChooseFromListDlg.this.btnPressed = 1;
                    ChooseFromListDlg.this.setVisible(false);
                }
            });
            this.getRootPane().setDefaultButton(this.okBtn);
            if ((this.whichBtns & 2) == 2) {
                this.cancelBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.cancelLabel) ? this.cancelLabel : UIRegistry.getResourceString("CANCEL"));
                this.cancelBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ChooseFromListDlg.this.isCancelled = true;
                        ChooseFromListDlg.this.btnPressed = 2;
                        ChooseFromListDlg.this.setVisible(false);
                    }
                });
            }
            if ((this.whichBtns & 4) == 4) {
                this.helpBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.cancelLabel) ? this.cancelLabel : UIRegistry.getResourceString("HELP"));
                if (StringUtils.isNotEmpty((String)this.helpContext)) {
                    HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
                } else {
                    this.helpBtn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ChooseFromListDlg.this.btnPressed = 4;
                        }
                    });
                }
            }
            if ((this.whichBtns & 8) == 8) {
                this.applyBtn = UIHelper.createButton(StringUtils.isNotEmpty((String)this.applyLabel) ? this.applyLabel : UIRegistry.getResourceString("Apply"));
                this.applyBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ChooseFromListDlg.this.btnPressed = 8;
                        if (ChooseFromListDlg.this.isCloseOnApply) {
                            ChooseFromListDlg.this.isCancelled = false;
                            ChooseFromListDlg.this.setVisible(false);
                        }
                    }
                });
            }
            JPanel bb = this.whichBtns == 1 ? ButtonBarFactory.buildOKBar((JButton)this.okBtn) : (this.whichBtns == 3 ? ButtonBarFactory.buildOKCancelBar((JButton)this.okBtn, (JButton)this.cancelBtn) : (this.whichBtns == 11 ? ButtonBarFactory.buildOKCancelApplyBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.applyBtn) : (this.whichBtns == 5 ? ButtonBarFactory.buildOKHelpBar((JButton)this.okBtn, (JButton)this.helpBtn) : (this.whichBtns == 7 ? ButtonBarFactory.buildOKCancelHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.helpBtn) : (this.whichBtns == 15 ? ButtonBarFactory.buildOKCancelApplyHelpBar((JButton)this.okBtn, (JButton)this.cancelBtn, (JButton)this.applyBtn, (JButton)this.helpBtn) : ButtonBarFactory.buildOKBar((JButton)this.okBtn))))));
            builder.add((Component)bb, cc.xy(1, y));
            y += 2;
            this.updateUIState();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ChooseFromListDlg.class, ex);
            log.error((Object)ex);
        }
        this.setContentPane(builder.getPanel());
        this.pack();
    }

    protected ListCellRenderer getListCellRenderer() {
        return new IconListCellRenderer(this.icon);
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JList getList() {
        return this.list;
    }

    public void setCloseOnApply(boolean isCloseOnApply) {
        this.isCloseOnApply = isCloseOnApply;
    }

    public void setMultiSelect(boolean isMultiSelectArg) {
        this.isMultiSelect = isMultiSelectArg;
    }

    protected void updateUIState() {
        this.okBtn.setEnabled(this.list.getSelectedIndex() != -1);
    }

    public T getSelectedObject() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            return this.items.get(inx);
        }
        return null;
    }

    public List<T> getSelectedObjects() {
        ArrayList<T> selectedItems = new ArrayList<T>(5);
        int[] nArray = this.list.getSelectedIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int ind = nArray[n2];
            selectedItems.add(this.items.get(ind));
            ++n2;
        }
        return selectedItems;
    }

    public int[] getSelectedIndices() {
        return this.list != null ? this.list.getSelectedIndices() : null;
    }

    public void setIndices(int[] indices) {
        this.selectedIndices = indices;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setOkLabel(String text) {
        this.okLabel = text;
    }

    public void setCancelLabel(String text) {
        this.cancelLabel = text;
    }

    public int getBtnPressed() {
        return this.btnPressed;
    }

    public void setApplyLabel(String applyLabel) {
        this.applyLabel = applyLabel;
    }

    public void setHelpContext(String helpContext) {
        this.helpContext = helpContext;
    }

    public void setHelpLabel(String helpLabel) {
        this.helpLabel = helpLabel;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.list == null) {
            this.createUI();
        }
        UIHelper.centerWindow(this);
        super.setVisible(visible);
    }
}

