/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.tasks.StatsTask;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.dbsupport.CustomQueryFactory;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.PairsMultipleQueryResultsHandler;
import edu.ku.brc.dbsupport.PairsSingleQueryResultsHandler;
import edu.ku.brc.dbsupport.QueryResultsContainer;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.dbsupport.QueryResultsListener;
import edu.ku.brc.dbsupport.QueryResultsProcessable;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.tasks.subpane.SQLQueryPane;
import edu.ku.brc.stats.BarChartPanel;
import edu.ku.brc.stats.Chartable;
import edu.ku.brc.stats.PieChartPanel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class StatsMgr {
    private static final Logger log = Logger.getLogger(StatsMgr.class);
    protected static SoftReference<Element> statDOM = null;
    protected static final String DISPLAY = "display";
    protected static final String BAR_CHART = "bar chart";
    protected static final String PIE_CHART = "pie chart";
    protected static final String TABLE = "table";
    protected static final String FORM = "form";
    protected static String resourceName = null;
    protected static ResourceBundle resBundle = null;
    protected static Hashtable<String, String> nameToToolTipHash = new Hashtable();
    protected static StatsMgr instance = new StatsMgr();

    protected StatsMgr() {
    }

    public static Element getDOM() {
        Element dom = null;
        if (statDOM != null) {
            dom = statDOM.get();
        }
        if (dom == null) {
            statDOM = new SoftReference<Element>(StatsMgr.loadDOM());
            dom = statDOM.get();
        }
        if (resourceName == null) {
            resourceName = XMLHelper.getAttr(dom, "resource", null);
            StatsMgr.loadStatTooltips();
        }
        return dom;
    }

    public static String getResourceName() {
        return resourceName;
    }

    protected static Element loadDOM() {
        Element dom = null;
        try {
            dom = AppContextMgr.getInstance().getResourceAsDOM("Statistics");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(StatsMgr.class, ex);
            log.error((Object)ex);
        }
        return dom;
    }

    public static Element getStatisticDOMElement(String name) {
        return (Element)StatsMgr.getDOM().selectSingleNode("/statistics/stat[@name='" + name + "']");
    }

    private static void loadStatTooltips() {
        nameToToolTipHash.clear();
        boolean hasResBundle = false;
        if (StringUtils.isNotEmpty((String)StatsMgr.getResourceName())) {
            hasResBundle = UIRegistry.loadAndPushResourceBundle(StatsMgr.getResourceName()) != null;
        }
        try {
            Element dom = StatsMgr.getDOM();
            if (dom != null) {
                for (Element element : dom.selectNodes("/statistics/stat")) {
                    String name = XMLHelper.getAttr(element, "name", null);
                    if (name == null) continue;
                    String tooltipName = null;
                    Element el = (Element)element.selectSingleNode("chartinfo/tooltip");
                    if (el != null) {
                        tooltipName = el.getTextTrim();
                    } else {
                        el = (Element)element.selectSingleNode("tooltip");
                        if (el != null) {
                            tooltipName = el.getTextTrim();
                        }
                    }
                    if (tooltipName == null) continue;
                    nameToToolTipHash.put(name, UIRegistry.getResourceString(tooltipName));
                }
            }
        }
        finally {
            if (hasResBundle) {
                UIRegistry.popResourceBundle();
            }
        }
    }

    protected String getChartInfo(Element element, String name, boolean isI18NKey) {
        Element el = (Element)element.selectSingleNode("chartinfo/" + name);
        if (el != null) {
            String str = el.getText();
            if (isI18NKey) {
                return UIRegistry.getResourceString(str);
            }
            return str;
        }
        return "";
    }

    protected String fillWithChartInfo(Element element, Chartable chartable) {
        boolean isI18NKey = resBundle != null;
        chartable.setTitle(this.getChartInfo(element, "title", isI18NKey));
        chartable.setXAxis(this.getChartInfo(element, "xaxis", isI18NKey));
        chartable.setYAxis(this.getChartInfo(element, "yaxis", isI18NKey));
        String toolTip = this.getChartInfo(element, "tooltip", isI18NKey);
        String vert = this.getChartInfo(element, "vertical", false);
        if (StringUtils.isNotEmpty((String)vert)) {
            chartable.setVertical(vert.toLowerCase().equals("true"));
        }
        return toolTip;
    }

    public static void add(QueryResultsContainer qrc, int descRow, int descCol, int valueRow, int valueCol) {
        qrc.add(new QueryResultsDataObj(descRow, descCol));
        qrc.add(new QueryResultsDataObj(valueRow, valueCol));
    }

    private void createChart(String chartName, Element element, QueryResultsProcessable qrProcessable, Chartable chartable, QueryResultsListener listener) {
        if (element != null) {
            Element sqlElement;
            String tooltip = this.fillWithChartInfo(element, chartable);
            if (tooltip != null) {
                nameToToolTipHash.put(chartName, tooltip);
            }
            if ((sqlElement = (Element)element.selectSingleNode("sql")) == null) {
                throw new RuntimeException("sql element is null!");
            }
            String sqlType = sqlElement.attributeValue("type");
            if (sqlType.equals("text")) {
                QueryResultsContainer container = new QueryResultsContainer();
                PairsSingleQueryResultsHandler singlePairs = new PairsSingleQueryResultsHandler();
                qrProcessable.setHandler(singlePairs);
                container.setSql(QueryAdjusterForDomain.getInstance().adjustSQL(sqlElement.getText().trim()));
                String displayType = element.attributeValue(DISPLAY);
                List parts = element.selectNodes(displayType.equals("Pie Chart") ? "slice" : "bar");
                for (Element slice : parts) {
                    int descRow = Integer.parseInt(slice.valueOf("desc/@row"));
                    int descCol = Integer.parseInt(slice.valueOf("desc/@col"));
                    int valueRow = Integer.parseInt(slice.valueOf("value/@row"));
                    int valueCol = Integer.parseInt(slice.valueOf("value/@col"));
                    StatsMgr.add(container, descRow, descCol, valueRow, valueCol);
                }
                singlePairs.init(listener, container);
                singlePairs.startUp();
            } else if (sqlType.equals("custom")) {
                CustomQueryIFace customQuery = CustomQueryFactory.getInstance().getQuery(sqlElement.attributeValue("name"));
                PairsMultipleQueryResultsHandler multiplePairs = new PairsMultipleQueryResultsHandler();
                qrProcessable.setHandler(multiplePairs);
                multiplePairs.init(listener, customQuery.getQueryDefinition());
                multiplePairs.startUp();
            } else {
                throw new RuntimeException("unrecognizable type for sql element[" + sqlType + "]");
            }
        }
    }

    protected void createView(Element domElement, String idStr) {
        String viewSetName = domElement.attributeValue("viewset");
        String viewName = domElement.attributeValue("view");
        String mode = domElement.attributeValue("mode");
        ViewIFace view = AppContextMgr.getInstance().getView(viewSetName, viewName);
        if (view != null) {
            CommandDispatcher.dispatch(new CommandAction("Data_Entry", "ShowView", new Object[]{view, mode, idStr}));
        } else {
            log.error((Object)("Couldn't dispatch request for new View because the view wasn't found: ViewSet[" + viewSetName + "] View[" + viewName + "]"));
        }
    }

    private JPanel createStatPaneInternal(String statName) {
        if (StringUtils.isNotEmpty((String)resourceName)) {
            resBundle = UIRegistry.loadAndPushResourceBundle(resourceName);
        }
        try {
            String nameStr;
            String idStr = null;
            int inx = statName.indexOf(44);
            if (inx == -1) {
                nameStr = statName;
            } else {
                nameStr = statName.substring(0, inx);
                idStr = statName.substring(inx + 4, statName.length());
            }
            Element dom = StatsMgr.getDOM();
            if (dom != null) {
                Element element = (Element)dom.selectSingleNode("/statistics/stat[@name='" + nameStr + "']");
                if (element != null) {
                    String displayType = element.attributeValue(DISPLAY).toLowerCase();
                    if (displayType.equalsIgnoreCase(BAR_CHART)) {
                        BarChartPanel barChart = new BarChartPanel();
                        this.createChart(nameStr, element, barChart, barChart, barChart);
                        BarChartPanel barChartPanel = barChart;
                        return barChartPanel;
                    }
                    if (displayType.equalsIgnoreCase(PIE_CHART)) {
                        PieChartPanel pieChart = new PieChartPanel();
                        this.createChart(nameStr, element, pieChart, pieChart, pieChart);
                        PieChartPanel pieChartPanel = pieChart;
                        return pieChartPanel;
                    }
                    if (displayType.equalsIgnoreCase(FORM)) {
                        this.createView(element, idStr);
                    } else if (displayType.equals(TABLE)) {
                        Element sqlElement = (Element)element.selectSingleNode("sql");
                        if (sqlElement == null) {
                            throw new RuntimeException("sql element is null!");
                        }
                        Element titleElement = (Element)element.selectSingleNode("title");
                        if (titleElement == null) {
                            throw new RuntimeException("sql element is null!");
                        }
                        String tooltip = XMLHelper.getAttr((Element)element.selectSingleNode("tooltip"), "tooltip", null);
                        if (tooltip != null) {
                            nameToToolTipHash.put(statName, tooltip);
                        }
                        StatsTask statTask = (StatsTask)ContextMgr.getTaskByName("Statistics");
                        SQLQueryPane queryPane = new SQLQueryPane(titleElement.getTextTrim(), statTask, true, true);
                        String sqlStr = sqlElement.getTextTrim();
                        if (idStr != null) {
                            int substInx = sqlStr.lastIndexOf("%s");
                            if (substInx > -1) {
                                sqlStr = String.valueOf(sqlStr.substring(0, substInx - 1)) + idStr + sqlStr.substring(substInx + 2, sqlStr.length());
                            } else {
                                log.error((Object)("Couldn't find the substitue string \"%s\" in [" + sqlStr + "]"));
                            }
                        }
                        queryPane.setSQLStr(sqlStr);
                        queryPane.doQuery();
                        SubPaneMgr.getInstance().addPane(queryPane);
                    } else {
                        log.error((Object)("Wrong type of display [" + displayType + "] this type is not supported!"));
                    }
                }
            } else {
                log.error((Object)"DOM is NULL!!");
            }
        }
        finally {
            if (resBundle != null) {
                UIRegistry.popResourceBundle();
            }
        }
        return null;
    }

    public static JPanel createStatPane(String statName) {
        return instance.createStatPaneInternal(statName);
    }

    public static String getTooltipForStat(String statName) {
        return nameToToolTipHash.get(statName);
    }
}

