/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import edu.ku.brc.stats.StatDataItem;
import edu.ku.brc.stats.StatGroupTable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class StatGroupTableModel
extends AbstractTableModel {
    protected Vector<StatDataItem> data = new Vector();
    protected Vector<Class<?>> classNames = new Vector();
    protected int currentRow = 0;
    protected int numRows = 0;
    protected String[] columnNames;
    protected StatGroupTable statGroupTable;

    public StatGroupTableModel(StatGroupTable statGroupTable, String[] columnNames) {
        this.statGroupTable = statGroupTable;
        this.columnNames = columnNames;
    }

    public void addDataItem(StatDataItem sdi) {
        this.data.add(sdi);
        this.fireTableDataChanged();
        sdi.setTableModel(this);
    }

    public StatDataItem getDataItem(int index) {
        return this.data.get(index);
    }

    public void fireNewData() {
        this.fireTableDataChanged();
        if (this.statGroupTable != null) {
            this.statGroupTable.fireNewData();
        }
    }

    public void clear() {
        for (StatDataItem sdi : this.data) {
            sdi.clear();
        }
        this.data.clear();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        int dataInx;
        int n = dataInx = this.columnNames.length == 2 ? 1 : 0;
        if (column == dataInx && this.data.size() > 0) {
            StatDataItem sdi = this.data.get(0);
            Object val = sdi.getValue();
            return val == null ? String.class : val.getClass();
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames[column] : "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.data.size() && column < 2) {
            StatDataItem sdi = this.data.get(row);
            if (this.columnNames.length == 1) {
                return sdi.getValue();
            }
            return column == 0 ? sdi.getDescription() : sdi.getValue();
        }
        return "XXX";
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }
}

