/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import com.jgoodies.forms.layout.CellConstraints;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.stats.StatDataItem;
import edu.ku.brc.stats.StatGroupTable;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class StatGroupTableFromQuery
extends StatGroupTable
implements SQLExecutionListener {
    private static final Logger log = Logger.getLogger(StatGroupTableFromQuery.class);
    protected SQLExecutionProcessor sqle;
    protected int descCol;
    protected int valCol;
    protected String noResultsMsg;
    protected boolean hasData = false;

    public StatGroupTableFromQuery(String name, String[] columnNames, String sql, int descCol, int valCol, boolean useSeparator, String noResultsMsg) {
        super(name, columnNames, useSeparator, 100);
        this.descCol = descCol;
        this.valCol = valCol;
        this.noResultsMsg = noResultsMsg;
        StatDataItem statItem = new StatDataItem("RetrievingData", null, false);
        this.model.addDataItem(statItem);
        String adjustedSQL = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
        this.sqle = new SQLExecutionProcessor(this, adjustedSQL);
        this.sqle.start();
    }

    @Override
    public void reloadData() {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.hasData ? super.getPreferredSize() : new Dimension(100, 100);
    }

    protected void addNoneAvailableMsg(String msg) {
        JLabel label = UIHelper.createLabel(this.noResultsMsg != null ? this.noResultsMsg : UIRegistry.getResourceString("NoneAvail"));
        if (this.useSeparator) {
            this.builder.getPanel().remove(this.scrollPane != null ? this.scrollPane : this.table);
            this.builder.add((Component)label, new CellConstraints().xy(1, 2));
        } else {
            this.remove(this.scrollPane != null ? this.scrollPane : this.table);
            this.add((Component)label, "Center");
        }
    }

    @Override
    public synchronized void exectionDone(SQLExecutionProcessor processor, ResultSet resultSet) {
        this.model.clear();
        this.hasData = true;
        Vector<Object> data = new Vector<Object>();
        try {
            if (resultSet.next()) {
                do {
                    if (this.descCol != -1) {
                        data.add(resultSet.getObject(this.descCol));
                    }
                    data.add(resultSet.getObject(this.valCol));
                    data.add(this.colId > 0 ? resultSet.getObject(this.colId) : null);
                } while (resultSet.next());
                int i = 0;
                while (i < data.size()) {
                    String desc = this.descCol != -1 ? data.get(i++).toString() : "";
                    Object val = data.get(i++);
                    Object colIdObj = data.get(i);
                    StatDataItem statItem = new StatDataItem(desc, this.createCommandAction(colIdObj), false);
                    this.model.addDataItem(statItem);
                    statItem.setValue(val);
                    ++i;
                }
                data.clear();
            } else {
                this.addNoneAvailableMsg(this.noResultsMsg);
            }
            this.model.fireNewData();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(StatGroupTableFromQuery.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized void executionError(SQLExecutionProcessor processor, Exception ex) {
        this.addNoneAvailableMsg(UIRegistry.getResourceString("GetStatsError"));
    }
}

