/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import com.jgoodies.forms.layout.CellConstraints;
import edu.ku.brc.dbsupport.CustomQueryFactory;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.stats.StatDataItem;
import edu.ku.brc.stats.StatGroupTable;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;

public class StatGroupTableFromCustomQuery
extends StatGroupTable
implements CustomQueryListener {
    protected String noResultsMsg;
    protected boolean hasData = false;

    public StatGroupTableFromCustomQuery(String name, String[] columnNames, String sql, String noResultsMsg) {
        super(name, columnNames);
        this.noResultsMsg = noResultsMsg;
        StatDataItem statItem = new StatDataItem("RetrievingData", null, false);
        this.model.addDataItem(statItem);
        CustomQueryIFace customQuery = CustomQueryFactory.getInstance().getQuery(sql);
        customQuery.execute(this);
    }

    public StatGroupTableFromCustomQuery(String name, String[] columnNames, CustomQueryIFace jpaQuery, boolean useSeparator, String noResultsMsg) {
        super(name, columnNames);
        this.noResultsMsg = noResultsMsg;
        StatDataItem statItem = new StatDataItem("RetrievingData", null, false);
        this.model.addDataItem(statItem);
        jpaQuery.execute(this);
    }

    public StatGroupTableFromCustomQuery(String name, String[] columnNames, String sql, boolean useSeparator, String noResultsMsg) {
        super(name, columnNames, useSeparator, 100);
        this.noResultsMsg = noResultsMsg;
        StatDataItem statItem = new StatDataItem("RetrievingData", null, false);
        this.model.addDataItem(statItem);
        CustomQueryIFace customQuery = CustomQueryFactory.getInstance().getQuery(sql);
        customQuery.execute(this);
    }

    @Override
    public void setCommandAction(CommandAction commandAction, int colId) {
        this.cmdAction = commandAction;
        this.colId = colId;
    }

    @Override
    public void reloadData() {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.hasData ? super.getPreferredSize() : new Dimension(100, 100);
    }

    protected void addNoneAvailableMsg(String msg) {
        JLabel label = UIHelper.createLabel(this.noResultsMsg != null ? this.noResultsMsg : UIRegistry.getResourceString("NoneAvail"));
        if (this.useSeparator) {
            this.builder.getPanel().remove(this.scrollPane != null ? this.scrollPane : this.table);
            this.builder.add((Component)label, new CellConstraints().xy(1, 2));
        } else {
            this.remove(this.scrollPane != null ? this.scrollPane : this.table);
            this.add((Component)label, "Center");
        }
    }

    @Override
    public synchronized void exectionDone(CustomQueryIFace customQuery) {
        this.model.clear();
        this.hasData = true;
        List<?> results = customQuery.getDataObjects();
        if (results != null && results.size() > 0) {
            int i = 0;
            while (i < results.size()) {
                String desc = results.get(i++).toString();
                Object val = results.get(i++);
                Object colIdObj = results.get(i);
                StatDataItem statItem = new StatDataItem(desc, this.createCommandAction(colIdObj), false);
                statItem.setValue(val);
                this.model.addDataItem(statItem);
                ++i;
            }
            results.clear();
        } else {
            this.addNoneAvailableMsg(this.noResultsMsg);
        }
        this.model.fireNewData();
    }

    @Override
    public synchronized void executionError(CustomQueryIFace customQuery) {
        this.addNoneAvailableMsg(UIRegistry.getResourceString("GetStatsError"));
    }
}

