/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.RecordSetFactory;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.stats.StatDataItem;
import edu.ku.brc.stats.StatGroupTableModel;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CurvedBorder;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JTiledPanel;
import edu.ku.brc.ui.SortableJTable;
import edu.ku.brc.ui.SortableTableModel;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class StatGroupTable
extends JTiledPanel {
    protected static final int SCROLLPANE_THRESOLD = 10;
    protected static final Cursor handCursor = new Cursor(12);
    protected static final Cursor defCursor = new Cursor(0);
    protected static ImageIcon progressIcon = null;
    protected static int visibleRows = 8;
    protected String name;
    protected PanelBuilder builder = new PanelBuilder(new FormLayout("p:g", "p,p:g"));
    protected JTable table;
    protected StatGroupTableModel model;
    protected JScrollPane scrollPane = null;
    protected boolean useSeparator = true;
    protected int colId = -1;
    protected CommandAction cmdAction = null;
    protected SkinItem skinItem;

    public StatGroupTable(String name, String[] columnNames) {
        this.name = name;
        this.skinItem = SkinsMgr.getSkinItem("StatGroup");
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(SkinsMgr.shouldBeOpaque(this.skinItem));
        if (progressIcon == null) {
            progressIcon = IconManager.getIcon("Progress", IconManager.IconSize.Std16);
        }
        if (this.skinItem != null) {
            this.skinItem.setupPanel(this);
        } else {
            this.setOpaque(true);
        }
    }

    public StatGroupTable(String name, String[] columnNames, boolean useSeparator, int numRows) {
        this.name = name;
        this.useSeparator = useSeparator;
        this.skinItem = SkinsMgr.getSkinItem("StatGroup");
        if (progressIcon == null) {
            progressIcon = IconManager.getIcon("Progress", IconManager.IconSize.Std16);
        }
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.model = new StatGroupTableModel(this, columnNames);
        this.table = numRows > 10 ? new SortableJTable(new SortableTableModel(this.model)){

            @Override
            protected void configureEnclosingScrollPane() {
                Container gp;
                Container p = this.getParent();
                if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)gp;
                    JViewport viewport = scrollPane.getViewport();
                    if (viewport == null || viewport.getView() != this) {
                        return;
                    }
                    scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                }
            }
        } : new JTable(this.model){

            @Override
            protected void configureEnclosingScrollPane() {
                Container gp;
                Container p = this.getParent();
                if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)gp;
                    JViewport viewport = scrollPane.getViewport();
                    if (viewport == null || viewport.getView() != this) {
                        return;
                    }
                    scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                }
            }
        };
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        if (SkinsMgr.shouldBeOpaque(this.skinItem)) {
            this.table.setOpaque(false);
            this.setOpaque(false);
        } else {
            this.table.setOpaque(true);
            this.setOpaque(true);
        }
        this.table.addMouseMotionListener(new TableMouseMotion());
        this.table.addMouseListener(new LinkListener());
        if (this.table.getColumnModel().getColumnCount() == 1) {
            this.table.getColumnModel().getColumn(0).setCellRenderer(new StatGroupTableCellRenderer(0, 1));
        } else {
            this.table.getColumnModel().getColumn(0).setCellRenderer(new StatGroupTableCellRenderer(2, 2));
            this.table.getColumnModel().getColumn(1).setCellRenderer(new StatGroupTableCellRenderer(4, 2));
        }
        if (numRows > 10) {
            this.scrollPane = new JScrollPane(this.table, 20, 31);
            if (this.table instanceof SortableJTable) {
                ((SortableJTable)this.table).installColumnHeaderListeners();
            }
            this.scrollPane.setOpaque(false);
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        if (useSeparator) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            CellConstraints cc = new CellConstraints();
            if (StringUtils.isNotEmpty((String)name)) {
                this.builder.addSeparator(name, cc.xy(1, 1));
            }
            this.builder.add((Component)(this.scrollPane != null ? this.scrollPane : this.table), cc.xy(1, 2));
            this.builder.getPanel().setOpaque(false);
            this.add(this.builder.getPanel());
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(15, 2, 2, 2));
            this.setBorder(BorderFactory.createCompoundBorder(new CurvedBorder(new Color(160, 160, 160)), this.getBorder()));
            this.add((Component)(this.scrollPane != null ? this.scrollPane : this.table), "Center");
        }
    }

    public void setCommandAction(CommandAction commandAction, int colId) {
        this.cmdAction = commandAction;
        this.colId = colId;
    }

    protected CommandAction createCommandAction(Object colIdObj) {
        CommandAction commandAction = null;
        if (this.cmdAction != null) {
            try {
                Object cmdData;
                commandAction = (CommandAction)this.cmdAction.clone();
                if (colIdObj instanceof Integer && (Integer)colIdObj != -1) {
                    commandAction.setProperty("colid", colIdObj);
                }
                if ((cmdData = commandAction.getData()) instanceof Class) {
                    Class clazz = (Class)commandAction.getData();
                    DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByClassName(clazz.getName());
                    if (tblInfo != null) {
                        RecordSetIFace rs = RecordSetFactory.getInstance().createRecordSet();
                        rs.setName("");
                        rs.setDbTableId(tblInfo.getTableId());
                        rs.addItem((Integer)colIdObj);
                        commandAction.setData(rs);
                    } else {
                        commandAction = null;
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(StatGroupTable.class, ex);
                ex.printStackTrace();
            }
        }
        return commandAction;
    }

    public void reloadData() {
    }

    protected static StatDataItem getStatDataItem(JTable tableArg, int rowIndex) {
        TableModel tblModel;
        int rowInx = rowIndex;
        if (tableArg instanceof SortableJTable) {
            SortableJTable sTable = (SortableJTable)tableArg;
            SortableTableModel sortableModel = sTable.getSortableTableModel();
            rowInx = sortableModel.getDelegatedRow(rowInx);
            tblModel = sTable.getModel();
        } else {
            tblModel = tableArg.getModel();
        }
        return ((StatGroupTableModel)tblModel).getDataItem(rowInx);
    }

    public synchronized void relayout() {
        this.validate();
        this.doLayout();
        this.repaint();
    }

    public void addDataItem(StatDataItem item) {
        this.model.addDataItem(item);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.useSeparator) {
            Dimension dim = this.getSize();
            FontMetrics fm = g.getFontMetrics();
            int strW = fm.stringWidth(this.name);
            int x = (dim.width - strW) / 2;
            Insets ins = this.getBorder().getBorderInsets(this);
            int y = 2 + fm.getAscent();
            int lineW = dim.width - ins.left - ins.right;
            g.setColor(Color.BLUE.darker());
            g.drawString(this.name, x, y);
            x = ins.left;
            g.setColor(Color.LIGHT_GRAY.brighter());
            g.drawLine(x, y += fm.getDescent() + fm.getLeading(), x + lineW, y);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(++x, ++y, x + lineW, y);
        }
    }

    public void fireNewData() {
        StatGroupTable.calcColumnWidths(this.table);
    }

    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        int i = columns.getColumnCount() - 1;
        while (i >= 0) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = c.getPreferredSize().width;
            }
            int row = rowCount - 1;
            while (row >= 0) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width + 10);
                --row;
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
            --i;
        }
        Dimension size = table.getPreferredScrollableViewportSize();
        size.height = Math.min(size.height, table.getRowHeight() * visibleRows);
        size.width = totalWidth;
        table.setPreferredScrollableViewportSize(size);
    }

    class LinkListener
    extends MouseAdapter {
        LinkListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StatDataItem sdi;
            int rowInx;
            int colInx = StatGroupTable.this.table.columnAtPoint(e.getPoint());
            if (colInx > -1 && (rowInx = StatGroupTable.this.table.rowAtPoint(e.getPoint())) > -1 && (sdi = StatGroupTable.getStatDataItem(StatGroupTable.this.table, rowInx)) != null && sdi.getCmdAction() != null) {
                CommandDispatcher.dispatch(sdi.getCmdAction());
            }
        }
    }

    class StatGroupTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        protected int numCols;

        public StatGroupTableCellRenderer(int alignment, int numCols) {
            super("", alignment);
            this.numCols = numCols;
        }

        @Override
        public Component getTableCellRendererComponent(JTable renderTable, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            StatDataItem sdi = StatGroupTable.getStatDataItem(renderTable, rowIndex);
            if (sdi != null) {
                this.setIcon(null);
                this.setForeground(sdi.shouldShowLinkCursor() ? Color.BLUE : Color.BLACK);
                if (this.numCols == 1) {
                    Object val = sdi.getValue();
                    String valStr = val != null ? val.toString() : "";
                    this.setText(valStr);
                    this.setToolTipText(valStr);
                } else {
                    String desc = sdi.getDescription();
                    Object val = sdi.getValue();
                    String valStr = val != null ? val.toString() : "";
                    this.setText(vColIndex == 0 ? desc : valStr);
                    this.setToolTipText(String.valueOf(desc) + " " + valStr);
                }
            } else {
                this.setText(UIRegistry.getResourceString("NoneAvail"));
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    class TableMouseMotion
    extends MouseMotionAdapter {
        TableMouseMotion() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int colInx = StatGroupTable.this.table.columnAtPoint(e.getPoint());
            if (colInx > -1) {
                int rowInx = StatGroupTable.this.table.rowAtPoint(e.getPoint());
                if (rowInx > -1) {
                    StatDataItem sdi = StatGroupTable.getStatDataItem(StatGroupTable.this.table, rowInx);
                    StatGroupTable.this.table.setCursor(sdi != null && sdi.shouldShowLinkCursor() ? handCursor : defCursor);
                } else {
                    StatGroupTable.this.table.setCursor(defCursor);
                }
            } else {
                StatGroupTable.this.table.setCursor(defCursor);
            }
        }
    }
}

