/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryResultsContainer;
import edu.ku.brc.dbsupport.QueryResultsContainer;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.dbsupport.QueryResultsListener;
import edu.ku.brc.dbsupport.QueryResultsSerializedGetter;
import edu.ku.brc.stats.StatGroupTableModel;
import edu.ku.brc.ui.CommandAction;
import java.awt.Color;
import java.util.Vector;

public class StatDataItem
implements QueryResultsListener {
    protected String description;
    protected String sql;
    protected boolean useProgress = false;
    protected StatGroupTableModel model = null;
    protected CommandAction cmdAction = null;
    protected Object value = "...";
    protected boolean hasStarted = false;
    protected boolean hasData = false;
    protected Vector<QueryResultsContainerIFace> qrcs = new Vector();
    protected Vector<VALUE_TYPE> valuesType = new Vector();
    protected Color linkColor = Color.BLUE;
    protected Color defColor;

    public StatDataItem(String description, CommandAction cmdAction, boolean useProgress) {
        this.description = description;
        this.cmdAction = cmdAction;
        this.useProgress = useProgress;
    }

    public StatDataItem(String description, String type, String sql, CommandAction cmdAction, boolean useProgress, String formatStr) {
        this(description, cmdAction, useProgress);
        if (type.equals("sql")) {
            this.sql = sql;
            QueryResultsContainer qrc = new QueryResultsContainer(sql);
            qrc.add(new QueryResultsDataObj(1, 1, formatStr));
            this.qrcs.addElement(qrc);
        } else {
            CustomQueryResultsContainer qrc = new CustomQueryResultsContainer(sql);
            qrc.add(new QueryResultsDataObj(1, 1, formatStr));
            this.qrcs.addElement(qrc);
        }
        this.valuesType.addElement(VALUE_TYPE.Value);
        this.startUp();
    }

    public void addCustomQuery(String customQueryName, String formatStr) {
        CustomQueryResultsContainer qrc = new CustomQueryResultsContainer(customQueryName);
        qrc.add(new QueryResultsDataObj(1, 1, formatStr));
        this.valuesType.addElement(VALUE_TYPE.Value);
        this.qrcs.addElement(qrc);
    }

    public void addCustomQuery(CustomQueryIFace customQuery, String formatStr) {
        CustomQueryResultsContainer qrc = new CustomQueryResultsContainer(customQuery);
        qrc.add(new QueryResultsDataObj(1, 1, formatStr));
        this.valuesType.addElement(VALUE_TYPE.Value);
        this.qrcs.addElement(qrc);
    }

    public void clear() {
        this.qrcs.clear();
        this.qrcs = null;
        this.valuesType.clear();
        this.valuesType = null;
        this.model = null;
    }

    protected void setTableModel(StatGroupTableModel model) {
        this.model = model;
    }

    public QueryResultsContainer add(String sqlStr, String formatStr) {
        if (sqlStr == null) {
            throw new RuntimeException("sql is null for [" + this.description + "]");
        }
        QueryResultsContainer qrc = new QueryResultsContainer(sqlStr);
        qrc.add(new QueryResultsDataObj(1, 1, formatStr));
        this.valuesType.addElement(VALUE_TYPE.Ignore);
        this.qrcs.addElement(qrc);
        return qrc;
    }

    public QueryResultsContainer add(String sqlStr, int row, int col, VALUE_TYPE valType, String formatStr) {
        if (sqlStr == null) {
            throw new RuntimeException("sql is null for [" + this.description + "]");
        }
        QueryResultsContainer qrc = new QueryResultsContainer(sqlStr);
        qrc.add(new QueryResultsDataObj(row, col, formatStr));
        this.valuesType.addElement(valType);
        this.qrcs.addElement(qrc);
        return qrc;
    }

    public void add(QueryResultsContainer qrc, int row, int col, VALUE_TYPE valType, String formatStr) {
        qrc.add(new QueryResultsDataObj(row, col, formatStr));
    }

    public void startUp() {
        if (this.hasStarted) {
            throw new RuntimeException("The execution has already been started!");
        }
        this.hasStarted = true;
        this.hasData = false;
        QueryResultsSerializedGetter getter = new QueryResultsSerializedGetter(this);
        getter.add(this.qrcs);
    }

    public boolean shouldShowLinkCursor() {
        return this.cmdAction != null;
    }

    public CommandAction getCmdAction() {
        return this.cmdAction;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object valStr) {
        this.value = valStr;
    }

    public boolean isUseProgress() {
        return this.useProgress && !this.hasData;
    }

    @Override
    public synchronized void allResultsBack(QueryResultsContainerIFace qrcArg) {
        if (this.qrcs.size() != this.valuesType.size()) {
            throw new RuntimeException("There is an unequal number of QRCs and Value Types![" + this.description + "]");
        }
        Vector list = new Vector();
        int inx = 0;
        for (QueryResultsContainerIFace qrc : this.qrcs) {
            for (QueryResultsDataObj qrcdo : qrc.getQueryResultsDataObjs()) {
                Object dataObj = qrcdo.getResult();
                VALUE_TYPE valType = this.valuesType.elementAt(inx);
                if (dataObj == null && valType != VALUE_TYPE.Ignore) {
                    throw new RuntimeException("Null data that isn't Ignore");
                }
                if (valType == VALUE_TYPE.Description) {
                    this.description = dataObj != null ? dataObj.toString() : "";
                } else if (valType == VALUE_TYPE.Value) {
                    this.value = dataObj;
                }
                ++inx;
            }
            list.clear();
        }
        this.model.fireNewData();
        this.hasData = true;
    }

    @Override
    public void resultsInError(QueryResultsContainerIFace qrc) {
        this.value = "N/A";
        this.model.fireNewData();
        this.hasData = true;
    }

    public static enum VALUE_TYPE {
        Description,
        Value,
        Ignore;

    }
}

