/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import edu.ku.brc.dbsupport.QueryResultsContainer;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsGetter;
import edu.ku.brc.dbsupport.QueryResultsHandlerIFace;
import edu.ku.brc.dbsupport.QueryResultsListener;
import edu.ku.brc.dbsupport.QueryResultsProcessable;
import edu.ku.brc.stats.ChartPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChartPanel
extends ChartPanel
implements QueryResultsListener,
QueryResultsProcessable {
    private QueryResultsGetter getter = new QueryResultsGetter(this);
    private QueryResultsContainer qrContainer = new QueryResultsContainer("Pie Chart");
    private QueryResultsHandlerIFace handler = null;

    public PieChartPanel() {
        super(UIRegistry.getResourceString("BuildingPieChart"));
    }

    public Icon getIcon() {
        return IconManager.getIcon("Pie_Chart", IconManager.IconSize.Std16);
    }

    @Override
    public void setHandler(QueryResultsHandlerIFace handler) {
        this.handler = handler;
    }

    @Override
    public QueryResultsHandlerIFace getHandler() {
        return this.handler;
    }

    @Override
    public synchronized void allResultsBack(QueryResultsContainerIFace qrc) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        List<Object> list = this.handler.getDataObjects();
        int i = 0;
        while (i < list.size()) {
            Object descObj = list.get(i++);
            Object valObj = list.get(i);
            dataset.setValue((Comparable)((Object)UIHelper.getString(descObj)), (double)UIHelper.getInt(valObj));
            ++i;
        }
        list.clear();
        JFreeChart chart = ChartFactory.createPieChart((String)this.title, (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        this.chartPanel = new org.jfree.chart.ChartPanel(chart, true, true, true, true, true);
        this.removeAll();
        this.setLayout(new ChartPanel.ChartLayoutManager(this));
        this.add((Component)this.chartPanel);
        this.validate();
        this.doLayout();
        this.repaint();
        UIRegistry.forceTopFrameRepaint();
    }

    @Override
    public void resultsInError(QueryResultsContainerIFace qrc) {
    }
}

