/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.stats.Chartable;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ChartPanel
extends JPanel
implements Chartable {
    protected org.jfree.chart.ChartPanel chartPanel;
    protected String title = "";
    protected String xAxisTitle = "";
    protected String yAxisTitle = "";
    protected boolean isVertical = true;
    protected JProgressBar progressBar;
    protected JLabel progressLabel;
    private Dimension maxChartSize = new Dimension(100, 100);

    public ChartPanel(String startUpMsg) {
        this.progressBar = UIHelper.createProgressBar();
        this.progressBar.setIndeterminate(true);
        PanelBuilder builder = new PanelBuilder(new FormLayout("max(100px;p):g", "center:p:g, center:p:g"));
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.progressBar, cc.xy(1, 1));
        this.progressLabel = UIHelper.createLabel(startUpMsg, 0);
        builder.add((Component)this.progressLabel, cc.xy(1, 2));
        PanelBuilder builder2 = new PanelBuilder(new FormLayout("p:g,p,p:g", "p:g,p,p:g"), (JPanel)this);
        builder2.add((Component)builder.getPanel(), cc.xy(2, 2));
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setXAxis(String title) {
        this.xAxisTitle = title;
    }

    @Override
    public void setYAxis(String title) {
        this.yAxisTitle = title;
    }

    @Override
    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public void setPreferredChartSize(int width, int height) {
        this.maxChartSize.setSize(width, height);
    }

    public class ChartLayoutManager
    implements LayoutManager,
    LayoutManager2 {
        protected ChartPanel parentChartPanel;
        protected org.jfree.chart.ChartPanel freeChartPanel;
        protected Dimension preferredSize = new Dimension(100, 100);

        public ChartLayoutManager(ChartPanel parentChartPanel) {
            this.parentChartPanel = parentChartPanel;
        }

        @Override
        public void addLayoutComponent(String arg0, Component arg1) {
            if (arg1 == null || !(arg1 instanceof org.jfree.chart.ChartPanel)) {
                throw new NullPointerException("Null component in addLayoutComponent");
            }
            this.freeChartPanel = (org.jfree.chart.ChartPanel)arg1;
        }

        @Override
        public void removeLayoutComponent(Component arg0) {
            if (arg0 == null || !(arg0 instanceof org.jfree.chart.ChartPanel)) {
                throw new NullPointerException("Null component in addLayoutComponent");
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return this.parentChartPanel.maxChartSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container arg0) {
            return this.parentChartPanel.maxChartSize;
        }

        @Override
        public void layoutContainer(Container arg0) {
            Dimension parentSize = arg0.getSize();
            this.freeChartPanel.setBounds(0, 0, parentSize.width, parentSize.height - 5);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (comp == null || !(comp instanceof org.jfree.chart.ChartPanel)) {
                throw new NullPointerException("Null component in addLayoutComponent");
            }
            this.freeChartPanel = (org.jfree.chart.ChartPanel)comp;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.preferredSize.setSize(100, 100);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(this.preferredSize);
        }
    }
}

