/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.stats;

import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsHandlerIFace;
import edu.ku.brc.dbsupport.QueryResultsListener;
import edu.ku.brc.dbsupport.QueryResultsProcessable;
import edu.ku.brc.stats.ChartPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChartPanel
extends ChartPanel
implements QueryResultsListener,
QueryResultsProcessable {
    private QueryResultsHandlerIFace handler = null;

    public BarChartPanel() {
        super(UIRegistry.getResourceString("BuildingBarChart"));
        this.setBorder(null);
    }

    public Icon getIcon() {
        return IconManager.getIcon("Bar_Chart", IconManager.IconSize.Std16);
    }

    @Override
    public void setHandler(QueryResultsHandlerIFace handler) {
        this.handler = handler;
    }

    @Override
    public QueryResultsHandlerIFace getHandler() {
        return this.handler;
    }

    protected void addCompletedComp(JComponent comp) {
        this.removeAll();
        this.add((Component)comp, "Center");
        if (this.handler != null) {
            this.handler.cleanUp();
            this.handler = null;
        }
        UIRegistry.forceTopFrameRepaint();
    }

    @Override
    public synchronized void allResultsBack(QueryResultsContainerIFace qrc) {
        String cat = "";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List<Object> list = this.handler.getDataObjects();
        int i = 0;
        while (i < list.size()) {
            Object descObj = list.get(i++);
            Object valObj = list.get(i);
            if (descObj != null && valObj != null) {
                dataset.addValue((double)UIHelper.getInt(valObj), (Comparable)((Object)UIHelper.getString(descObj)), (Comparable)((Object)cat));
            }
            ++i;
        }
        list.clear();
        JFreeChart jgChart = ChartFactory.createBarChart3D((String)this.title, (String)this.xAxisTitle, (String)this.yAxisTitle, (CategoryDataset)dataset, (PlotOrientation)(this.isVertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL), (boolean)true, (boolean)true, (boolean)false);
        this.chartPanel = new org.jfree.chart.ChartPanel(jgChart, true, true, true, true, true);
        this.removeAll();
        this.setLayout(new ChartPanel.ChartLayoutManager(this, this));
        this.add((Component)this.chartPanel);
        this.validate();
        this.doLayout();
        this.repaint();
        UIRegistry.forceTopFrameRepaint();
    }

    @Override
    public void resultsInError(QueryResultsContainerIFace qrc) {
        JLabel label = UIHelper.createLabel(UIRegistry.getResourceString("ERROR_CREATNG_BARCHART"), 0);
        this.addCompletedComp(label);
    }
}

