/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.web;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.af.ui.forms.DataObjectGettable;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.SpQuery;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.tasks.ExpressSearchTask;
import edu.ku.brc.specify.tasks.QueryTask;
import edu.ku.brc.specify.tasks.subpane.qb.QueryBldrPane;
import edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr;
import edu.ku.brc.specify.web.AdditionalDisplayField;
import edu.ku.brc.specify.web.ClassDisplayInfo;
import edu.ku.brc.specify.web.ExplorerESPanel;
import edu.ku.brc.specify.web.FieldDisplayInfo;
import edu.ku.brc.specify.web.JasperReportHelper;
import edu.ku.brc.specify.web.QueryReportHandler;
import edu.ku.brc.specify.web.StatsDisplayInfo;
import edu.ku.brc.specify.web.TitleGetterIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class SpecifyExplorer
extends HttpServlet {
    private final Logger log = Logger.getLogger(SpecifyExplorer.class);
    private Hashtable<Class<?>, Boolean> baseClassHash = new Hashtable();
    protected String DATABASE_NAME = "db";
    public static String contentTag = "<!-- Content -->";
    public static String servletURL = "http://localhost:8080/specify/SpecifyExplorer";
    public static String baseURLSite = "http://localhost:8080/specify";
    protected String packageName = "edu.ku.brc.specify.datamodel.";
    protected static MyFmtMgr fmtMgr = null;
    protected SimpleDateFormat dateFormatter;
    protected static String template = "";
    protected static int contentTagIndex = -1;
    protected Hashtable<String, ClassDisplayInfo> classHash = new Hashtable();
    protected Vector<ClassDisplayInfo> sortedClassList = new Vector();
    protected Hashtable<String, String> labelMap = new Hashtable();
    protected DataGetterForObj getter = new DataGetterForObj();
    protected QueryTask queryTask = null;
    protected ExpressSearchTask expressSearch = null;
    protected ExplorerESPanel expressSearchExplorer = null;
    protected QueryReportHandler queryHandler;

    public SpecifyExplorer() {
        Class[] baseClasses;
        System.out.println(new File(".").getAbsolutePath());
        UIRegistry.setDefaultWorkingPath(new File("/Users/rods/workspace/Specify/webapp/WEB-INF").getAbsolutePath());
        System.out.println("[" + UIRegistry.getDefaultWorkingPath() + "]");
        File dir = new File("site");
        if (!dir.exists()) {
            dir.mkdir();
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith("html") && !f.getName().startsWith("template")) {
                f.delete();
            }
            ++n2;
        }
        this.dateFormatter = new SimpleDateFormat("yyyy/MM/dd");
        try {
            File templateFile = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "site/template.html");
            template = FileUtils.readFileToString((File)templateFile);
            contentTagIndex = template.indexOf(contentTag);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Class[] classArray = baseClasses = new Class[]{Boolean.class, Integer.class, Double.class, String.class, Float.class, Character.class, Short.class, Byte.class, BigDecimal.class, Date.class, Calendar.class};
        int n3 = baseClasses.length;
        n = 0;
        while (n < n3) {
            Class cls = classArray[n];
            this.baseClassHash.put(cls, true);
            ++n;
        }
        this.loadFieldsToSkip();
        this.setUp();
        this.setUpClasses();
    }

    public static void writeTitle(PrintWriter out, String title) {
        String subContent = template.substring(0, contentTagIndex);
        out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)title));
    }

    public static void writeToEnd(PrintWriter out) {
        out.println(template.substring(contentTagIndex + contentTag.length() + 1, template.length()));
    }

    protected Class<?> getClassForField(Class<?> dataCls, String fieldName) {
        if (StringUtils.isNotEmpty((String)fieldName)) {
            Field[] fieldArray = dataCls.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(fieldName)) {
                    return field.getType();
                }
                ++n2;
            }
        }
        return null;
    }

    protected void loadFieldsToSkip() {
        ClassDisplayInfo.setPackageName(this.packageName);
        try {
            Element root = XMLHelper.readFileToDOM4J(new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "config/ClassDisplayInfo.xml"));
            for (Object cls : root.selectNodes("/classes/class")) {
                Element clsElement = (Element)cls;
                String clsName = XMLHelper.getAttr(clsElement, "name", null);
                if (!StringUtils.isNotEmpty((String)clsName)) continue;
                ClassDisplayInfo cdi = null;
                String linkField = XMLHelper.getAttr(clsElement, "linkfield", "");
                String indexField = XMLHelper.getAttr(clsElement, "indexfield", "");
                boolean useIdent = XMLHelper.getAttr(clsElement, "useindentity", false);
                try {
                    String fullName = String.valueOf(this.packageName) + clsName;
                    Class<?> clsObj = Class.forName(fullName);
                    Class<?> indexClass = this.getClassForField(clsObj, indexField);
                    cdi = new ClassDisplayInfo(clsName, clsObj, indexField, indexClass, linkField, useIdent);
                    this.classHash.put(clsName, cdi);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                Element titleEl = (Element)clsElement.selectSingleNode("title");
                if (titleEl != null) {
                    String getterStr = XMLHelper.getAttr(titleEl, "getter", null);
                    if (getterStr != null) {
                        try {
                            Class<?> getterCls = Class.forName(getterStr);
                            TitleGetterIFace titleGetter = (TitleGetterIFace)getterCls.newInstance();
                            cdi.setTitleGetter(titleGetter);
                        }
                        catch (Exception getterCls) {}
                    } else {
                        cdi.setTitleField(XMLHelper.getAttr(titleEl, "field", null));
                    }
                }
                for (Object fld : clsElement.selectNodes("skip/field")) {
                    Element fldElement = (Element)fld;
                    boolean isAvailForSearch = XMLHelper.getAttr(fldElement, "search", false);
                    cdi.addSkipped(new FieldDisplayInfo(fldElement.getTextTrim(), false, isAvailForSearch));
                }
                int inx = 0;
                for (Object fld : clsElement.selectNodes("order/field")) {
                    Element fldElement = (Element)fld;
                    String pickList = XMLHelper.getAttr(clsElement, "pl", "");
                    boolean isForDisplay = XMLHelper.getAttr(fldElement, "display", true);
                    cdi.addOrdered(new FieldDisplayInfo(inx, fldElement.getTextTrim(), pickList, isForDisplay, true));
                    ++inx;
                }
                for (Object fld : clsElement.selectNodes("additional/field")) {
                    Element fldElement = (Element)fld;
                    String name = fldElement.getTextTrim();
                    String type = XMLHelper.getAttr(fldElement, "type", "");
                    String label = XMLHelper.getAttr(fldElement, "label", "");
                    String level = XMLHelper.getAttr(fldElement, "labellevel", "");
                    AdditionalDisplayField adf = new AdditionalDisplayField(inx, type, label, level, name);
                    cdi.addAdditional(adf);
                    ++inx;
                }
                for (Object st : clsElement.selectNodes("stats/stat")) {
                    Element statElement = (Element)st;
                    String url = XMLHelper.getAttr(statElement, "url", null);
                    if (!StringUtils.isNotEmpty((String)url)) continue;
                    cdi.addStat(new StatsDisplayInfo(url, statElement.getTextTrim()));
                }
            }
            this.sortedClassList = new Vector<ClassDisplayInfo>(this.classHash.values());
            Collections.sort(this.sortedClassList);
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            System.out.println(ex.toString());
        }
    }

    protected void setUpSystemProperties() {
        System.setProperty("edu.ku.brc.af.ui.forms.ViewFactory", "edu.ku.brc.specify.config.SpecifyViewFactory");
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
        System.setProperty("RecordSetFactory", "edu.ku.brc.specify.config.SpecifyRecordSetFactory");
        System.setProperty("edu.ku.brc.dbsupport.DBTableIdMgr", "edu.ku.brc.specify.config.SpecifyDBTableIdMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty("edu.ku.brc.af.core.db.BackupServiceFactory", "edu.ku.brc.af.core.db.MySQLBackupService");
        System.setProperty("edu.ku.brc.exceptions.ExceptionTracker", "edu.ku.brc.specify.web.SpecifyExplorerExceptionTracker");
    }

    protected Collection setupCurrentCollection(DataProviderSessionIFace sessionArg, SpecifyUser user, String collectionName) {
        UIFieldFormatterMgr.setDoingLocal(true);
        DataObjFieldFormatMgr.setDoingLocal(true);
        DataObjFieldFormatMgr.getInstance().setLocalFileName(XMLHelper.getConfigDirPath(DataObjFieldFormatMgr.getInstance().getLocalFileName()));
        try {
            Collection collection = null;
            Hashtable<String, Collection> collectionHash = new Hashtable<String, Collection>();
            String sqlStr = "SELECT cs From Discipline as ct Inner Join ct.agents cta Inner Join cta.specifyUser as user Inner Join ct.collections as cs where user.specifyUserId = " + user.getSpecifyUserId();
            for (Object obj : sessionArg.getDataList(sqlStr)) {
                Collection cs = (Collection)obj;
                collectionHash.put(cs.getCollectionName(), cs);
                if (!cs.getCollectionName().equals(collectionName)) continue;
                collection = cs;
            }
            AppContextMgr.getInstance().setClassObject(Collection.class, collection);
            if (collection != null) {
                Discipline discipline = collection.getDiscipline();
                if (discipline != null) {
                    Institution institution = discipline.getDivision().getInstitution();
                    AppContextMgr.getInstance().setClassObject(Discipline.class, discipline);
                    AppContextMgr.getInstance().setClassObject(Division.class, discipline.getDivision());
                    AppContextMgr.getInstance().setClassObject(Institution.class, institution);
                    Agent.setUserAgent(user, discipline.getDivision());
                    AppContextMgr am = AppContextMgr.getInstance();
                    am.setClassObject(TaxonTreeDef.class, discipline.getTaxonTreeDef());
                    am.setClassObject(GeologicTimePeriodTreeDef.class, discipline.getGeologicTimePeriodTreeDef());
                    am.setClassObject(StorageTreeDef.class, institution.getStorageTreeDef());
                    am.setClassObject(LithoStratTreeDef.class, discipline.getLithoStratTreeDef());
                    am.setClassObject(GeographyTreeDef.class, discipline.getGeographyTreeDef());
                    int disciplineeId = discipline.getDisciplineId();
                    SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, disciplineeId, DBTableIdMgr.getInstance(), Locale.getDefault());
                }
            } else {
                UIRegistry.showLocalizedError("COLLECTION_WAS_NULL");
            }
            return collection;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UIRegistry.showLocalizedError(ex.toString());
            return null;
        }
    }

    public boolean setupDatabase(DatabaseDriverInfo driverInfo, String hostName, String dbName, String username, String password, String firstName, String lastName, String email, DisciplineType disciplineType) {
        this.log.info((Object)("Logging into " + dbName + "...."));
        String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, hostName, dbName);
        this.log.info((Object)connStr);
        if (!UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, username, password)) {
            this.log.info((Object)"Login Failed!");
            throw new RuntimeException("Login failed.");
        }
        this.queryHandler = new QueryReportHandler();
        this.log.info((Object)("Creating database " + dbName + "...."));
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        AppContextMgr.CONTEXT_STATUS status = AppContextMgr.getInstance().setContext(this.DATABASE_NAME, "testuser", false, true, false);
        if (status == AppContextMgr.CONTEXT_STATUS.OK) {
            if (AppContextMgr.getInstance().getClassObject(Discipline.class) != null) {
                int disciplineeId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
                SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.CORE_SCHEMA, disciplineeId, DBTableIdMgr.getInstance(), Locale.getDefault());
            }
        } else {
            throw new RuntimeException("setContext was NOT OK!");
        }
        localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        SpecifyAppPrefs.initialPrefs();
        fmtMgr = new MyFmtMgr();
        return true;
    }

    public void setUp() {
        UIRegistry.setAppName("Specify");
        IconManager.setApplicationClass(Specify.class);
        this.setUpSystemProperties();
        DisciplineType disciplineType = DisciplineType.getDiscipline("fish");
        DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
        this.setupDatabase(driverInfo, "localhost", this.DATABASE_NAME, "rods", "rods", "rods", "rods", "guest@ku.edu", disciplineType);
    }

    public void setUpClasses() {
    }

    protected Object getData(String fieldName, Object dataObj) throws Exception {
        Object data = this.getter.getFieldValue(dataObj, fieldName);
        if (data instanceof Boolean) {
            return (Boolean)data != false ? "Yes" : "No";
        }
        return data;
    }

    protected Object getData(Field field, Object dataObj) throws Exception {
        return this.getData(field.getName(), dataObj);
    }

    protected String formatFDI(FormDataObjIFace fdi) {
        DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(fdi.getDataClass().getName());
        if (StringUtils.isNotEmpty((String)ti.getDataObjFormatter())) {
            String title = DataObjFieldFormatMgr.getInstance().format((Object)fdi, ti.getDataObjFormatter());
            this.formatFDI(fdi, title);
        }
        return this.formatFDI(fdi, fdi.getIdentityTitle());
    }

    protected String makeURLLink(FormDataObjIFace fdi, String title, Properties props) {
        boolean needsAmp;
        StringBuffer sb = new StringBuffer("<a href=\"" + servletURL + "?");
        if (fdi != null) {
            sb.append("cls=");
            sb.append(fdi.getDataClass().getSimpleName());
            sb.append("&id=");
            sb.append(fdi.getId());
        }
        boolean bl = needsAmp = fdi != null;
        if (props != null) {
            for (Object key : props.keySet()) {
                if (!needsAmp) {
                    needsAmp = true;
                } else {
                    sb.append('&');
                }
                sb.append(key.toString());
                sb.append('=');
                sb.append(props.get(key));
            }
        }
        sb.append("\">");
        sb.append(title);
        sb.append("</a>");
        return sb.toString();
    }

    protected String makeURLLink(FormDataObjIFace fdi, String title) {
        return this.makeURLLink(fdi, title, null);
    }

    protected String formatFDI(FormDataObjIFace fdi, String title) {
        if (this.classHash.get(fdi.getDataClass().getSimpleName()) != null) {
            return this.makeURLLink(fdi, title);
        }
        System.out.println(">>>>>>>>>>>>>>> class not in hash[" + fdi.getDataClass().getSimpleName() + "]");
        return fdi.getIdentityTitle();
    }

    protected String formatValue(Object data) {
        if (data instanceof FormDataObjIFace) {
            return this.formatFDI((FormDataObjIFace)data);
        }
        if (data instanceof String || data instanceof Integer) {
            return data.toString();
        }
        if (data instanceof Date) {
            return this.dateFormatter.format((Date)data);
        }
        if (data instanceof Calendar) {
            return this.dateFormatter.format(((Calendar)data).getTime());
        }
        if (data instanceof Float) {
            return String.format("%5.2f", data);
        }
        if (data instanceof Double) {
            return String.format("%5.2f", data);
        }
        if (data instanceof BigDecimal) {
            return StringUtils.stripEnd((String)data.toString(), (String)"0");
        }
        return data.toString();
    }

    protected String processDataObjAsSet(DBTableInfo tableInfo, DBTableChildIFace childInfo, String fieldName, Vector<?> dataObjSet) {
        String labelStr;
        String string = labelStr = childInfo != null ? childInfo.getTitle() : null;
        if (labelStr == null && StringUtils.isEmpty((String)(labelStr = this.labelMap.get(fieldName)))) {
            labelStr = UIHelper.makeNamePretty(fieldName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<br/>" + labelStr + "<br/>\n");
        sb.append("<table width=\"100%\" cellspacing=\"0\" class=\"brdr\">\n");
        int cnt = 1;
        for (Object setDataObj : dataObjSet) {
            String fdiStr = this.formatFDI((FormDataObjIFace)setDataObj);
            sb.append("<tr><td class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\">" + fdiStr + "</td></tr>\n");
            ++cnt;
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    protected void valueTraversal(Object dataObj, String[] fieldNames, int index, boolean doEvenOdd, StringBuilder sb, int cntArg, AdditionalDisplayField af) {
        Object[] values;
        Object data;
        boolean isLabelLevel = false;
        boolean isLabelSet = false;
        boolean isEnd = index == fieldNames.length - 1;
        String labelStr = "";
        if (af.getLevel().equals(fieldNames[index])) {
            isLabelLevel = true;
            if (af.isSet()) {
                isLabelSet = true;
                labelStr = af.getLabel();
            } else {
                this.labelMap.get(fieldNames[index]);
                if (StringUtils.isEmpty((String)labelStr)) {
                    labelStr = UIHelper.makeNamePretty(fieldNames[index]);
                }
            }
            if (isLabelSet && isLabelLevel) {
                sb.append("<br/>" + labelStr + "<br/>\n");
                sb.append("<table width=\"100%\" cellspacing=\"0\" class=\"brdr\">\n");
            }
        }
        if ((data = (values = UIHelper.getFieldValues(new String[]{fieldNames[index]}, dataObj, (DataObjectGettable)this.getter))[0]) instanceof Set) {
            int cnt = 1;
            for (Object obj : (Set)data) {
                if (obj instanceof FormDataObjIFace && !isEnd) {
                    this.valueTraversal(obj, fieldNames, index + 1, true, sb, cnt, af);
                    continue;
                }
                sb.append("<tr><td class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\">" + this.formatValue(obj) + "</td></tr>\n");
            }
        } else if (data instanceof FormDataObjIFace && !isEnd) {
            this.valueTraversal(data, fieldNames, index + 1, false, sb, 0, af);
        } else if (isLabelSet || doEvenOdd) {
            sb.append("<tr><td class=\"brdr" + (cntArg % 2 == 0 ? "even" : "odd") + "\">" + this.formatValue(data) + "</td></tr>\n");
        } else {
            sb.append("<tr><td align=\"right\">" + labelStr + ":</td><td >" + this.formatValue(data) + "</td></tr>\n");
        }
        if (isLabelSet && isLabelLevel) {
            sb.append("</table>\n");
        }
    }

    protected void processDataObj(PrintWriter out, FormDataObjIFace dataObj, boolean doChildrenSets) {
        if (StringUtils.isEmpty((String)template)) {
            out.println("The template file is empty!");
        }
        this.fillLabelMap(dataObj, this.labelMap);
        Hashtable<Integer, String> ordered = new Hashtable<Integer, String>();
        Vector<String> unOrdered = new Vector<String>();
        Hashtable<Integer, String> orderedSets = new Hashtable<Integer, String>();
        Vector<String> unOrderedSets = new Vector<String>();
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByClassName(dataObj.getClass().getName());
        ClassDisplayInfo cdi = this.classHash.get(dataObj.getClass().getSimpleName());
        try {
            Object titleObj;
            Object[] fNames;
            String fldNameLower;
            FieldDisplayInfo fdi;
            String fieldName;
            Field field;
            Field[] fieldArray = dataObj.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                block41: {
                    DBTableChildIFace child;
                    block43: {
                        block42: {
                            field = fieldArray[n2];
                            fieldName = field.getName();
                            fdi = cdi.getField(fieldName);
                            if (fdi != null && (fdi.isSkipped() || !fdi.isForDisplay()) || (fldNameLower = fieldName.toLowerCase()).startsWith(dataObj.getClass().getSimpleName().toLowerCase()) && fldNameLower.endsWith("id")) break block41;
                            child = tableInfo.getItemByName(fieldName);
                            if (child == null) break block42;
                            if (!child.isHidden()) break block43;
                            break block41;
                        }
                        System.out.println("******* " + tableInfo.getTitle() + "  [" + fieldName + "]");
                    }
                    String row = null;
                    try {
                        Object data = this.getData(field, (Object)dataObj);
                        if (data != null && !(data instanceof Set)) {
                            String valueStr = null;
                            String labelStr = "";
                            if (child != null) {
                                Object valObj;
                                DBFieldInfo fi;
                                labelStr = child.getTitle();
                                if (child instanceof DBFieldInfo && (fi = (DBFieldInfo)child).getFormatter() != null && (valObj = fi.getFormatter().formatToUI(data)) != null) {
                                    valueStr = valObj.toString();
                                }
                            } else {
                                labelStr = this.labelMap.get(fieldName);
                            }
                            if (StringUtils.isEmpty((String)labelStr)) {
                                labelStr = UIHelper.makeNamePretty(fieldName);
                            }
                            if (valueStr == null) {
                                valueStr = this.formatValue(data);
                            }
                            String nowrap = valueStr.length() < 100 ? "nowrap=\"nowrap\" " : "";
                            row = "<tr><td valign=align=\"right\" nowrap=\"nowrap\"><b>" + labelStr + ":</b></td><td " + nowrap + "class=\"data\">" + valueStr + "</td></tr>\n";
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (row != null) {
                        Integer inx;
                        Integer n3 = inx = fdi != null ? fdi.getOrder() : null;
                        if (inx == null) {
                            unOrdered.add(row);
                        } else {
                            ordered.put(inx, row);
                        }
                    }
                }
                ++n2;
            }
            for (AdditionalDisplayField adf : cdi.getAdditional()) {
                if (adf.isSet()) continue;
                StringBuilder sb = new StringBuilder();
                fNames = StringUtils.split((String)adf.getFieldName(), (String)".");
                this.valueTraversal(dataObj, (String[])fNames, 0, false, sb, 0, adf);
                unOrdered.add(sb.toString());
            }
            if (doChildrenSets) {
                fNames = dataObj.getClass().getDeclaredFields();
                int sb = fNames.length;
                int n4 = 0;
                while (n4 < sb) {
                    block40: {
                        field = fNames[n4];
                        fieldName = field.getName();
                        fdi = cdi.getField(fieldName);
                        if (!(fdi != null && (fdi.isSkipped() || !fdi.isForDisplay()) || (fldNameLower = fieldName.toLowerCase()).startsWith(dataObj.getClass().getSimpleName().toLowerCase()) && fldNameLower.endsWith("id"))) {
                            String row;
                            block39: {
                                row = null;
                                try {
                                    Set set;
                                    Object data = this.getData(field, (Object)dataObj);
                                    if (data == null || !(data instanceof Set) || (set = (Set)data).size() <= 0) break block39;
                                    DBTableChildIFace childInfo = tableInfo.getItemByName(fieldName);
                                    if (childInfo != null && childInfo.isHidden()) break block40;
                                    Vector setAsList = null;
                                    if (fieldName.equals("collectionObjects")) {
                                        StringBuilder sb2 = new StringBuilder();
                                        this.getCollectionObjectList(set, sb2);
                                        row = sb2.toString();
                                    } else if (fieldName.equals("determinations")) {
                                        Vector<Determination> dets = new Vector<Determination>();
                                        Object[] objectArray = set.toArray();
                                        int n5 = objectArray.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            Object obj = objectArray[n6];
                                            dets.add((Determination)obj);
                                            ++n6;
                                        }
                                        Collections.sort(dets, new Comparator<Determination>(){

                                            @Override
                                            public int compare(Determination d1, Determination d2) {
                                                return d1.compareTo(d2);
                                            }
                                        });
                                        setAsList = dets;
                                    } else {
                                        setAsList = new Vector(set);
                                    }
                                    if (setAsList != null) {
                                        row = this.processDataObjAsSet(tableInfo, childInfo, fieldName, setAsList);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (row != null) {
                                Integer inx;
                                Integer n7 = inx = fdi != null ? fdi.getOrder() : null;
                                if (inx == null) {
                                    unOrderedSets.add(row);
                                } else {
                                    orderedSets.put(inx, row);
                                }
                            }
                        }
                    }
                    ++n4;
                }
                for (AdditionalDisplayField adf : cdi.getAdditional()) {
                    if (!adf.isSet()) continue;
                    StringBuilder sb3 = new StringBuilder();
                    if (dataObj instanceof Taxon && adf.getFieldName().equals("determinations.collectionObject")) {
                        this.getCollectionObjectList(dataObj, sb3);
                    } else {
                        fNames = StringUtils.split((String)adf.getFieldName(), (String)".");
                        this.valueTraversal(dataObj, (String[])fNames, 0, false, sb3, 0, adf);
                    }
                    unOrderedSets.add(sb3.toString());
                }
            }
            String pageTitle = null;
            if (cdi.getTitleGetter() != null) {
                pageTitle = cdi.getTitleGetter().getTitle(dataObj);
            } else if (cdi.getTitleField() != null && (titleObj = this.getData(cdi.getTitleField(), (Object)dataObj)) != null) {
                pageTitle = titleObj instanceof Date ? this.dateFormatter.format((Date)titleObj) : (titleObj instanceof Calendar ? this.dateFormatter.format(((Calendar)titleObj).getTime()) : titleObj.toString());
            }
            int inx = template.indexOf(contentTag);
            String subContent = template.substring(0, inx);
            out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)tableInfo.getTitle()));
            out.println("<table border=\"0\">\n");
            out.println("<tr><td>\n");
            out.println("<tr><td class=\"title\" colspan=\"2\" align=\"center\">" + tableInfo.getTitle() + "</td></tr>\n");
            out.println("<tr><td valign=\"top\">\n");
            out.println("<table border=\"0\">\n");
            if (StringUtils.isNotEmpty((String)pageTitle)) {
                out.println("<tr><td nowrap=\"nowrap\" class=\"pageTitle\" colspan=\"2\" align=\"center\">" + pageTitle + "</td></tr>\n");
            }
            this.fillRows(out, ordered, unOrdered);
            out.println("</table>\n");
            out.println("</td>\n");
            out.println("<td valign=\"top\">\n");
            String imgName = this.fakeGetImageName(dataObj);
            if (imgName != null) {
                out.println("<img border=\"1\" src=\"http://localhost/specifyexplorer/AttachImageCache/" + imgName + "\">\n");
            }
            out.println("</td>\n");
            out.println("</tr>\n");
            out.println("</table>\n");
            this.fillRows(out, orderedSets, unOrderedSets);
            if (dataObj.getClass() == Locality.class || dataObj.getClass() == CollectingEvent.class || dataObj.getClass() == CollectionObject.class || dataObj.getClass() == Taxon.class || dataObj.getClass() == Accession.class) {
                Vector<FormDataObjIFace> list = new Vector<FormDataObjIFace>();
                list.add(dataObj);
                this.createMapLink(out, list, dataObj.getClass());
            }
            out.println(template.substring(inx + contentTag.length() + 1, template.length()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.toString());
            out.println("Sorry");
        }
    }

    protected void getCollectionObjectList(Object dataObj, StringBuilder sb) {
        Vector<CollectionObject> list = new Vector<CollectionObject>();
        if (dataObj instanceof Accession) {
            for (CollectionObject co : ((Accession)dataObj).getCollectionObjects()) {
                list.add(co);
            }
        } else if (dataObj instanceof Set) {
            for (CollectionObject co : (Set)dataObj) {
                list.add(co);
            }
        } else if (dataObj instanceof Taxon) {
            for (Determination det : ((Taxon)dataObj).getDeterminations()) {
                if (!det.isCurrentDet()) continue;
                list.add(det.getCollectionObject());
            }
        }
        Collections.sort(list, new Comparator<CollectionObject>(){

            @Override
            public int compare(CollectionObject o1, CollectionObject o2) {
                String c1 = o1.getCatalogNumber();
                String c2 = o2.getCatalogNumber();
                if (c1 == null) {
                    c1 = "";
                }
                if (c2 == null) {
                    c2 = "";
                }
                return c1.compareTo(c2);
            }
        });
        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoById(CollectionObject.getClassTableId());
        DBFieldInfo fi = ti.getFieldByName("catalogNumber");
        UIFieldFormatterIFace fmtr = fi.getFormatter();
        sb.append("<br/>Collection Objects<br/>\n");
        sb.append("<table width=\"100%\" cellspacing=\"0\" class=\"brdr\">\n");
        sb.append("<tr><td class=\"brdreven\">");
        int cnt = 0;
        for (CollectionObject co : list) {
            String catNum = co.getCatalogNumber();
            if (fmtr != null) {
                catNum = (String)fmtr.formatToUI(catNum);
            }
            if (cnt > 0) {
                sb.append(", ");
            }
            sb.append(this.formatFDI(co, catNum));
            ++cnt;
        }
        sb.append("</td></tr></table>\n");
    }

    protected void processDataList(PrintWriter out, List<?> list, String sql) {
        if (StringUtils.isEmpty((String)template)) {
            out.println("The template file is empty!");
        }
        FormDataObjIFace dataObj = (FormDataObjIFace)list.get(0);
        String linkField = "";
        ClassDisplayInfo cdi = this.classHash.get(dataObj.getClass().getSimpleName());
        if (cdi != null) {
            linkField = cdi.getLinkField();
        }
        int contentInx = template.indexOf(contentTag);
        String subContent = template.substring(0, contentInx);
        out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)dataObj.getIdentityTitle()));
        Hashtable<Integer, String> ordered = new Hashtable<Integer, String>();
        Vector<String> unOrdered = new Vector<String>();
        Hashtable<String, Boolean> hasData = new Hashtable<String, Boolean>();
        out.println("<table border=\"0\" width=\"100%\"<tr><td nowrap=\"nowrap\">select * " + StringUtils.replace((String)sql, (String)this.packageName, (String)"") + "</td></tr>");
        out.println("<tr><td nowrap=\"nowrap\">Records Returned: " + list.size() + "</td></tr></table><br/>");
        out.println("<table width=\"100%\" cellspacing=\"0\" class=\"brdr\">\n");
        try {
            int n;
            for (Object dobj : list) {
                dataObj = (FormDataObjIFace)dobj;
                Field[] fieldArray = dataObj.getClass().getDeclaredFields();
                n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fldNameLower;
                    Field field = fieldArray[n2];
                    String fieldName = field.getName();
                    FieldDisplayInfo fdi = cdi.getField(fieldName);
                    if (!(fdi != null && (fdi.isSkipped() || !fdi.isForDisplay()) || (fldNameLower = fieldName.toLowerCase()).startsWith(dataObj.getClass().getSimpleName().toLowerCase()) && fldNameLower.endsWith("id"))) {
                        try {
                            Object data = this.getData(field, (Object)dataObj);
                            if (data != null && !(data instanceof Set)) {
                                hasData.put(fieldName, true);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            out.println("<tr><th class=\"brdr\">Row</th>");
            Field[] fieldArray = dataObj.getClass().getDeclaredFields();
            int n3 = fieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Field field = fieldArray[n4];
                String fieldName = field.getName();
                if (hasData.get(fieldName) != null) {
                    Integer inx;
                    FieldDisplayInfo fdi = cdi.getField(fieldName);
                    String labelStr = this.labelMap.get(fieldName);
                    if (StringUtils.isEmpty((String)labelStr)) {
                        labelStr = UIHelper.makeNamePretty(fieldName);
                    }
                    String row = "<th class=\"brdr\">" + labelStr + "</th>";
                    Integer n5 = inx = fdi != null ? fdi.getOrder() : null;
                    if (inx == null) {
                        unOrdered.add(row);
                    } else {
                        ordered.put(inx, row);
                    }
                }
                ++n4;
            }
            this.fillRows(out, ordered, unOrdered);
            out.println("</tr>");
            int cnt = 1;
            for (Object dobj : list) {
                ordered.clear();
                unOrdered.clear();
                out.println("<tr><th class=\"brdr\" align=\"center\">" + cnt + "</th>");
                dataObj = (FormDataObjIFace)dobj;
                Field[] fieldArray2 = dataObj.getClass().getDeclaredFields();
                int n6 = fieldArray2.length;
                n = 0;
                while (n < n6) {
                    Field field = fieldArray2[n];
                    String fieldName = field.getName();
                    if (hasData.get(fieldName) != null) {
                        FieldDisplayInfo fdi = cdi.getField(fieldName);
                        String row = null;
                        try {
                            Object data = this.getData(field, (Object)dataObj);
                            if (data != null && !(data instanceof Set)) {
                                String val = fieldName.equals(linkField) ? this.formatFDI(dataObj, this.formatValue(data)) : this.formatValue(data);
                                row = "<td align=\"center\" class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\">" + (StringUtils.isNotEmpty((String)val) ? val : "&nbsp;") + "</td>";
                            } else {
                                row = "<td align=\"center\" class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\">&nbsp;</td>";
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (row != null) {
                            Integer inx;
                            Integer n7 = inx = fdi != null ? fdi.getOrder() : null;
                            if (inx == null) {
                                unOrdered.add(row);
                            } else {
                                ordered.put(inx, row);
                            }
                        }
                    }
                    ++n;
                }
                this.fillRows(out, ordered, unOrdered);
                out.println("</tr>\n");
                ++cnt;
            }
            out.println("</table>\n");
            if (dataObj.getClass() == Locality.class || dataObj.getClass() == CollectingEvent.class || dataObj.getClass() == CollectionObject.class || dataObj.getClass() == Taxon.class || dataObj.getClass() == Accession.class) {
                this.createMapLink(out, list, dataObj.getClass());
            }
            out.println(template.substring(contentInx + contentTag.length() + 1, template.length()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.toString());
            out.println("Sorry");
        }
    }

    protected String getLocalityMapString(Hashtable<Locality, Vector<CollectionObject>> locHash) {
        StringBuilder sb = new StringBuilder();
        int loc = 0;
        for (Locality locality : locHash.keySet()) {
            sb.append(locality.getLocalityId() + ";");
            int i = 0;
            for (CollectionObject co : locHash.get(locality)) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(co.getCollectionObjectId());
                ++i;
            }
            sb.append(";");
            ++loc;
        }
        return sb.toString();
    }

    protected void createMapLink(PrintWriter out, List<?> list, Class<?> clsObj) {
        Hashtable<Locality, Vector<CollectionObject>> locHash = new Hashtable<Locality, Vector<CollectionObject>>();
        if (clsObj == Locality.class) {
            for (Object obj : list) {
                Locality l = (Locality)obj;
                if (l == null) continue;
                Vector<CollectionObject> colObjs = new Vector<CollectionObject>();
                for (CollectingEvent ce : l.getCollectingEvents()) {
                    for (CollectionObject co : ce.getCollectionObjects()) {
                        colObjs.add(co);
                    }
                }
                locHash.put(l, colObjs);
            }
        } else if (clsObj == CollectingEvent.class) {
            Vector<CollectionObject> colObjs = null;
            for (Object obj : list) {
                CollectingEvent ce = (CollectingEvent)obj;
                if (ce == null) continue;
                Locality l = ce.getLocality();
                if (l != null) {
                    colObjs = locHash.get(l);
                    if (colObjs == null) {
                        colObjs = new Vector();
                        locHash.put(l, colObjs);
                    }
                } else {
                    colObjs = null;
                }
                if (colObjs == null) continue;
                for (CollectionObject co : ce.getCollectionObjects()) {
                    colObjs.add(co);
                }
            }
        } else if (clsObj == CollectionObject.class) {
            Vector<CollectionObject> colObjs = null;
            for (Object obj : list) {
                CollectionObject co = (CollectionObject)obj;
                CollectingEvent ce = co.getCollectingEvent();
                if (ce != null) {
                    Locality l = ce.getLocality();
                    if (l != null) {
                        colObjs = locHash.get(l);
                        if (colObjs == null) {
                            colObjs = new Vector();
                            locHash.put(l, colObjs);
                        }
                    } else {
                        colObjs = null;
                    }
                }
                if (colObjs == null) continue;
                colObjs.add(co);
            }
        } else if (clsObj == Taxon.class) {
            Vector<CollectionObject> colObjs = null;
            for (Object obj : list) {
                Taxon txn = (Taxon)obj;
                for (Determination det : txn.getDeterminations()) {
                    if (!det.isCurrentDet()) continue;
                    Locality locality = null;
                    CollectionObject co = det.getCollectionObject();
                    if (co == null) continue;
                    CollectingEvent ce = co.getCollectingEvent();
                    if (ce != null) {
                        locality = ce.getLocality();
                    }
                    if (locality == null) continue;
                    colObjs = locHash.get(locality);
                    if (colObjs == null) {
                        colObjs = new Vector();
                        locHash.put(locality, colObjs);
                    }
                    if (colObjs == null) continue;
                    colObjs.add(co);
                }
            }
        } else if (clsObj == Accession.class) {
            for (Object obj : list) {
                Accession accesion = (Accession)obj;
                if (accesion == null) continue;
                Vector<Object> colObjs = new Vector();
                for (CollectionObject co : accesion.getCollectionObjects()) {
                    if (co == null) continue;
                    Locality locality = null;
                    CollectingEvent ce = co.getCollectingEvent();
                    if (ce != null) {
                        locality = ce.getLocality();
                    }
                    if (locality == null) continue;
                    colObjs = locHash.get(locality);
                    if (colObjs == null) {
                        colObjs = new Vector();
                        locHash.put(locality, colObjs);
                    }
                    if (colObjs == null) continue;
                    colObjs.add(co);
                }
            }
        }
        out.println("<br/><a href=\"" + servletURL + "?id=map&points=" + this.getLocalityMapString(locHash) + "\">Map Collection Objects</a>");
    }

    protected void fillRows(PrintWriter out, Hashtable<Integer, String> ordered, Vector<String> unOrdered) {
        Vector<Integer> indexes = new Vector<Integer>(ordered.keySet());
        Collections.sort(indexes);
        int cnt = 1;
        for (Integer index : indexes) {
            String row = ordered.get(index);
            if (row == null) continue;
            if (StringUtils.contains((String)row, (String)"BRDRODDEVEN")) {
                out.println(StringUtils.replace((String)row, (String)"BRDRODDEVEN", (String)("brdr" + ((cnt + 1) % 2 == 0 ? "even" : "odd"))));
            } else {
                out.println(row);
            }
            ++cnt;
        }
        if (unOrdered != null) {
            for (String row : unOrdered) {
                if (StringUtils.contains((String)row, (String)"BRDRODDEVEN")) {
                    out.println(StringUtils.replace((String)row, (String)"BRDRODDEVEN", (String)("brdr" + ((cnt + 1) % 2 == 0 ? "even" : "odd"))));
                } else {
                    out.println(row);
                }
                ++cnt;
            }
        }
    }

    protected String getCompareCBX(String name, boolean isNumeric) {
        return "<select name=\"" + name + "\" size=\"1\">\n" + "<option value=\"=\" selected=\"selected\">Equals</option>\n" + "<option value=\"NOT EQUAL\">Not Equals</option>\n" + "<option value=\"LIKE\">LIKE</option>\n" + (isNumeric ? "<option value=\">\">Greater Than</option>\n<option value=\"<\">Less Than</option>\n<option value=\">\">Greater Than Equals</option>\n<option value=\"<\">Less Than Equals</option>\n" : "") + "</select>\n";
    }

    protected String getAndOfCBX(String name) {
        return "<select name=\"" + name + "AndOrCBX\" size=\"1\">\n" + "<option value=\"AND\" selected=\"selected\">AND</option>\n" + "<option value=\"OR\">OR</option>\n" + "</select>\n";
    }

    protected String getTrueFalse(String name) {
        return "<select name=\"" + name + "\" size=\"1\">\n" + "<option value=\"-\" selected=\"selected\"> - </option>\n" + "<option value=\"TRUE\">True</option>\n" + "<option value=\"FALSE\">False</option>\n" + "</select>\n";
    }

    protected String getInput(String name, String type, Integer len) {
        return "<input type=\"" + type + "\" name=\"" + name + "\"" + (len != null ? " size=\"" + len + "\"" : "") + ">";
    }

    protected String getControlPanel(Field field) {
        String name = field.getName();
        StringBuilder sb = new StringBuilder();
        Class<?> fldCls = field.getType();
        if (fldCls == Integer.class || fldCls == Double.class || fldCls == Float.class || fldCls == Short.class || fldCls == Byte.class || fldCls == Calendar.class || fldCls == Date.class || fldCls == BigDecimal.class) {
            sb.append(this.getCompareCBX(String.valueOf(name) + "Compare1", true));
            sb.append(this.getInput(String.valueOf(name) + "1", "text", 20));
            sb.append("&nbsp;&nbsp;");
            sb.append(this.getAndOfCBX(name));
            sb.append("&nbsp;&nbsp;");
            sb.append(this.getCompareCBX(String.valueOf(name) + "Compare2", true));
            sb.append(this.getInput(String.valueOf(name) + "2", "text", 20));
        } else if (fldCls == Boolean.class) {
            sb.append(this.getTrueFalse(String.valueOf(name) + "1"));
        } else {
            sb.append(this.getCompareCBX(String.valueOf(name) + "Compare1", false));
            sb.append(this.getInput(String.valueOf(name) + "1", "text", 20));
        }
        return sb.toString();
    }

    protected void displaySearchForm(PrintWriter out, String fullClassName) {
        try {
            if (StringUtils.isEmpty((String)template)) {
                out.println("The template file is empty!");
            }
            Class<?> clsObj = Class.forName(fullClassName);
            ClassDisplayInfo cdi = this.classHash.get(clsObj.getSimpleName());
            String className = cdi.getClassName();
            int inx = template.indexOf(contentTag);
            String subContent = template.substring(0, inx);
            out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)(String.valueOf(className) + " Search Form")));
            out.println("<form name=plcform action=\"" + servletURL + "\" method=\"GET\" onsubmit=\"\"><br/>\n");
            out.println("<input type=\"hidden\" name=\"cls\" value=\"" + className + "\">\n");
            out.println("<input type=\"hidden\" name=\"id\" value=\"dosearch\">\n");
            out.println("<span style=\"font-size: 14pt;\">" + className + " Search Form</span><br/><br/>\n");
            out.println("<input type=\"radio\" name=\"match\" value=\"OR\" checked=\"checked\"/>Match any of following</input>\n");
            out.println("<input type=\"radio\" name=\"match\" value=\"AND\">Match all of following</input>\n");
            out.println("<br/>\n");
            out.println("<br/>\n");
            out.println("<table style=\"border: 1px gray solid\" cellspacing=\"0\" cellpadding=\"4\">\n");
            out.println("<tr><th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Field</th>");
            out.println("    <th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Search Values</th>");
            out.println("    <th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Hide</th></tr>\n");
            Hashtable<Integer, String> ordered = new Hashtable<Integer, String>();
            Vector<String> unOrdered = new Vector<String>();
            StringBuilder sb = new StringBuilder();
            Field[] fieldArray = clsObj.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fldNameLower;
                Field field = fieldArray[n2];
                sb.setLength(0);
                String fieldName = field.getName();
                FieldDisplayInfo fdi = cdi.getField(fieldName);
                if (!(fdi != null && fdi.isSkipped() && !fdi.isAvailForSearch() || (fldNameLower = fieldName.toLowerCase()).startsWith(clsObj.getSimpleName().toLowerCase()) && fldNameLower.endsWith("id"))) {
                    try {
                        if (!java.util.Collection.class.isAssignableFrom(field.getType()) && !Logger.class.isAssignableFrom(field.getType())) {
                            boolean isOK = true;
                            if (this.baseClassHash.get(field.getType()) == null) {
                                Object obj = field.getType().newInstance();
                                boolean bl = isOK = !(obj instanceof FormDataObjIFace);
                            }
                            if (isOK) {
                                String labelStr = this.labelMap.get(fieldName);
                                if (StringUtils.isEmpty((String)labelStr)) {
                                    labelStr = UIHelper.makeNamePretty(fieldName);
                                }
                                Integer index = fdi != null ? fdi.getOrder() : null;
                                int cnt = index == null ? unOrdered.size() : ordered.size();
                                sb.append("<tr><td class=\"BRDRODDEVEN\" align=\"right\" nowrap=\"nowrap\" style=\"border-bottom: 1px gray solid;\"><b>" + labelStr + ":</b></td>");
                                sb.append("<td class=\"BRDRODDEVEN\" nowrap=\"nowrap\" style=\"border-bottom: 1px gray solid;\">" + this.getControlPanel(field) + "</td>");
                                sb.append("<td class=\"BRDRODDEVEN\" align=\"center\" style=\"border-bottom: 1px gray solid;\">" + this.getInput(String.valueOf(fieldName) + "Hide", "checkbox", null) + "</td></tr>\n");
                                ++cnt;
                                if (index == null) {
                                    unOrdered.add(sb.toString());
                                } else {
                                    ordered.put(index, sb.toString());
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n2;
            }
            this.fillRows(out, ordered, unOrdered);
            out.println("<tr><td align=\"center\" colspan=\"2\"><input type=\"submit\" value=\"Search\"></td></tr>\n");
            out.println("</table><br/>");
            out.println("</form>");
            out.println(template.substring(inx + contentTag.length() + 1, template.length()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String getParamValue(PrintWriter out, HttpServletRequest request, String name) {
        String str = request.getParameter(name);
        return str;
    }

    public static String parseDate(String[] formats, String dateStr) throws Exception {
        String[] stringArray = formats;
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String fmt = stringArray[n2];
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(fmt);
                Date d = sdf.parse(dateStr);
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(d.getTime());
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return "";
    }

    public static String parseDate(String dateStr) throws Exception {
        if (dateStr.length() == 10) {
            if (StringUtils.isNumeric((String)dateStr.substring(2, 3))) {
                return SpecifyExplorer.parseDate(new String[]{"yyyy/MM/dd", "yyyy-MM-dd"}, dateStr);
            }
            return SpecifyExplorer.parseDate(new String[]{"MM-dd-yyyy", "MM/dd/yyyy"}, dateStr);
        }
        return "";
    }

    protected void processSearch(PrintWriter out, String fullClassName, HttpServletRequest request) {
        block43: {
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Class<?> clsObj = Class.forName(fullClassName);
                    ClassDisplayInfo cdi = this.classHash.get(clsObj.getSimpleName());
                    String className = cdi.getClassName();
                    DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(className);
                    StringBuilder sql = new StringBuilder("FROM " + className + " WHERE ");
                    String matchStr = " " + this.getParamValue(out, request, "match") + " ";
                    boolean addMatch = false;
                    Field[] fieldArray = clsObj.getDeclaredFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fldNameLower;
                        Field field = fieldArray[n2];
                        String fieldName = field.getName();
                        FieldDisplayInfo fdi = cdi.getField(fieldName);
                        if (!(fdi != null && (fdi.isSkipped() || !fdi.isAvailForSearch()) || (fldNameLower = fieldName.toLowerCase()).startsWith(clsObj.getSimpleName().toLowerCase()) && fldNameLower.endsWith("id"))) {
                            try {
                                if (!java.util.Collection.class.isAssignableFrom(field.getType()) && !Logger.class.isAssignableFrom(field.getType())) {
                                    boolean isOK = true;
                                    if (this.baseClassHash.get(field.getType()) == null) {
                                        Object obj = field.getType().newInstance();
                                        boolean bl = isOK = !(obj instanceof FormDataObjIFace);
                                    }
                                    if (isOK) {
                                        String value;
                                        String andOrStr = this.getParamValue(out, request, String.valueOf(fieldName) + "AndOrCBX");
                                        String compareStr1 = this.getParamValue(out, request, String.valueOf(fieldName) + "Compare1");
                                        String compareStr2 = this.getParamValue(out, request, String.valueOf(fieldName) + "Compare2");
                                        String field1Str = this.getParamValue(out, request, String.valueOf(fieldName) + "1");
                                        String field2Str = this.getParamValue(out, request, String.valueOf(fieldName) + "2");
                                        Class<?> fldCls = field.getType();
                                        if (fldCls == Integer.class || fldCls == Double.class || fldCls == Float.class || fldCls == Short.class || fldCls == Byte.class || fldCls == BigDecimal.class) {
                                            if (StringUtils.isNotEmpty((String)field1Str) && StringUtils.isNotEmpty((String)compareStr1)) {
                                                if (addMatch) {
                                                    sql.append(matchStr);
                                                    addMatch = false;
                                                }
                                                value = field1Str;
                                                if (compareStr1.equals("LIKE")) {
                                                    value = "%" + value + "%";
                                                }
                                                sql.append(String.valueOf(fieldName) + " " + compareStr1 + " " + value);
                                                if (StringUtils.isNotEmpty((String)field2Str) && StringUtils.isNotEmpty((String)compareStr2)) {
                                                    value = field2Str;
                                                    if (compareStr2.equals("LIKE")) {
                                                        value = "%" + value + "%";
                                                    }
                                                    sql.append(" " + andOrStr + " ");
                                                    sql.append(String.valueOf(fieldName) + " " + compareStr2 + " " + value);
                                                }
                                                addMatch = true;
                                            }
                                        } else if (fldCls == Calendar.class || fldCls == Date.class) {
                                            if (StringUtils.isNotEmpty((String)field1Str) && StringUtils.isNotEmpty((String)compareStr1)) {
                                                if (addMatch) {
                                                    sql.append(matchStr);
                                                    addMatch = false;
                                                }
                                                value = SpecifyExplorer.parseDate(field1Str);
                                                if (compareStr1.equals("LIKE")) {
                                                    value = "%" + value + "%";
                                                }
                                                sql.append(String.valueOf(fieldName) + " " + compareStr1 + " '" + value + "'");
                                                if (StringUtils.isNotEmpty((String)field2Str) && StringUtils.isNotEmpty((String)compareStr2)) {
                                                    value = SpecifyExplorer.parseDate(field2Str);
                                                    if (compareStr2.equals("LIKE")) {
                                                        value = "%" + value + "%";
                                                    }
                                                    sql.append(" " + andOrStr + " ");
                                                    sql.append(String.valueOf(fieldName) + " " + compareStr2 + " '" + value + "'");
                                                }
                                                addMatch = true;
                                            }
                                        } else if (fldCls == String.class) {
                                            if (StringUtils.isNotEmpty((String)field1Str)) {
                                                DBFieldInfo fi;
                                                if (addMatch) {
                                                    sql.append(matchStr);
                                                    addMatch = false;
                                                }
                                                if ((fi = ti.getFieldByName(fieldName)) != null && fi.getFormatter() != null) {
                                                    field1Str = (String)fi.getFormatter().formatFromUI(field1Str);
                                                }
                                                String value2 = field1Str;
                                                if (compareStr1.equals("LIKE")) {
                                                    value2 = "%" + field1Str + "%";
                                                }
                                                sql.append(String.valueOf(fieldName) + " " + compareStr1 + " '" + value2 + "'");
                                                addMatch = true;
                                            }
                                        } else if (fldCls == Boolean.class) {
                                            if (StringUtils.isNotEmpty((String)field1Str) && !field1Str.equals("-")) {
                                                if (addMatch) {
                                                    sql.append(matchStr);
                                                    addMatch = false;
                                                }
                                                sql.append(String.valueOf(fieldName) + " = " + field1Str);
                                                addMatch = true;
                                            }
                                        } else if (StringUtils.isNotEmpty((String)field1Str) && StringUtils.isNotEmpty((String)compareStr1)) {
                                            if (addMatch) {
                                                sql.append(matchStr);
                                                addMatch = false;
                                            }
                                            value = field1Str;
                                            if (compareStr1.equals("LIKE")) {
                                                value = "%" + field1Str + "%";
                                            }
                                            sql.append(String.valueOf(fieldName) + " " + compareStr1 + " " + value);
                                            addMatch = true;
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    List<?> list = session.createQuery(sql.toString(), false).list();
                    if (list == null || list.size() == 0) {
                        int inx = template.indexOf(contentTag);
                        String subContent = template.substring(0, inx);
                        out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)"No Results."));
                        out.println("<br/></br>" + (list == null ? "There was error performing the query." : "No results return.") + "<br/><br/>");
                        out.println("<table border=\"0\" width=\"100%\"<tr><td nowrap=\"nowrap\">select * " + sql + "</td></tr></table><br/>");
                        out.println("</br><br/><a href=\"javascript:window.back()\">Back</a>");
                        out.println(template.substring(inx + contentTag.length() + 1, template.length()));
                        break block43;
                    }
                    if (list.size() == 1) {
                        this.processDataObj(out, (FormDataObjIFace)list.get(0), true);
                        break block43;
                    }
                    this.processDataList(out, list, sql.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    protected void fillLabelMap(FormDataObjIFace dataObj, Hashtable<String, String> labelHashMap) {
        labelHashMap.clear();
        if (dataObj instanceof Treeable) {
            Object childDef;
            Object parentDef;
            Treeable node = (Treeable)((Object)dataObj);
            Object def = node.getDefinitionItem();
            Object parentNode = node.getParent();
            if (parentNode != null && (parentDef = parentNode.getDefinitionItem()) != null) {
                String parentDefName = parentDef.getName();
                labelHashMap.put("parent", parentDefName);
            }
            if ((childDef = def.getChild()) != null) {
                String childDefName = childDef.getName();
                labelHashMap.put("children", childDefName);
            }
            if (dataObj.getClass() == Taxon.class) {
                labelHashMap.put("definitionItem", "Taxonomy");
            }
        }
    }

    public void doAlphaIndexPage(PrintWriter out, String className, String fieldName, String letter) {
        Vector<UIFieldFormatterField> fields;
        UIFieldFormatterIFace fmt = null;
        boolean isNumeric = false;
        int numLetters = 1;
        DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(className);
        String tableName = tableInfo.getName();
        DBFieldInfo fi = tableInfo.getFieldByName(fieldName);
        if (fi != null && (fmt = fi.getFormatter()) != null && !(isNumeric = fmt.isNumeric()) && (fields = fmt.getFields()).size() > 0 && ((UIFieldFormatterField)fields.get(0)).getType() == UIFieldFormatterField.FieldType.year) {
            numLetters = 4;
        }
        String filter = "";
        if (StringUtils.isNotEmpty((String)fieldName) && StringUtils.isNotEmpty((String)letter) && !isNumeric) {
            filter = " LOWER(SUBSTRING(" + fieldName + ", 1, " + letter.length() + ")) = \"" + letter.toLowerCase() + "\" ";
        }
        String joinStr = QueryAdjusterForDomain.getInstance().getJoinClause(tableInfo, false, null, false);
        String specialFields = QueryAdjusterForDomain.getInstance().getSpecialColumns(tableInfo, false);
        String sql = "SELECT " + tableName + "." + tableInfo.getIdColumnName() + ", " + fieldName + " FROM " + tableInfo.getName() + " " + (StringUtils.isNotEmpty((String)joinStr) ? joinStr : "") + (StringUtils.isNotEmpty((String)specialFields) ? " WHERE " + specialFields : "") + (StringUtils.isNotEmpty((String)filter) ? String.valueOf(StringUtils.isNotEmpty((String)specialFields) ? " AND " : " WHERE ") + filter : "") + " ORDER BY " + fieldName + " ASC";
        sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
        System.out.println(sql);
        this.doAlphaIndexPageSQL(out, className, letter, numLetters, fmt, sql);
    }

    /*
     * Could not resolve type clashes
     */
    public void doAlphaIndexPageSQL(PrintWriter out, String className, String letter, int numLetters, UIFieldFormatterIFace fmt, String sql) {
        int inx;
        block51: {
            boolean isNumeric = fmt != null && fmt.isNumeric();
            inx = template.indexOf(contentTag);
            String subContent = template.substring(0, inx);
            out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)className));
            ClassDisplayInfo cdi = this.classHash.get(className);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            boolean useLetter = true;
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBConnection.getInstance().createConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(sql);
                    Vector<Object> alphaList = new Vector();
                    Hashtable<String, NameId> alphaHash = new Hashtable<String, NameId>();
                    boolean doingIndex = StringUtils.isEmpty((String)letter);
                    System.out.println("\n\ndoingIndex " + doingIndex + " letter[" + letter + "]");
                    int numMin = Integer.MAX_VALUE;
                    int numMax = Integer.MIN_VALUE;
                    int cnt = 0;
                    while (rs.next()) {
                        String name;
                        int id = rs.getInt(1);
                        if (isNumeric) {
                            name = rs.getString(2);
                            name = (String)fmt.formatToUI(name);
                            Integer numAsInt = null;
                            Integer floor = null;
                            try {
                                numAsInt = Integer.parseInt(name);
                                floor = Integer.parseInt(letter);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            numMin = Math.min(numMin, numAsInt);
                            numMax = Math.min(numMax, numAsInt);
                            if (doingIndex) {
                                int numSegment = numAsInt / 1000;
                                String c = Integer.toString(numSegment);
                                NameId nis = (NameId)alphaHash.get(c);
                                if (nis == null) {
                                    nis = new NameId(c, 0, numSegment);
                                    alphaHash.put(c, nis);
                                }
                                nis.add();
                            } else if (numAsInt >= floor && numAsInt < floor + 1000) {
                                alphaList.add(new NameId(name, id, numAsInt));
                            }
                        } else {
                            block49: {
                                name = rs.getString(2);
                                if (StringUtils.isEmpty((String)name)) {
                                    name = rs.getString(1);
                                }
                                if (cdi.isUseIdentityTitle()) {
                                    DataProviderSessionIFace session = null;
                                    try {
                                        try {
                                            String title;
                                            session = DataProviderFactory.getInstance().createSession();
                                            FormDataObjIFace fdi = (FormDataObjIFace)session.createQuery("from " + className + " where id = " + id, false).list().get(0);
                                            if (fdi != null && StringUtils.isNotEmpty((String)(title = fdi.getIdentityTitle()))) {
                                                name = title;
                                            }
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                            session.close();
                                            break block49;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        session.close();
                                        throw throwable;
                                    }
                                    session.close();
                                } else if (cdi.getIndexClass() != null && cdi.getIndexClass() == Calendar.class) {
                                    java.sql.Date date = rs.getDate(2);
                                    name = date != null ? sdf.format(date) : "0000";
                                    useLetter = false;
                                }
                            }
                            int len = Math.min(numLetters, name.length());
                            if (doingIndex) {
                                String c = useLetter ? name.substring(0, len).toLowerCase() : name;
                                NameId nis = (NameId)alphaHash.get(c);
                                if (nis == null) {
                                    nis = new NameId(c, 0);
                                    alphaHash.put(c, nis);
                                }
                                nis.add();
                            } else if (useLetter && name.substring(0, len).toUpperCase().equals(letter) || !useLetter && name.equals(letter)) {
                                alphaList.add(new NameId(name, id));
                            }
                        }
                        ++cnt;
                    }
                    System.out.println("alphaHash.size: " + alphaHash.size());
                    if (doingIndex) {
                        alphaList = new Vector(alphaHash.values());
                    }
                    Collections.sort(alphaList);
                    System.out.println("alphaList.size: " + alphaList.size());
                    if (doingIndex) {
                        DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(className);
                        out.println("<center><br/><span style=\"font-size: 14pt;\">Index For " + ti.getTitle() + "</span><br/>");
                        out.println("<table class=\"brdr\" border=\"0\" cellpadding=\"4\" cellspacing=\"0\">\n");
                        out.println("<tr><th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Index</th>");
                        out.println("<th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Count</th></tr>\n");
                        int i = 0;
                        for (NameId nis : alphaList) {
                            String ltrStr = nis.getNum() != null ? Integer.toString(nis.getNum() * 1000) : nis.getName().toUpperCase();
                            out.println("<tr>");
                            out.println("<td nowrap=\"nowrap\" class=\"brdr" + ((i + 1) % 2 == 0 ? "even" : "odd") + "\" align=\"center\">&nbsp;&nbsp;<a href=\"" + servletURL + "?cls=" + className + "&ltr=" + ltrStr + "\">" + ltrStr + "</a>&nbsp;&nbsp;</td>\n");
                            out.println("<td nowrap=\"nowrap\" class=\"brdr" + ((i + 1) % 2 == 0 ? "even" : "odd") + "\"  align=\"center\"><a href=\"" + servletURL + "?cls=" + className + "&ltr=" + ltrStr + "\">" + nis.getId() + "</a></td>\n");
                            out.println("</tr>");
                            ++i;
                        }
                        out.println("</table></center>\n");
                    } else if (alphaList.size() > 0) {
                        if (useLetter) {
                            out.println("<br/>" + ((NameId)alphaList.get(0)).getName().charAt(0) + "<br/>\n");
                        }
                        out.println("<table class=\"brdr\" border=\"0\" cellpadding=\u0004\" cellspacing=\"0\">\n");
                        int i = 1;
                        for (NameId nis : alphaList) {
                            out.println("<tr>");
                            out.println("<td nowrap=\"nowrap\" class=\"brdr" + ((i + 1) % 2 == 0 ? "even" : "odd") + "\" >");
                            out.println("<a href=\"" + servletURL + "?cls=" + className + "&id=" + nis.getId() + "\">" + nis.getName() + "</a>");
                            out.println("</td></tr>\n");
                            ++i;
                        }
                        out.println("</table>\n");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block51;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block51;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        out.println(template.substring(inx + contentTag.length() + 1, template.length()));
        this.log.info((Object)"Done");
    }

    public void doAlphaIndexPageSQLOld(PrintWriter out, String className, String letter, String sql) {
        int inx;
        block24: {
            inx = template.indexOf(contentTag);
            String subContent = template.substring(0, inx);
            out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)className));
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBConnection.getInstance().createConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(sql);
                    char currChar = '_';
                    while (rs.next()) {
                        boolean okDisplay;
                        int id = rs.getInt(1);
                        String name = rs.getString(2);
                        if (StringUtils.isEmpty((String)name)) {
                            name = rs.getString(1);
                        }
                        String lowerName = name.toLowerCase();
                        boolean bl = okDisplay = StringUtils.isEmpty((String)letter) || letter.toLowerCase().charAt(0) == lowerName.charAt(0);
                        if (currChar != lowerName.charAt(0)) {
                            currChar = lowerName.charAt(0);
                            if (okDisplay) {
                                out.println("<br/>" + name.charAt(0) + "<br/>\n");
                            }
                        }
                        if (!okDisplay) continue;
                        out.println("<a href=\"" + servletURL + "?cls=" + className + "&id=" + id + "\">" + name + "</a><br/>\n");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block24;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        out.println(template.substring(inx + contentTag.length() + 1, template.length()));
        this.log.info((Object)"Done");
    }

    protected String getRelativeImagePath(String path) {
        System.out.println("getRelativeImagePath -> [" + path + "]");
        String key = "specify.jar!/edu/ku/brc/specify/";
        int inx = path.indexOf(key);
        if (inx > -1) {
            String urlStr = String.valueOf(baseURLSite) + "/" + path.substring(inx += key.length());
            System.out.println("getRelativeImagePath -> [" + urlStr + "]");
            return urlStr;
        }
        return null;
    }

    protected void displayAllSearchables(PrintWriter out) {
        try {
            if (StringUtils.isEmpty((String)template)) {
                out.println("The template file is empty!");
            }
            int inx = template.indexOf(contentTag);
            String subContent = template.substring(0, inx);
            out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)"Search Forms"));
            out.println("<br/>");
            out.println("Seachable Data");
            out.println("<br/>");
            out.println("<table class=\"brdr\"  border=\"0\" cellspacing=\"0\" cellpadding=\"4\">");
            out.println("<tr><th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Data Type</th>");
            out.println("    <th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Form</th>");
            out.println("    <th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Index</th>\n");
            out.println("    <th class=\"brdr\" align=\"center\" nowrap=\"nowrap\">Statistics</th></tr>\n");
            out.println("</tr>\n");
            String formIconPath = this.getRelativeImagePath(IconManager.getIconEntryByName("Search").getUrl().toString());
            String statsIconPath = this.getRelativeImagePath(IconManager.getIconEntryByName("Statistics").getUrl().toString());
            String indexIcon = String.valueOf(baseURLSite) + "/images/Search32x32.png";
            int cnt = 1;
            for (ClassDisplayInfo cdi : this.sortedClassList) {
                String className = cdi.getClassName();
                String indexName = cdi.getIndexName();
                DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(className);
                if (StringUtils.isEmpty((String)indexName)) continue;
                String brdCls = " class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\"";
                out.println("<tr><td nowrap=\"nowrap\" " + brdCls + ">" + ti.getTitle() + "</td>");
                out.println("    <td nowrap=\"nowrap\" " + brdCls + " align=\"center\" ><a href=\"" + servletURL + "?cls=" + className + "&id=dspsrch\"><img border=\"0\" height=\"24\" src=\"" + formIconPath + "\"/></a></td>");
                if (StringUtils.isNotEmpty((String)cdi.getLinkField())) {
                    out.println("    <td nowrap=\"nowrap\" " + brdCls + " align=\"center\"><a href=\"" + servletURL + "?cls=" + className + "\"><img border=\"0\" height=\"24\" src=\"" + indexIcon + "\"/></a></a></td>");
                } else {
                    out.println("    <td nowrap=\"nowrap\" " + brdCls + " align=\"center\">&nbsp;</td>");
                }
                out.println("    <td nowrap=\"nowrap\" " + brdCls + ">");
                for (StatsDisplayInfo stat : cdi.getStats()) {
                    out.println("    <a href=\"" + stat.getUrl() + "\"><img border=\"0\" height=\"24\" src=\"" + statsIconPath + "\"/> " + stat.getTitle() + "</a><br/>");
                }
                out.println("    </td>");
                out.println("</tr>");
                ++cnt;
            }
            out.println("</table><br/>");
            out.println(template.substring(inx + contentTag.length() + 1, template.length()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void createMap(PrintWriter out, String pointsStr, boolean sortByCE) {
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                String mapTemplate = "";
                try {
                    File templateFile = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "site/map_template.html");
                    mapTemplate = FileUtils.readFileToString((File)templateFile);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    out.println(ex.toString());
                }
                if (StringUtils.isEmpty((String)template)) {
                    out.println("The template file is empty!");
                }
                int inx = mapTemplate.indexOf(contentTag);
                String subContent = mapTemplate.substring(0, inx);
                out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)"Mapping Collection Objects"));
                String[] points = StringUtils.splitPreserveAllTokens((String)pointsStr, (char)';');
                double maxLat = Double.MIN_VALUE;
                double minLat = Double.MAX_VALUE;
                double maxLon = Double.MIN_VALUE;
                double minLon = Double.MAX_VALUE;
                Hashtable<Locality, CollectingEvent> locToCE = new Hashtable<Locality, CollectingEvent>();
                boolean drawLines = false;
                Hashtable<CollectingEvent, CEForPoly> hash = new Hashtable<CollectingEvent, CEForPoly>();
                StringBuilder locStr = new StringBuilder();
                int locCnt = 0;
                int i = 0;
                while (i < points.length) {
                    if (StringUtils.isEmpty((String)points[i])) break;
                    Locality locality = (Locality)session.createQuery("from Locality WHERE id = " + points[i], false).list().get(0);
                    if (locality != null) {
                        String[] colObjsIds;
                        StringBuilder sb = new StringBuilder();
                        String[] stringArray = colObjsIds = StringUtils.splitPreserveAllTokens((String)points[i + 1], (char)',');
                        int n = colObjsIds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CollectionObject co;
                            String id = stringArray[n2];
                            if (StringUtils.isNotEmpty((String)id) && (co = (CollectionObject)session.createQuery("from CollectionObject WHERE id = " + id, false).list().get(0)) != null) {
                                CollectingEvent ce = co.getCollectingEvent();
                                if (ce != null) {
                                    CollectingEvent colEv = (CollectingEvent)locToCE.get(locality);
                                    if (colEv == null) {
                                        locToCE.put(locality, ce);
                                    } else if (!ce.getCollectingEventId().equals(colEv.getCollectingEventId())) {
                                        drawLines = false;
                                    }
                                    Locality loc = ce.getLocality();
                                    if (loc != null && loc.getLatitude1() != null && loc.getLongitude1() != null) {
                                        CEForPoly cep = (CEForPoly)hash.get(ce);
                                        if (cep == null) {
                                            cep = new CEForPoly(ce.getStartDate(), loc.getLatitude1().doubleValue(), loc.getLongitude1().doubleValue(), "");
                                            hash.put(ce, cep);
                                        }
                                        cep.getColObjs().add(co);
                                    }
                                }
                                for (Determination det : co.getDeterminations()) {
                                    if (!det.isCurrentDet()) continue;
                                    Taxon txn = det.getPreferredTaxon();
                                    if (txn == null) break;
                                    sb.append("<a href='SpecifyExplorer?cls=CollectionObject&id=" + co.getCollectionObjectId() + "'>" + txn.getFullName() + "</a>");
                                    sb.append("<br/>");
                                    break;
                                }
                            }
                            ++n2;
                        }
                        if (locality.getLatitude1() != null && locality.getLongitude1() != null) {
                            if (locCnt == 0) {
                                minLat = maxLat = locality.getLatitude1().doubleValue();
                                minLon = maxLon = locality.getLongitude1().doubleValue();
                            } else {
                                maxLat = Math.max(maxLat, locality.getLatitude1().doubleValue());
                                minLat = Math.min(minLat, locality.getLatitude1().doubleValue());
                                maxLon = Math.max(maxLon, locality.getLongitude1().doubleValue());
                                minLon = Math.min(minLon, locality.getLongitude1().doubleValue());
                            }
                            locStr.append("var point = new GLatLng(" + locality.getLatitude1() + "," + locality.getLongitude1() + ");\n");
                            locStr.append("var marker = createMarker(point,\"" + locality.getLocalityName() + "\",\"" + sb.toString() + "\");\n");
                            locStr.append("map.addOverlay(marker);\n");
                            ++locCnt;
                        }
                    }
                    ++i;
                    ++i;
                }
                System.out.println("maxLat: " + maxLat);
                System.out.println("minLat: " + minLat);
                System.out.println("maxLon: " + maxLon);
                System.out.println("minLon: " + minLon);
                double halfLat = (maxLat - minLat) / 2.0;
                double halfLon = (maxLon - minLon) / 2.0;
                System.out.println("halfLat: " + halfLat);
                System.out.println("halfLon: " + halfLon);
                int zoom = 2;
                if (halfLat == 0.0 && halfLon == 0.0) {
                    zoom = 12;
                } else if (halfLat < 0.5 && halfLon < 0.5) {
                    zoom = 10;
                } else if (halfLat < 2.0 && halfLon < 2.0) {
                    zoom = 8;
                } else if (halfLat < 7.0 && halfLon < 7.0) {
                    zoom = 6;
                }
                out.println("        map.setCenter(new GLatLng( " + (minLat + halfLat) + "," + (minLon + halfLon) + "), " + zoom + ");\n");
                out.println(locStr.toString());
                if (drawLines) {
                    if (hash.size() > 0) {
                        out.println("var polyline = new GPolyline([");
                        for (CEForPoly cep : hash.values()) {
                            out.println("new GLatLng(" + cep.getLat() + ", " + cep.getLon() + "),\n");
                        }
                    }
                    out.println("], \"#FF0000\", 5);\n");
                    out.println("map.addOverlay(polyline);\n");
                }
                out.println(mapTemplate.substring(inx + contentTag.length() + 1, mapTemplate.length()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected void generateDateChart(HttpServletRequest request, HttpServletResponse response, String sql, String title, String x_AxisTitle, String y_AxisTitle) {
        Vector<NameId> alphaList;
        Hashtable<String, NameId> alphaHash;
        String type;
        block22: {
            type = request.getParameter("type");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            alphaHash = new Hashtable<String, NameId>();
            alphaList = null;
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBConnection.getInstance().createConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        java.sql.Date date = rs.getDate(1);
                        String dateStr = sdf.format(date);
                        int year = Integer.parseInt(dateStr);
                        int decade = year / 10 * 10;
                        NameId nis = (NameId)alphaHash.get(dateStr = Integer.toString(decade));
                        if (nis == null) {
                            nis = new NameId(dateStr, 0);
                            alphaHash.put(dateStr, nis);
                        }
                        nis.add();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        alphaList = new Vector<NameId>(alphaHash.values());
        Collections.sort(alphaList);
        this.createChart(response, type, alphaList, title, x_AxisTitle, y_AxisTitle);
    }

    protected void generateCEChart(HttpServletRequest request, HttpServletResponse response) {
        this.generateDateChart(request, response, "select startDate from collectingevent where startDate is not null", "Collecting Events By Decade", "Decades", "Number of Collecting Events");
    }

    protected void generateColObjChart(HttpServletRequest request, HttpServletResponse response) {
        this.generateDateChart(request, response, "select catalogedDate from collectionobject where catalogedDate is not null", "Cataloged By Decade", "Decades", "Number of Collection Objects");
    }

    protected void generateCEChartOld(HttpServletRequest request, HttpServletResponse response) {
        Vector<NameId> alphaList;
        Hashtable<String, NameId> alphaHash;
        String type;
        block22: {
            type = request.getParameter("type");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            alphaHash = new Hashtable<String, NameId>();
            alphaList = null;
            Connection connection = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBConnection.getInstance().createConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery("select startDate from collectingevent where startDate is not null");
                    while (rs.next()) {
                        java.sql.Date date = rs.getDate(1);
                        String dateStr = sdf.format(date);
                        int year = Integer.parseInt(dateStr);
                        int decade = year / 10 * 10;
                        NameId nis = (NameId)alphaHash.get(dateStr = Integer.toString(decade));
                        if (nis == null) {
                            nis = new NameId(dateStr, 0);
                            alphaHash.put(dateStr, nis);
                        }
                        nis.add();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        alphaList = new Vector<NameId>(alphaHash.values());
        Collections.sort(alphaList);
        this.createChart(response, type, alphaList, "Collecting Events By Decade", "Decades", "Number of Collecting Events");
    }

    protected void createChart(HttpServletResponse response, String type, Vector<NameId> alphaList, String title, String xTitle, String yTitle) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (NameId nis : alphaList) {
            dataset.addValue((double)nis.getId(), (Comparable)((Object)nis.getName()), (Comparable)((Object)""));
        }
        JFreeChart chart = null;
        if (StringUtils.isEmpty((String)type) || type.equals("bar")) {
            chart = ChartFactory.createBarChart((String)title, (String)xTitle, (String)yTitle, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else if (type.equals("line")) {
            chart = ChartFactory.createLineChart((String)title, (String)xTitle, (String)yTitle, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        chart.setBackgroundPaint((Paint)new Color(228, 243, 255));
        response.setContentType("image/png");
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)700, (int)600);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void chartIt(PrintWriter out, String arg, String title) {
        int inx = template.indexOf(contentTag);
        String subContent = template.substring(0, inx);
        out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)title));
        out.println("<iframe FRAMEBORDER=\"0\" src=\"SpecifyExplorer?id=" + arg + "\" width=\"705\" height=\"605\"></iframe>");
        out.println(template.substring(inx + contentTag.length() + 1, template.length()));
    }

    protected JSONObject createNode(Treeable<?, ?, ?> treeable) {
        JSONObject json = new JSONObject();
        json.accumulate("name", (Object)treeable.getName());
        json.accumulate("fullname", (Object)treeable.getName());
        json.accumulate("uiProvider", (Object)"col");
        JSONArray childrenArray = new JSONArray();
        Set<?> children = treeable.getChildren();
        json.accumulate("leaf", children.size() == 0);
        for (Treeable kid : children) {
            childrenArray.add((Object)this.createNode(kid));
        }
        json.accumulate("children", (Object)childrenArray);
        return json;
    }

    protected String searchTree(String text, String className) {
        DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(className);
        DataProviderSessionIFace session = null;
        try {
            session = DataProviderFactory.getInstance().createSession();
            List<?> list = session.getDataList("FROM " + ti.getClassName() + " WHERE name = '" + text + "'");
            if (list.size() > 0) {
                JSONObject treeJSON = new JSONObject();
                treeJSON.accumulate("title", (Object)className);
                treeJSON.accumulate("id", (Object)((FormDataObjIFace)list.iterator().next()).getId());
                System.out.println("====>\n" + treeJSON.toString());
                String string = treeJSON.toString();
                return string;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            session.close();
        }
        return "[]";
    }

    protected String createTree(Class<?> clsObj, int id) {
        JSONObject rootNode;
        block8: {
            System.out.println("************************ \nLooking up [" + clsObj.getName() + "] node: " + id);
            rootNode = null;
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Treeable treeable = (Treeable)session.get(clsObj, id);
                    if (treeable != null) {
                        rootNode = this.createNode(treeable);
                    } else {
                        System.out.println("************************ \nCouldn't find [" + clsObj.getName() + "] node: " + id);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    session.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        if (rootNode != null) {
            JSONArray treeArray = new JSONArray();
            treeArray.add((Object)rootNode);
            System.out.println("Results ************************ \n" + treeArray.toString());
            return treeArray.toString();
        }
        return "{}";
    }

    protected Taxon getTaxonFromCollectionObject(CollectionObject co) {
        for (Determination det : co.getDeterminations()) {
            if (!det.isCurrentDet()) continue;
            return det.getPreferredTaxon();
        }
        return null;
    }

    protected String getTaxonImage(String fullName) {
        if (fullName != null) {
            String[] rows;
            String[] stringArray = rows = new String[]{"6792,Lutjanus sebae,Emperor red snapper", "6794,Trachinotus blochii,Snubnose pompano", "6796,Caranx sexfasciatus,Bigeye trevally", "6797,Gerres longirostris,Longtail silverbiddy", "6799,Hyporhamphus affinis,Tropical halfbeak", "6804,Chaetodon trifasciatus,Melon butterflyfish ", "6806,Cephalopholis miniata,Coral hind", "6810,Apolemichthys trimaculatus,Threespot angelfish", "6813,Parupeneus ciliatus,Whitesaddle goatfish", "6814,Zebrasoma scopas,Twotone tang ", "6854,Pomacanthus semicirculatus,Semicircle angelfish ", "6871,Pterois radiata,Radial firefish ", "6881,Oxymonacanthus longirostris,Harlequin filefish", "6887,Priacanthus blochii,Paeony bulleye", "6907,Sargocentron seychellense,Yellow-tipped squirrelfish", "6926,Myripristis berndti,Blotcheye soldierfish", "6927,Pempheris vanicolensis,Vanikoro sweeper", "6931,Pseudanthias squamipinnis,Sea goldie", "6960,Archamia fucata,Orangelined cardinalfish", "6961,Archamia fucata,Orangelined cardinalfish", "6964,Lutjanus bohar,Two-spot red snapper", "6965,Lutjanus kasmira,Common bluestripe snapper", "7031,Pempheris vanicolensis,Vanikoro sweeper", "7039,Myripristis violacea,Lattice soldierfish"};
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                String[] cols = StringUtils.split((String)row, (String)",");
                if (fullName.trim().equals(cols[1].trim())) {
                    return "T" + cols[0] + ".jpg";
                }
                ++n2;
            }
        }
        return null;
    }

    protected String fakeGetImageName(Object dataObj) {
        CollectingEvent ce;
        Locality loc;
        if (dataObj == null) {
            return null;
        }
        if (dataObj instanceof CollectionObject) {
            return this.fakeGetImageName(this.getTaxonFromCollectionObject((CollectionObject)dataObj));
        }
        if (dataObj instanceof Taxon) {
            Taxon tx = (Taxon)dataObj;
            String fullName = tx.getFullName();
            if (fullName.equals("Ammocrypta clara")) {
                return "WesternSandDarterLarge.jpg";
            }
            if (fullName.equals("Ammocrypta beanii")) {
                return "NakedSandDarterLarge.jpg";
            }
            return this.getTaxonImage(tx.getFullName());
        }
        if (dataObj instanceof Locality ? (loc = (Locality)dataObj).getId() == 3787 : dataObj instanceof CollectingEvent && (ce = (CollectingEvent)dataObj).getId() == 4479) {
            return "BSRiver.jpg";
        }
        return null;
    }

    protected String createJSONTable() {
        try {
            String[] headers = new String[]{"Company", "Price", "Change", "% Change", "Last Updated"};
            String[] dataIndexes = new String[]{"company", "price", "change", "pctChange", "lastChange"};
            String[] stringArray = new String[5];
            stringArray[1] = "usMoney";
            stringArray[4] = "Ext.util.Format.dateRenderer('m/d/Y')";
            String[] renders = stringArray;
            int[] widths = new int[]{160, 75, 75, 75, 85};
            Vector<JSONObject> colModelList = new Vector<JSONObject>();
            int i = 0;
            while (i < headers.length) {
                JSONObject colObj = new JSONObject();
                if (i == 0) {
                    colObj.accumulate("id", (Object)dataIndexes[i]);
                }
                colObj.accumulate("header", (Object)headers[i]);
                colObj.accumulate("width", widths[i]);
                colObj.accumulate("sortable", true);
                if (dataIndexes[i] != null) {
                    colObj.accumulate("dataIndex", (Object)dataIndexes[i]);
                }
                if (renders[i] != null) {
                    colObj.accumulate("renderer", (Object)renders[i]);
                }
                colModelList.add(colObj);
                ++i;
            }
            JSONArray colModel = new JSONArray();
            colModel.addAll(colModelList);
            System.out.println("COLMODEL: " + colModel.toString());
            String[] hdrName = new String[]{"company", "price", "change", "pctChange", "lastChange"};
            String[] hdrType = new String[]{"string", "float", "float", "float", "date"};
            Vector<JSONObject> colHdrList = new Vector<JSONObject>();
            int i2 = 0;
            while (i2 < hdrName.length) {
                JSONObject hdr = new JSONObject();
                hdr.accumulate("name", (Object)hdrName[i2]);
                hdr.accumulate("type", (Object)hdrType[i2]);
                if (hdrType[i2].equals("date")) {
                    hdr.accumulate("dateFormat", (Object)"n/j h:ia");
                }
                colHdrList.add(hdr);
                ++i2;
            }
            JSONArray headerModel = new JSONArray();
            headerModel.addAll(colHdrList);
            System.out.println("HEADER: " + headerModel.toString());
            Vector<JSONArray> dataList = new Vector<JSONArray>();
            int i3 = 0;
            while (i3 < 5) {
                Object[] data = new Object[]{"3m Co", 71.72, 0.02 + (double)i3, 0.03, "9/1 12:00am"};
                Vector<Object> dataItemList = new Vector<Object>();
                Object[] objectArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    dataItemList.add(o);
                    ++n2;
                }
                JSONArray row = new JSONArray();
                row.addAll(dataItemList);
                dataList.add(row);
                ++i3;
            }
            JSONArray dataModel = new JSONArray();
            dataModel.addAll(dataList);
            JSONObject json = new JSONObject();
            json.accumulate("column_model", (Object)colModel);
            json.accumulate("headers", (Object)headerModel);
            json.accumulate("rows", (Object)dataModel);
            System.out.println("===============");
            System.out.println(json.toString());
            System.out.println("===============");
            String colModelStr = "[{id:'company',header: \"Company\", width: 160, sortable: true, dataIndex: 'company'},{header: \"Price\", width: 75, sortable: true, renderer: 'usMoney', dataIndex: 'price'},{header: \"Change\", width: 75, sortable: true, dataIndex: 'change'},{header: \"% Change\", width: 75, sortable: true, dataIndex: 'pctChange'},{header: \"Last Updated\", width: 85, sortable: true, renderer: Ext.util.Format.dateRenderer('m/d/Y'), dataIndex: 'lastChange'}]";
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("rows:[['3m Co',71.72,0.02,0.03,'9/1 12:00am'],['2m Co',71.72,0.02,0.03,'9/1 12:00am']],");
            sb.append("headers:[{type:'string',name:'company'},{type:'float',name:'price'},{type:'float',name:'change'},{type:'float',name:'pctChange'},{type:'date',dateFormat:'n/j h:ia',name:'lastChange'}],");
            sb.append("column_model:" + colModelStr);
            sb.append("}");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("doPost -------------------------------");
        String treeSearch = request.getParameter("treeSearchStr");
        String treeType = request.getParameter("tree");
        String exeQuery = request.getParameter("exequery");
        String detail = request.getParameter("detail");
        System.out.println("detail cls[" + detail + "]");
        if (StringUtils.isNotEmpty((String)detail)) {
            block13: {
                String className = request.getParameter("cls");
                String idStr = request.getParameter("id");
                System.out.println("cls[" + className + "] id[" + idStr + "]");
                idStr = "4222";
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        Object dataObj = session.createQuery("FROM " + className + " WHERE id = " + idStr, false).list().get(0);
                        System.out.println(dataObj);
                        if (dataObj != null) {
                            this.processDataObj(out, (FormDataObjIFace)dataObj, true);
                            session.evict(dataObj);
                            break block13;
                        }
                        out.println("ID " + idStr + "couldn't be found.");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        session.close();
                    }
                }
                finally {
                    session.close();
                }
            }
            return;
        }
        if (StringUtils.isNotEmpty((String)treeSearch)) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.print(this.searchTree(treeSearch, treeType));
            out.flush();
            return;
        }
        String searchStr = request.getParameter("searchStr");
        System.out.println("searchStr[" + searchStr + "]");
        if (this.expressSearch == null) {
            this.expressSearch = new ExpressSearchTask();
            this.expressSearchExplorer = new ExplorerESPanel();
        } else {
            this.expressSearchExplorer.reset();
        }
        if (StringUtils.isNotEmpty((String)exeQuery)) {
            this.doQuery(request, response, exeQuery);
            return;
        }
        if (this.expressSearch.doQuery(searchStr, this.expressSearchExplorer)) {
            if (StringUtils.isNotEmpty((String)searchStr)) {
                JSONArray tableArray = this.expressSearchExplorer.getTables();
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.print(tableArray.toString());
                out.flush();
                return;
            }
            return;
        }
        super.doPost(request, response);
    }

    protected void doQuery(HttpServletRequest request, HttpServletResponse response, String queryName) throws IOException {
        block9: {
            Session session = null;
            try {
                try {
                    session = HibernateUtil.getNewSession();
                    SpQuery spQuery = (SpQuery)session.createQuery("FROM SpQuery WHERE name = '" + queryName + "'").list().get(0);
                    if (spQuery != null) {
                        if (this.queryTask == null) {
                            this.queryTask = new QueryTask();
                        }
                        this.expressSearchExplorer.reset();
                        QueryBldrPane qbPane = new QueryBldrPane("Query", (Taskable)this.queryTask, spQuery, true);
                        qbPane.setEsrp(this.expressSearchExplorer);
                        qbPane.doSearch();
                        JSONArray tableArray = this.expressSearchExplorer.getTables();
                        response.setContentType("text/html");
                        PrintWriter out = response.getWriter();
                        out.print(tableArray.toString());
                        out.flush();
                        qbPane.setEsrp(null);
                        break block9;
                    }
                    System.out.println("Couldn't find the query with name = " + queryName);
                    PrintWriter out = response.getWriter();
                    out.print("Couldn't find the query with name = " + queryName);
                    out.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (session != null) {
                        session.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
    }

    protected void doQuery(HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
    }

    protected void showQueryIndex(HttpServletResponse response) throws IOException {
        int inx;
        PrintWriter out;
        block9: {
            response.setContentType("text/html");
            out = response.getWriter();
            inx = template.indexOf(contentTag);
            String subContent = template.substring(0, inx);
            out.println(StringUtils.replace((String)subContent, (String)"<!-- Title -->", (String)"Queries"));
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    Properties props = new Properties();
                    int cnt = 0;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<BR><table width=\"100%\" cellspacing=\"0\" class=\"brdr\">\n");
                    List<?> list = session.getDataList("SELECT sq.id, sq.name FROM SpQuery sq INNER JOIN sq.specifyUser spu WHERE spu.id = " + AppContextMgr.getInstance().getClassObject(SpecifyUser.class).getId());
                    for (Object rowObj : list) {
                        Object[] cols = (Object[])rowObj;
                        props.clear();
                        props.put("id", cols[0]);
                        props.put("query", "1");
                        String anchor = this.makeURLLink(null, cols[1].toString(), props);
                        sb.append("<tr><td class=\"brdr" + (cnt % 2 == 0 ? "even" : "odd") + "\">" + anchor + "</td></tr>\n");
                        ++cnt;
                    }
                    sb.append("</TABLE>");
                    out.println(sb.toString());
                }
                catch (SQLGrammarException ex) {
                    this.log.error((Object)ex);
                    if (session != null) {
                        session.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        out.println(template.substring(inx + contentTag.length() + 1, template.length()));
    }

    protected void doReport(final HttpServletRequest request, final HttpServletResponse response) {
        block8: {
            JasperReportHelper jrh = new JasperReportHelper(new JasperReportHelper.JasperReportHelperListener(){

                @Override
                public void complete(JasperPrint jasperPrint) {
                    PrintWriter out = null;
                    try {
                        out = response.getWriter();
                        response.setHeader("Expires", "0");
                        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                        response.setHeader("Pragma", "public");
                        JRHtmlExporter exporter = new JRHtmlExporter();
                        request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)out);
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"http://localhost/specifyexplorer/");
                        exporter.exportReport();
                        out.close();
                    }
                    catch (JRException ex) {
                        ex.printStackTrace();
                        out.println(ex.toString());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public void completedWithError() {
                    try {
                        response.setContentType("text/html");
                        PrintWriter out = response.getWriter();
                        out.println(" Error creating report.");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public void status(int status) {
                }
            }, false);
            DataProviderSessionIFace session = null;
            try {
                try {
                    session = DataProviderFactory.getInstance().createSession();
                    RecordSet rs = (RecordSet)session.createQuery("from RecordSet where id = 1", false).list().get(0);
                    if (rs != null) {
                        Properties params = new Properties();
                        String reportName = "fish_label.jrxml";
                        params.put("name", reportName);
                        params.put("file", reportName);
                        params.put("reqrs", "true");
                        params.put("title", "Fish Label");
                        jrh.createReport(reportName, rs, params);
                        break block8;
                    }
                    try {
                        response.setContentType("text/html");
                        PrintWriter out = response.getWriter();
                        out.println("Couldn't Locate RecordSet");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    session.close();
                }
            }
            finally {
                session.close();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String className = request.getParameter("cls");
        String idStr = request.getParameter("id");
        String letter = request.getParameter("ltr");
        String treeStr = request.getParameter("tree");
        String query = request.getParameter("query");
        String cmd = request.getParameter("cmd");
        if (StringUtils.isNotEmpty((String)cmd)) {
            if (cmd.equals("query")) {
                if (StringUtils.isEmpty((String)idStr)) {
                    this.queryHandler.listQueries(request, response);
                }
            } else if (cmd.equals("reports")) {
                if (StringUtils.isEmpty((String)idStr)) {
                    this.queryHandler.listSpReports(request, response);
                } else {
                    this.queryHandler.doReport(request, response);
                }
            }
            return;
        }
        if (StringUtils.isNotEmpty((String)treeStr)) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            int id = Integer.parseInt(idStr);
            if (id > 0) {
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getByShortClassName(treeStr);
                out.print(this.createTree(tableInfo.getClassObj(), id));
            }
            out.flush();
            return;
        }
        if (StringUtils.isNotEmpty((String)idStr) && idStr.equals("report")) {
            this.doReport(request, response);
            return;
        }
        if (StringUtils.isNotEmpty((String)query) && !StringUtils.isNotEmpty((String)idStr)) {
            this.showQueryIndex(response);
            return;
        }
        if (StringUtils.isEmpty((String)idStr) && StringUtils.isEmpty((String)className)) {
            idStr = "search";
        }
        if (StringUtils.isNotEmpty((String)idStr)) {
            if (idStr.equals("genCEChart")) {
                this.generateCEChart(request, response);
                return;
            }
            if (idStr.equals("genCOChart")) {
                this.generateColObjChart(request, response);
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            if (idStr.equals("search")) {
                this.displayAllSearchables(out);
            } else if (idStr.equals("dspsrch")) {
                this.displaySearchForm(out, String.valueOf(this.packageName) + className);
            } else if (idStr.equals("dosearch")) {
                this.processSearch(out, String.valueOf(this.packageName) + className, request);
            } else if (idStr.equals("map")) {
                this.createMap(out, request.getParameter("points"), true);
            } else if (idStr.equals("ChartCE")) {
                this.chartIt(out, "genCEChart", "CollectingEvents By Year");
            } else if (idStr.equals("ChartCO")) {
                this.chartIt(out, "genCOChart", "Cataloged By Year");
            } else {
                DataProviderSessionIFace session = null;
                try {
                    try {
                        session = DataProviderFactory.getInstance().createSession();
                        Object dataObj = session.createQuery("from " + className + " where id = " + idStr, false).list().get(0);
                        if (dataObj != null) {
                            this.processDataObj(out, (FormDataObjIFace)dataObj, true);
                        }
                        out.println("ID " + idStr + "couldn't be found.");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        session.close();
                    }
                }
                finally {
                    session.close();
                }
            }
        } else {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            if (className.equals("Taxon")) {
                String sql = "SELECT DISTINCT taxon.TaxonID, taxon.FullName   FROM determination  INNER JOIN taxon ON determination.TaxonID = taxon.TaxonID  WHERE determination.IsCurrent = true AND taxon.TaxonTreeDefID = TAXTREEDEFID ORDER BY taxon.FullName ASC";
                sql = QueryAdjusterForDomain.getInstance().adjustSQL(sql);
                this.doAlphaIndexPageSQL(out, className, letter, 1, null, sql);
            } else {
                ClassDisplayInfo cdi = this.classHash.get(className);
                if (cdi != null) {
                    this.doAlphaIndexPage(out, className, cdi.getIndexName(), letter);
                } else {
                    out.println("Bad Class name[" + className + "]");
                }
            }
        }
    }

    class CEForPoly {
        protected Calendar startDate;
        protected Double lat;
        protected Double lon;
        protected String title;
        protected List<CollectionObject> colObjs = new Vector<CollectionObject>();

        public CEForPoly(Calendar startDate, Double lat, Double lon, String title) {
            this.startDate = startDate;
            this.lat = lat;
            this.lon = lon;
            this.title = title;
        }

        public Calendar getStartDate() {
            return this.startDate;
        }

        public Double getLat() {
            return this.lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public String getTitle() {
            return this.title;
        }

        public List<CollectionObject> getColObjs() {
            return this.colObjs;
        }
    }

    class MyFmtMgr
    extends SpecifyUIFieldFormatterMgr {
        public MyFmtMgr() {
            this.load();
        }

        @Override
        protected Element getDOM() throws Exception {
            return XMLHelper.readDOMFromConfigDir("backstop/uiformatters.xml");
        }

        public UIFieldFormatterIFace getFmt(String name) {
            return this.getFormatterInternal(name);
        }
    }

    class NameId
    implements Comparable<NameId> {
        protected String name;
        protected int id;
        protected Integer num;

        public NameId(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public NameId(String name, int id, Integer num) {
            this(name, id);
            this.num = num;
        }

        public void add() {
            ++this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public Integer getNum() {
            return this.num;
        }

        @Override
        public int compareTo(NameId arg0) {
            return this.num != null ? this.num.compareTo(arg0.num) : this.name.compareTo(arg0.name);
        }
    }
}

