/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.web;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.JasperReportsCache;
import edu.ku.brc.specify.tasks.subpane.ReportCompileInfo;
import edu.ku.brc.specify.web.JasperCompilerListener;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JLabel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class JasperReportHelper
implements AsynchronousFilllListener,
JasperCompilerListener {
    private static final Logger log = Logger.getLogger(JasperReportHelper.class);
    protected JasperReportHelperListener listener;
    protected boolean isAsynchronous;
    protected AsynchronousFillHandle asyncFillHandler = null;
    protected JLabel label = null;
    protected JasperCompilerRunnable compiler = null;
    protected RecordSetIFace recordSet = null;
    protected JRDataSource dataSource = null;
    protected File cachePath = null;
    protected Properties params = null;
    protected boolean requiresHibernate = false;
    protected Session session = null;

    public JasperReportHelper(JasperReportHelperListener listener, boolean isAsynchronous) {
        this.listener = listener;
        this.isAsynchronous = isAsynchronous;
        this.cachePath = JasperReportsCache.checkAndCreateReportsCache();
        JasperReportsCache.refreshCacheFromDatabase();
    }

    public void createReport(String mainReportName, Object data, Properties paramsArg) {
        File reportPath;
        if (data instanceof RecordSetIFace) {
            this.recordSet = (RecordSetIFace)data;
            this.dataSource = null;
        } else if (data instanceof JRDataSource) {
            this.recordSet = null;
            this.dataSource = (JRDataSource)data;
        }
        this.params = paramsArg;
        JasperReportsCache.refreshCacheFromDatabase();
        Vector<File> reportFiles = new Vector<File>();
        AppResourceIFace appRes = AppContextMgr.getInstance().getResource(mainReportName);
        if (appRes != null) {
            String subReportsStr = appRes.getMetaData("subreports");
            String hqlStr = appRes.getMetaData("hql");
            if (StringUtils.isNotEmpty((String)hqlStr)) {
                this.requiresHibernate = Boolean.parseBoolean(hqlStr.toLowerCase());
            }
            if (StringUtils.isNotEmpty((String)subReportsStr)) {
                String[] subReportNames;
                String[] stringArray = subReportNames = subReportsStr.split(",");
                int n = subReportNames.length;
                int n2 = 0;
                while (n2 < n) {
                    File subReportPath;
                    String subReportName = stringArray[n2];
                    AppResourceIFace subReportAppRes = AppContextMgr.getInstance().getResource(subReportName);
                    if (subReportAppRes != null) {
                        subReportPath = new File(this.cachePath.getAbsoluteFile() + File.separator + subReportName);
                        if (!subReportPath.exists()) {
                            throw new RuntimeException("Subreport doesn't exist on disk [" + subReportPath.getAbsolutePath() + "]");
                        }
                    } else {
                        throw new RuntimeException("Couldn't load subreport [" + mainReportName + "]");
                    }
                    reportFiles.add(subReportPath);
                    ++n2;
                }
            }
            if (!(reportPath = new File(this.cachePath.getAbsoluteFile() + File.separator + mainReportName)).exists()) {
                throw new RuntimeException("Subreport doesn't exist on disk [" + reportPath.getAbsolutePath() + "]");
            }
        } else {
            throw new RuntimeException("Couldn't load report/label [" + mainReportName + "]");
        }
        reportFiles.add(reportPath);
        boolean allAreCompiled = true;
        Vector<ReportCompileInfo> files = new Vector<ReportCompileInfo>();
        for (File file : reportFiles) {
            ReportCompileInfo info = JasperReportsCache.checkReport(file);
            files.add(info);
            if (info.isCompiled()) continue;
            allAreCompiled = false;
        }
        if (allAreCompiled) {
            System.out.println("Everything is compiled");
            this.compileComplete(((ReportCompileInfo)files.get(files.size() - 1)).getCompiledFile());
        } else {
            System.out.println("About to Compile " + this.isAsynchronous);
            this.compiler = new JasperCompilerRunnable(this, files);
            if (this.isAsynchronous) {
                this.compiler.start();
            } else {
                this.compiler.run();
            }
        }
    }

    @Override
    public void compileComplete(File compiledFile) {
        if (compiledFile != null) {
            try {
                System.out.println("Creating report...");
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((File)compiledFile.getAbsoluteFile());
                if (jasperReport != null) {
                    System.out.println("Loaded report...");
                    HashMap<Object, Object> parameters = new HashMap<Object, Object>();
                    parameters.put("RPT_IMAGE_DIR", JasperReportsCache.getImagePath().getAbsolutePath());
                    parameters.put("SUBREPORT_DIR", this.cachePath.getAbsoluteFile() + File.separator);
                    parameters.put("DATASOURCE", this.dataSource);
                    if (this.recordSet != null) {
                        parameters.put("itemnum", DBTableIdMgr.getInstance().getInClause(this.recordSet));
                    }
                    if (this.params != null) {
                        for (Object key : this.params.keySet()) {
                            parameters.put(key, this.params.get(key));
                        }
                    }
                    if (this.requiresHibernate) {
                        this.session = HibernateUtil.getNewSession();
                        parameters.put("HIBERNATE_SESSION", this.session);
                    }
                    if (this.isAsynchronous) {
                        System.out.println("Filling report asynchronously...");
                        this.asyncFillHandler = this.recordSet != null ? AsynchronousFillHandle.createHandle((JasperReport)jasperReport, parameters, (Connection)DBConnection.getInstance().getConnection()) : AsynchronousFillHandle.createHandle((JasperReport)jasperReport, parameters, (JRDataSource)this.dataSource);
                        this.asyncFillHandler.addListener((AsynchronousFilllListener)this);
                        this.asyncFillHandler.startFill();
                    } else {
                        System.out.println("Filling report synchronously...");
                        JasperPrint jasperPrint = this.recordSet != null ? JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (Connection)DBConnection.getInstance().getConnection()) : JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)this.dataSource);
                        if (jasperPrint != null) {
                            this.listener.complete(jasperPrint);
                        } else {
                            this.listener.completedWithError();
                        }
                    }
                } else {
                    log.error((Object)("jasperReport came back null [" + compiledFile.getAbsolutePath() + "]"));
                }
            }
            catch (JRException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(JasperReportHelper.class, (Exception)((Object)ex));
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
        this.compiler = null;
    }

    public void reportCancelled() {
        this.asyncFillHandler = null;
    }

    protected void closeSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(JasperReportHelper.class, ex);
                log.error((Object)ex);
            }
        }
    }

    public void reportFillError(Throwable t) {
        log.error((Object)t);
        t.printStackTrace();
        this.asyncFillHandler = null;
        this.closeSession();
    }

    public void reportFinished(JasperPrint print) {
        try {
            this.listener.complete(print);
            this.closeSession();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JasperReportHelper.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
        this.asyncFillHandler = null;
    }

    public class JasperCompilerRunnable
    implements Runnable {
        protected Thread thread;
        protected JasperCompilerListener compileListener;
        protected Vector<ReportCompileInfo> files;

        public JasperCompilerRunnable(JasperCompilerListener listener, Vector<ReportCompileInfo> files) {
            this.compileListener = listener;
            this.files = files;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                for (ReportCompileInfo info : this.files) {
                    JasperCompileManager.compileReportToFile((String)info.getReportFile().getAbsolutePath(), (String)info.getCompiledFile().getAbsolutePath());
                }
                System.out.println("Done  Compiling...");
                this.compileListener.compileComplete(this.files.get(this.files.size() - 1).getCompiledFile());
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(JasperReportHelper.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
                this.compileListener.compileComplete(null);
            }
            this.compileListener = null;
            this.files.clear();
            this.files = null;
        }
    }

    public static interface JasperReportHelperListener {
        public void complete(JasperPrint var1);

        public void status(int var1);

        public void completedWithError();
    }
}

